/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Vector;
import jd.captcha.ColorLetterComperator;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.JDImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectItOrg {
    static ArrayList<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        int x = 0;
        while (x < grid.getWidth()) {
            int y = 0;
            while (y < grid.getHeight()) {
                if (grid.getGrid()[x][y] != -3151923) {
                    PixelObject n = new PixelObject(grid);
                    n.add(x, y, grid.getGrid()[x][y]);
                    ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                    for (PixelObject o : ret) {
                        if (!o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                        merge.add(o);
                    }
                    if (merge.size() == 0) {
                        ret.add(n);
                    } else if (merge.size() == 1) {
                        ((PixelObject)merge.get(0)).add(n);
                    } else {
                        for (PixelObject po : merge) {
                            ret.remove(po);
                            n.add(po);
                        }
                        ret.add(n);
                    }
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) throws Exception {
        captcha.crop(257, 140, 0, 0);
        ArrayList<Letter> let = new ArrayList<Letter>();
        Vector<PixelObject> objs = captcha.getObjects(0.7, 0.7);
        Collections.sort(objs);
        for (PixelObject pixelObject : objs) {
            if (pixelObject.getArea() <= 3) continue;
            let.add(pixelObject.toLetter());
        }
        int c = 0;
        ListIterator iterator = let.listIterator(let.size());
        while (iterator.hasPrevious() && c++ < 10) {
            iterator.previous();
            iterator.remove();
        }
        Letter[] lets = let.toArray(new Letter[0]);
        String code = "";
        Letter[] letterArray = lets;
        int n = lets.length;
        int n2 = 0;
        while (n2 < n) {
            Letter letter = letterArray[n2];
            LetterComperator r = captcha.owner.getLetter(letter);
            code = String.valueOf(code) + r.getDecodedValue();
            letter.detected = r;
            ++n2;
        }
        File imageFile = captcha.owner.getResourceFile("images/" + code + ".png");
        if (imageFile.exists()) {
            captcha.reset();
            Captcha pixToFind = captcha.owner.createCaptcha(JDImage.getImage((File)imageFile));
            Letter l = captcha.createLetter();
            l.setGrid(pixToFind.grid);
            BackGroundImageManager bgit = new BackGroundImageManager(captcha);
            bgit.clearCaptchaAll();
            captcha.crop(0, 0, 0, 10);
            ArrayList<PixelObject> obj = ProtectItOrg.getObjects(captcha, 3);
            ColorLetterComperator mainCLC = new ColorLetterComperator(l, l);
            double bestVal = 1.0E7;
            PixelGrid bestLetter = null;
            for (PixelObject pixelObject : obj) {
                if (pixelObject.getWidth() > 63 || pixelObject.getHeight() > 63) {
                    PixelObject[] objb;
                    PixelObject[] pixelObjectArray = objb = pixelObject.splitAt(62);
                    int n3 = objb.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PixelObject pixelObject2 = pixelObjectArray[n4];
                        if (pixelObject.getHeight() > 63) {
                            PixelObject[] objb2;
                            PixelObject[] pixelObjectArray2 = objb2 = pixelObject2.horizintalSplitAt(62);
                            int n5 = objb2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                PixelObject pixelObject3 = pixelObjectArray2[n6];
                                Letter b = pixelObject3.toColoredLetter();
                                mainCLC.setLetterB(b);
                                double val = mainCLC.run();
                                if (val < bestVal) {
                                    bestLetter = b;
                                    bestVal = val;
                                }
                                ++n6;
                            }
                        } else {
                            Letter b = pixelObject2.toColoredLetter();
                            mainCLC.setLetterB(b);
                            double val = mainCLC.run();
                            if (val < bestVal) {
                                bestLetter = b;
                                bestVal = val;
                            }
                        }
                        ++n4;
                    }
                    continue;
                }
                Letter b = pixelObject.toColoredLetter();
                mainCLC.setLetterB(b);
                double val = mainCLC.run();
                if (!(val < bestVal)) continue;
                bestLetter = b;
                bestVal = val;
            }
            int x = bestLetter.getLocation()[0] + bestLetter.getWidth() / 2;
            int y = bestLetter.getLocation()[1] + bestLetter.getHeight() / 2;
            char[] tx = (String.valueOf(x) + ":" + y).toCharArray();
            Letter[] ret = new Letter[tx.length];
            int i = 0;
            while (i < tx.length) {
                Letter re = new Letter();
                re.setDecodedValue("" + tx[i]);
                LetterComperator let1 = new LetterComperator(re, re);
                let1.setValityPercent(0.0);
                re.detected = let1;
                ret[i] = re;
                ++i;
            }
            return ret;
        }
        return null;
    }

    public static Letter[] letterFilter(Letter[] org, JAntiCaptcha jac) {
        return org;
    }
}

