/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scm {
    private static void mergeObjects(Vector<PixelObject> os) {
        for (PixelObject a : os) {
            for (PixelObject b : os) {
                if (a == b) continue;
                int xMin = Math.max(a.getXMin(), b.getXMin());
                int xMax = Math.min(a.getXMin() + a.getWidth(), b.getXMin() + b.getWidth());
                if (xMax + 1 < xMin) continue;
                int yMin = Math.max(a.getYMin(), b.getYMin());
                int yMax = Math.min(a.getYMin() + a.getHeight(), b.getYMin() + b.getHeight());
                if (xMax - xMin >= 30 || yMax - yMin >= 30) continue;
                a.add(b);
                os.remove(b);
                Scm.mergeObjects(os);
                return;
            }
        }
    }

    private static void clean(Captcha captcha) {
        int p;
        int mv = captcha.getMaxPixelValue();
        int x = 0;
        while (x < captcha.getWidth()) {
            p = captcha.getPixelValue(x, 1);
            if (p != mv) {
                captcha.cleanByColor(p, 1.0);
            }
            ++x;
        }
        int y = 0;
        while (y < captcha.getHeight()) {
            p = captcha.getPixelValue(1, y);
            if (p != mv) {
                captcha.cleanByColor(p, 1.0);
            }
            ++y;
        }
    }

    public static Letter[] getLetters(Captcha captcha) {
        Scm.clean(captcha);
        captcha.toBlackAndWhite(0.95);
        Vector<PixelObject> os = captcha.getObjects(0.5, 0.5);
        Collections.sort(os);
        Scm.mergeObjects(os);
        ArrayList<Letter> ret = new ArrayList<Letter>();
        for (PixelObject pixelObject : os) {
            if (pixelObject.getArea() <= 50) continue;
            Letter let = pixelObject.toLetter();
            let.removeSmallObjects(0.75, 0.75, 6);
            let.resizetoHeight(25);
            ret.add(let);
        }
        return ret.toArray(new Letter[0]);
    }
}

