/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.Color;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.nutils.Colors;

public class UploadBox {
    private static void clean(Captcha captcha) {
        int[][] newgrid = new int[captcha.getWidth()][captcha.getHeight()];
        Color lastC = null;
        int[] lastpos = new int[2];
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                int p = captcha.getPixelValue(x, y);
                Color c = new Color(p);
                if (c.getBlue() > 180 && c.getRed() > 180 && c.getGreen() > 180) {
                    if (lastC == null || Math.abs(lastpos[0] - x) + Math.abs(lastpos[1] - y) >= 1 || !(Colors.getColorDifference((int)lastC.getRGB(), (int)c.getRGB()) < 80.0)) {
                        PixelGrid.setPixelValue(x, y, newgrid, captcha.getMaxPixelValue());
                    } else {
                        newgrid[x][y] = captcha.grid[x][y];
                    }
                } else {
                    newgrid[x][y] = captcha.grid[x][y];
                    lastC = c;
                    lastpos = new int[]{x, y};
                }
                ++y;
            }
            ++x;
        }
        captcha.grid = newgrid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getGapAt(Captcha captcha, int position) {
        int avg = captcha.getAverage();
        int empty = -1;
        int x = position - 5;
        while (x < position + 5) {
            if (captcha.getPixelValue(x, 25) != avg) {
                if (empty != -1) return x;
                ++empty;
            } else {
                empty = empty > 5 ? -1 : ++empty;
            }
            ++x;
        }
        x = position - 5;
        while (x < position + 5) {
            if (captcha.getPixelValue(x, 24) != avg) {
                if (empty != -1) return x;
                ++empty;
            } else {
                empty = empty > 5 ? -1 : ++empty;
            }
            ++x;
        }
        x = position - 5;
        while (x < position + 5) {
            if (captcha.getPixelValue(x, 26) != avg) {
                if (empty != -1) return x;
                ++empty;
            } else {
                empty = empty > 5 ? -1 : ++empty;
            }
            ++x;
        }
        return position;
    }

    private static int[] getGaps(Captcha captcha) {
        return new int[]{UploadBox.getGapAt(captcha, 25), UploadBox.getGapAt(captcha, 50), UploadBox.getGapAt(captcha, 75), UploadBox.getGapAt(captcha, 100), UploadBox.getGapAt(captcha, 125), 150};
    }

    public static Letter[] getLetters(Captcha captcha) {
        UploadBox.clean(captcha);
        captcha.removeSmallObjects(0.75, 0.75, 6);
        captcha.toBlackAndWhite(0.95);
        return captcha.getLetters(6, UploadBox.getGaps(captcha));
    }
}

