/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.langfileeditor;

import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfo
implements Comparable<KeyInfo> {
    private final String key;
    private String source = "";
    private String language = "";
    private String english = "";
    private int sourceParameterCount = -1;
    private int languageParameterCount = -1;

    public KeyInfo(String key, String source, String language, String english) {
        this.key = key;
        this.setSource(source);
        this.setEnglish(english);
        this.setLanguage(language);
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSource() {
        return this.source;
    }

    public String getEnglish() {
        return this.english;
    }

    public boolean hasWrongParameterCount() {
        return this.sourceParameterCount != -1 && this.languageParameterCount != -1 && this.sourceParameterCount != this.languageParameterCount;
    }

    public void setLanguage(String language) {
        if (language != null) {
            this.language = language;
            this.languageParameterCount = language.equals("") ? -1 : new Regex(language, "\\%s").count();
        }
    }

    public void setSource(String source) {
        if (source != null) {
            this.source = source;
            this.sourceParameterCount = source.equals("") ? -1 : new Regex(source, "\\%s").count();
        }
    }

    public void setEnglish(String english) {
        if (english != null) {
            this.english = english;
        }
    }

    public boolean isMissing() {
        return this.getLanguage().equals("") && !this.getSource().equals("");
    }

    public boolean isOld() {
        return !this.getLanguage().equals("") && this.getSource().equals("");
    }

    @Override
    public int compareTo(KeyInfo o) {
        return this.getKey().compareToIgnoreCase(o.getKey());
    }

    public String toString() {
        return String.valueOf(this.getKey()) + " = " + this.getLanguage();
    }
}

