/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.langfileeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.plugins.optional.langfileeditor.KeyInfo;
import jd.plugins.optional.langfileeditor.LFEGui;
import jd.plugins.optional.langfileeditor.columns.EnglishColumn;
import jd.plugins.optional.langfileeditor.columns.KeyColumn;
import jd.plugins.optional.langfileeditor.columns.LanguageColumn;
import jd.plugins.optional.langfileeditor.columns.SourceColumn;
import jd.utils.locale.JDL;

public class LFETableModel
extends JDTableModel {
    public static final int SORT_KEY = 0;
    public static final int SORT_SOURCE = 1;
    public static final int SORT_LANGUAGE = 2;
    public static final int SORT_ENGLISH = 3;
    private static final long serialVersionUID = -1775792404758292253L;
    private static final String LOCALE_PREFIX = "plugins.optional.langfileeditor.";
    private Integer sorting = 0;
    private Boolean toggle = true;
    private LFEGui gui;

    public LFETableModel(LFEGui gui) {
        super("lfetable");
        this.gui = gui;
    }

    public void setSorting(int sorting, boolean toggle) {
        this.sorting = sorting;
        this.toggle = toggle;
        this.refreshModel();
        this.fireTableDataChanged();
    }

    public LFEGui getGui() {
        return this.gui;
    }

    protected void initColumns() {
        this.addColumn((JDTableColumn)new KeyColumn(JDL.L((String)"plugins.optional.langfileeditor.key", (String)"Key"), this));
        this.addColumn((JDTableColumn)new SourceColumn(JDL.L((String)"plugins.optional.langfileeditor.sourceValue", (String)"Default Value"), this));
        this.addColumn((JDTableColumn)new EnglishColumn(JDL.L((String)"plugins.optional.langfileeditor.english", (String)"en.loc"), this));
        this.addColumn((JDTableColumn)new LanguageColumn(JDL.L((String)"plugins.optional.langfileeditor.languageFileValue", (String)"Language File Value"), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
            if (this.sorting != null && this.toggle != null) {
                Collections.sort(this.gui.getData(), new Comparator<KeyInfo>(){

                    @Override
                    public int compare(KeyInfo o1, KeyInfo o2) {
                        if (!LFETableModel.this.toggle.booleanValue()) {
                            return this.compareInner(o2, o1);
                        }
                        return this.compareInner(o1, o2);
                    }

                    private int compareInner(KeyInfo o1, KeyInfo o2) {
                        switch (LFETableModel.this.sorting) {
                            case 0: {
                                return o1.getKey().compareToIgnoreCase(o2.getKey());
                            }
                            case 1: {
                                return o1.getSource().compareToIgnoreCase(o2.getSource());
                            }
                            case 2: {
                                return o1.getLanguage().compareToIgnoreCase(o2.getLanguage());
                            }
                            case 3: {
                                return o1.getEnglish().compareToIgnoreCase(o2.getEnglish());
                            }
                        }
                        return 0;
                    }
                });
            }
            this.list.addAll(this.gui.getData());
        }
    }
}

