/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.nutils.JDImage;
import jd.nutils.Screen;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingworker.SwingWorker;

public class Balloon {
    private static final int GAP = 20;
    private static final int MAX = 5;
    private static ArrayList<JWindow> WINDOWS = null;
    public static int COUNTDOWN = 10000;
    private static String LASTSTRING;

    public static void showIfHidden(String title, ImageIcon icon, String htmlmessage) {
        if (SwingGui.getInstance() != null && !SwingGui.getInstance().getMainFrame().isActive()) {
            Balloon.show(title, icon, htmlmessage);
        }
    }

    public static void show(String title, ImageIcon icon, String htmlmessage) {
        Balloon.show(title, null, icon, htmlmessage);
    }

    public static void show(String title, ImageIcon ii, ImageIcon icon, String htmlmessage) {
        if (LASTSTRING != null && LASTSTRING.equals(String.valueOf(title) + htmlmessage)) {
            return;
        }
        LASTSTRING = String.valueOf(title) + htmlmessage;
        Balloon.show(title, ii, Balloon.createDefault(icon, htmlmessage));
    }

    public static void show(final String title, ImageIcon ii, final JPanel panel) {
        if (!GUIUtils.getConfig().getBooleanProperty("PARAM_SHOW_BALLOON", true).booleanValue()) {
            return;
        }
        final ImageIcon icon = ii == null ? new ImageIcon(JDImage.getImage((String)"logo/logo_16_16")) : ii;
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                final JWindow w = new JWindow(){
                    private static final long serialVersionUID = 8925461815465551749L;
                    private transient SwingWorker<Object, Object> timer;

                    public void dispose() {
                        Balloon.remove(this);
                        super.dispose();
                    }

                    public void setVisible(boolean b) {
                        if (b) {
                            Balloon.add(this);
                            this.timer = new SwingWorker<Object, Object>(){

                                protected Object doInBackground() throws Exception {
                                    Thread.sleep(COUNTDOWN);
                                    return null;
                                }

                                public void done() {
                                    try {
                                        if (this.isVisible()) {
                                            this.setVisible(false);
                                            this.dispose();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            this.timer.execute();
                        } else {
                            this.timer.cancel(true);
                            this.timer = null;
                        }
                        super.setVisible(b);
                    }
                };
                JLabel lbl = new JLabel(title);
                lbl.setIcon(icon);
                JLabel bt = new JLabel("[X]");
                bt.addMouseListener(new JDMouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        w.setVisible(false);
                        w.dispose();
                    }
                });
                JPanel titlePanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill][]"));
                titlePanel.addMouseListener(new JDMouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        SwingGui.getInstance().getMainFrame().setVisible(true);
                        SwingGui.getInstance().getMainFrame().toFront();
                    }
                });
                titlePanel.add(lbl);
                titlePanel.add((Component)bt, "aligny top,alignx right");
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createLineBorder(container.getBackground().darker()));
                container.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[grow,fill]", "[][][grow,fill]"));
                container.add(titlePanel);
                container.add((Component)new JSeparator(), "growx,pushx");
                container.add(panel);
                w.setMinimumSize(new Dimension(100, 40));
                w.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
                w.add(container);
                w.pack();
                w.setVisible(true);
                w.setAlwaysOnTop(true);
                return null;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void add(JWindow window) {
        if (WINDOWS == null) {
            WINDOWS = new ArrayList();
        }
        ArrayList<JWindow> arrayList = WINDOWS;
        synchronized (arrayList) {
            WINDOWS.add(window);
        }
        if (WINDOWS.size() > 5) {
            JWindow win = WINDOWS.remove(0);
            win.dispose();
        } else {
            Balloon.layout();
        }
    }

    private static synchronized void layout() {
        int y = 0;
        int width = 0;
        for (JWindow w : WINDOWS) {
            try {
                width = Math.max(Math.min((int)w.getPreferredSize().getWidth(), 350), width);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (JWindow w : WINDOWS) {
            try {
                w.setSize(width, w.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (JWindow w : WINDOWS) {
            try {
                Balloon.locate(w, y);
                y += w.getHeight() + 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void remove(JWindow window) {
        ArrayList<JWindow> arrayList = WINDOWS;
        synchronized (arrayList) {
            WINDOWS.remove(window);
        }
        Balloon.layout();
    }

    private static void locate(JWindow w, int y) {
        Point point = Screen.getDockBottomRight((Component)w);
        point.x -= 20;
        point.y -= 20 + y;
        w.setLocation(point);
    }

    private static JPanel createDefault(final ImageIcon ii, final String string2) {
        return (JPanel)new GuiRunnable<JPanel>(){

            @Override
            public JPanel runSave() {
                JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]"));
                if (ii != null) {
                    p.add((Component)new JLabel(ii), "split 2,alignx left, aligny top");
                }
                JTextPane textField = new JTextPane();
                p.add((Component)textField, "pushx,growx");
                textField.setContentType("text/html");
                textField.setBorder(null);
                textField.setOpaque(false);
                textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                textField.setText(string2);
                textField.setEditable(false);
                textField.addHyperlinkListener(JLink.getHyperlinkListener());
                return p;
            }
        }.getReturnValue();
    }
}

