/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jd.gui.swing.components.JDFileChooser;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class BrowseFile
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String approveButtonText = "OK";
    private JButton btnBrowse;
    private File currentPath;
    private boolean editable = false;
    private int fileSelectionMode = 0;
    private JTextField txtInput;

    public BrowseFile() {
        this(null);
    }

    public BrowseFile(LayoutManager layout) {
        super(layout != null ? layout : new MigLayout("ins 0", "[grow 100,fill,160:null:null]3[grow 30,fill]"));
        this.initGUI();
    }

    public void actionPerformed(ActionEvent e) {
        File newPath;
        ActionEvent event = new ActionEvent(this, 1001, "");
        if (e.getSource() == this.txtInput) {
            File newPath2 = new File(this.txtInput.getText());
            this.setCurrentPath(newPath2);
            this.dispatchEvent(event);
        } else if (e.getSource() == this.btnBrowse && (newPath = this.getPath()) != null) {
            this.setCurrentPath(newPath);
            this.dispatchEvent(event);
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public File getCurrentPath() {
        return this.currentPath;
    }

    private File getDirectoryFromTxtInput() {
        File directory = null;
        String stringPath = this.txtInput.getText();
        if (stringPath != null) {
            directory = new File(this.txtInput.getText());
            if (directory.exists()) {
                if (directory.isFile()) {
                    directory = directory.getParentFile();
                }
            } else {
                directory = null;
            }
        }
        return directory;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private File getPath() {
        JDFileChooser fc = new JDFileChooser();
        fc.setApproveButtonText(this.approveButtonText);
        fc.setFileSelectionMode(this.fileSelectionMode);
        fc.setCurrentDirectory(this.getDirectoryFromTxtInput());
        if (fc.showOpenDialog(this) == 0) {
            File ret = fc.getSelectedFile();
            return ret;
        }
        return null;
    }

    public String getText() {
        return this.txtInput.getText();
    }

    private void initGUI() {
        this.txtInput = new JTextField();
        this.txtInput.setEditable(this.editable);
        this.txtInput.addActionListener(this);
        this.btnBrowse = new JButton(JDL.L((String)"gui.btn_select", (String)"Browse"));
        this.btnBrowse.addActionListener(this);
        this.add(this.txtInput);
        this.add(this.btnBrowse);
    }

    public void setApproveButtonText(String approveButtonText) {
        this.approveButtonText = approveButtonText;
    }

    public void setButtonText(String text) {
        this.btnBrowse.setText(text);
    }

    public void setCurrentPath(File currentPath) {
        if (currentPath == null) {
            return;
        }
        this.currentPath = currentPath;
        this.txtInput.setText(currentPath.getAbsolutePath());
    }

    public void setEditable(boolean value) {
        this.txtInput.setEditable(value);
        this.editable = value;
    }

    public void setEnabled(boolean value) {
        this.txtInput.setEnabled(value);
        this.btnBrowse.setEnabled(value);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.setCurrentPath(new File(text));
    }

    public JTextField getTextField() {
        return this.txtInput;
    }
}

