/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.pieapi;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import jd.controlling.JDLogger;
import jd.gui.swing.components.pieapi.ChartAPIEntity;
import jd.nutils.encoding.Encoding;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChartAPI
extends JComponent {
    private static final long serialVersionUID = -3619951791325759665L;
    private Logger logger = JDLogger.getLogger();
    private HashMap<String, ChartAPIEntity> collData = new HashMap();
    private int width;
    private int height;
    protected Image image;
    private PictureLoader loader;
    private String caption;

    public ChartAPI(String caption, int width, int height) {
        this.caption = caption;
        this.width = width;
        this.height = height;
        this.setPreferredSize(new Dimension(width, height));
    }

    public void clear() {
        this.collData.clear();
    }

    public void addEntity(ChartAPIEntity input) {
        this.collData.put(input.getCaption(), input);
    }

    public void removeEntity(ChartAPIEntity input) {
        this.collData.remove(input.getCaption());
    }

    public void removeEntity(String caption) {
        this.collData.remove(caption);
    }

    public ChartAPIEntity getEntity(String caption) {
        return this.collData.get(caption);
    }

    public HashMap<String, ChartAPIEntity> getHashMap() {
        return this.collData;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String createCaptionString() {
        StringBuilder data = new StringBuilder();
        for (ChartAPIEntity tmp : this.collData.values()) {
            if (data.length() > 0) {
                data.append('|');
            }
            data.append(Encoding.urlEncode((String)tmp.getCaption()));
        }
        return data.toString();
    }

    public long getMaxValue() {
        long max = 0L;
        for (ChartAPIEntity tmp : this.collData.values()) {
            if (Long.valueOf(tmp.getData()) <= max) continue;
            max = Long.valueOf(tmp.getData());
        }
        return max;
    }

    public String getRelativeValue(String input) {
        double calc = Double.valueOf(input) / Double.valueOf(this.getMaxValue()) * 100.0;
        if (calc < 0.01 && calc > 0.0) {
            calc = 0.01;
        } else if (calc < 0.0) {
            calc = 0.0;
        }
        String ret = String.valueOf(calc);
        if (ret.length() > 16) {
            ret = ret.substring(0, 16);
        }
        return ret;
    }

    public void downloadImage(String path) {
        this.loader = new PictureLoader(path);
        this.loader.start();
    }

    public void setImage(Image image) {
        this.image = image;
        Dimension d = new Dimension(image.getWidth(null), image.getHeight(null));
        this.setPreferredSize(d);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setFont(new Font("Arial", 1, 12));
        if (this.image != null) {
            int x = (this.getWidth() - this.image.getWidth(null)) / 2;
            int y = (this.getHeight() - this.image.getHeight(null)) / 2;
            g.drawImage(this.image, x, y, this);
            g.drawString(this.caption, 0, 10);
            return;
        }
        g.drawImage(this.image, 0, 0, null);
        g.drawString(JDL.L((String)"plugins.config.premium.chartapi.caption.error2", (String)"Chart is loading or not available"), 0, 10);
    }

    public abstract String createDataString();

    public abstract String getUrl();

    private class PictureLoader
    extends Thread {
        private String path;

        public PictureLoader(String path) {
            this.path = path;
        }

        public void run() {
            BufferedImage image = null;
            try {
                URL url = new URL(this.path);
                image = ImageIO.read(url);
            }
            catch (IOException ex) {
                ChartAPI.this.logger.finest("Can not read : " + this.path);
            }
            if (image != null) {
                ChartAPI.this.setImage(image);
            }
        }
    }
}

