/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.StatusLabel;
import jd.nutils.JDImage;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.JRendererLabel;

public abstract class JDTableColumn
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = -1748365070868647250L;
    private String name;
    private JDTableModel table;
    private DefaultTableRenderer defaultrenderer;
    private boolean sortingToggle = false;
    private Thread sortThread = null;
    protected static Color background = null;
    protected static Color foreground = null;
    protected static Color backgroundselected = null;
    protected static Color foregroundselected = null;
    private Color currentbackground = null;
    private Color currentforeground = null;
    private StatusLabel sl = null;
    private int clickcount = 1;
    private int curWidth = -1;

    public JDTableColumn(String name, JDTableModel table) {
        this.name = name;
        this.table = table;
        this.defaultrenderer = new DefaultTableRenderer();
    }

    protected int getMaxWidth() {
        return -1;
    }

    public void setClickstoEdit(int i) {
        this.clickcount = Math.max(0, i);
    }

    public String getName() {
        return this.name;
    }

    public boolean defaultVisible() {
        return true;
    }

    public String getID() {
        return this.getClass().getSimpleName();
    }

    public JDTableModel getJDTableModel() {
        return this.table;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object obj = this.table.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return;
        }
        this.setValue(value, obj);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= this.clickcount;
        }
        return true;
    }

    public abstract boolean isSortable(Object var1);

    protected void doSort(final Object obj) {
        if (this.sortThread != null) {
            return;
        }
        this.sortThread = new Thread(){

            public void run() {
                this.setName(JDTableColumn.this.getID());
                try {
                    JDTableColumn.this.sort(obj, JDTableColumn.this.sortingToggle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JDTableColumn.this.sortingToggle = !JDTableColumn.this.sortingToggle;
                JDTableColumn.this.sortThread = null;
            }
        };
        this.sortThread.start();
    }

    public void sort(Object obj, boolean sortingToggle) {
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object obj = this.table.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return false;
        }
        return this.isEditable(obj);
    }

    public Component getDefaultTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        hasFocus = false;
        return this.defaultrenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        hasFocus = false;
        Component c = this.myTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        if (background == null) {
            background = this.getDefaultTableCellRendererComponent(table, value, false, hasFocus, row, column).getBackground();
        }
        if (foreground == null) {
            foreground = this.getDefaultTableCellRendererComponent(table, value, false, hasFocus, row, column).getForeground();
        }
        if (backgroundselected == null) {
            backgroundselected = this.getDefaultTableCellRendererComponent(table, value, true, hasFocus, row, column).getBackground();
        }
        if (foregroundselected == null) {
            foregroundselected = this.getDefaultTableCellRendererComponent(table, value, true, hasFocus, row, column).getForeground();
        }
        this.handleSelected(c, this.table, value, isSelected, row, column);
        this.handleEnabled(c, this.table, value, isSelected, row, column);
        this.postprocessCell(c, this.table, value, isSelected, row, column);
        return c;
    }

    public void handleEnabled(Component c, JDTableModel table, Object value, boolean isSelected, int row, int column) {
        if (this.isEnabled(value)) {
            if (c instanceof StatusLabel) {
                ((StatusLabel)c).setEnabled(true);
            } else {
                c.setEnabled(true);
            }
        } else if (c instanceof JRendererLabel) {
            ((JRendererLabel)c).setDisabledIcon(JDImage.getDisabledIcon((Icon)((JRendererLabel)c).getIcon()));
            c.setEnabled(false);
        } else if (c instanceof StatusLabel) {
            ((StatusLabel)c).setEnabled(false);
        } else {
            c.setEnabled(false);
        }
    }

    public void handleSelected(Component c, JDTableModel table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.currentbackground = backgroundselected;
            this.currentforeground = foregroundselected;
        } else {
            this.currentbackground = background;
            this.currentforeground = foreground;
            for (JDRowHighlighter high : table.getJDRowHighlighter()) {
                if (!high.doHighlight(value)) continue;
                this.currentbackground = high.getColor();
                break;
            }
        }
        if (c instanceof StatusLabel) {
            this.sl = (StatusLabel)c;
            this.sl.setBackground(this.currentbackground);
            this.sl.setForeground(this.currentforeground);
        } else {
            c.setBackground(this.currentbackground);
            c.setForeground(this.currentforeground);
        }
    }

    public void postprocessCell(Component c, JDTableModel table, Object value, boolean isSelected, int row, int column) {
    }

    public abstract boolean isEnabled(Object var1);

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.myTableCellEditorComponent(this.table, value, isSelected, row, column);
    }

    public abstract void setValue(Object var1, Object var2);

    public abstract boolean isEditable(Object var1);

    public abstract Component myTableCellEditorComponent(JDTableModel var1, Object var2, boolean var3, int var4, int var5);

    public abstract Component myTableCellRendererComponent(JDTableModel var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    public abstract Object getCellEditorValue();

    public int getCurWidth() {
        return this.curWidth;
    }

    public void setCurWidth(int curWidth) {
        this.curWidth = curWidth;
    }
}

