/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.table;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jd.config.SubConfiguration;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTable;
import jd.gui.swing.components.table.JDTableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7560879256832858265L;
    protected SubConfiguration config;
    protected ArrayList<Object> list = new ArrayList();
    protected ArrayList<JDTableColumn> columns = new ArrayList();
    private ArrayList<JDRowHighlighter> highlighter = new ArrayList();
    private JDTable table = null;

    public JDTableModel(String configname) {
        this.config = SubConfiguration.getConfig((String)configname);
        this.initColumns();
    }

    protected abstract void initColumns();

    public void setJDTable(JDTable table) {
        this.table = table;
    }

    public JDTable getJDTable() {
        return this.table;
    }

    public void addColumn(JDTableColumn e) {
        this.columns.add(e);
    }

    public void addColumn(JDTableColumn e, int index) {
        this.columns.add(index, e);
    }

    public SubConfiguration getConfig() {
        return this.config;
    }

    public abstract void refreshModel();

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    public ArrayList<JDRowHighlighter> getJDRowHighlighter() {
        return this.highlighter;
    }

    public void addJDRowHighlighter(JDRowHighlighter high) {
        this.highlighter.add(high);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowforObject(Object o) {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectforRow(int rowIndex) {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            if (rowIndex < this.list.size()) {
                return this.list.get(rowIndex);
            }
            return null;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.list.get(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isVisible(int column) {
        JDTableColumn col = this.getJDTableColumn(column);
        return this.config.getBooleanProperty("VISABLE_COL_" + col.getName(), col.defaultVisible());
    }

    public void setVisible(int column, boolean visible) {
        JDTableColumn col = this.getJDTableColumn(column);
        this.config.setProperty("VISABLE_COL_" + col.getName(), (Object)visible);
        this.config.save();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).setValueAt(value, rowIndex, columnIndex);
    }

    public JDTableColumn getJDTableColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }
}

