/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import jd.config.SubConfiguration;
import jd.gui.swing.SwingGui;
import jd.gui.swing.dialog.JCountdownDialog;
import jd.nutils.Screen;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class ClickPositionDialog
extends JCountdownDialog
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 5540481255364141955L;
    private JButton btnBAD;
    private Point result = null;
    private File imagefile;
    private String title;
    private String explain;

    public ClickPositionDialog(File imagefile, String title, String explain) {
        super(SwingGui.getInstance().getMainFrame());
        this.imagefile = imagefile;
        this.title = title;
        this.explain = explain;
        this.init();
    }

    public void init() {
        this.setModal(true);
        this.setTitle(this.title);
        this.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]"));
        ImageIcon imageIcon = null;
        imageIcon = this.imagefile != null && this.imagefile.exists() ? new ImageIcon(this.imagefile.getAbsolutePath()) : JDTheme.II((String)"gui.images.config.ocr");
        this.btnBAD = new JButton(JDL.L((String)"gui.btn_cancel", (String)"Cancel"));
        this.btnBAD.addActionListener(this);
        JLabel captcha = new JLabel(imageIcon);
        captcha.addMouseListener(this);
        captcha.setCursor(new Cursor(1));
        captcha.setToolTipText(this.explain);
        this.setDefaultCloseOperation(0);
        if (this.explain != null) {
            JTextPane tf = new JTextPane();
            tf.setBorder(null);
            tf.setBackground(null);
            tf.setContentType("text/html");
            tf.setOpaque(false);
            tf.setText(this.explain);
            tf.setEditable(false);
            this.add((Component)tf, "");
        }
        this.add((Component)captcha, "w pref!, h pref!, alignx center");
        this.add((Component)this.countDownLabel, "split 2,growx");
        this.add((Component)this.btnBAD, "alignx right");
        this.setMinimumSize(new Dimension(300, -1));
        this.pack();
        this.setResizable(false);
        if (SwingGui.getInstance() == null || SwingGui.getInstance().getMainFrame().getExtendedState() == 1 || !SwingGui.getInstance().getMainFrame().isVisible()) {
            this.setLocation(Screen.getDockBottomRight((Component)this));
        } else {
            this.setLocation(Screen.getCenterOfComponent((Component)SwingGui.getInstance().getMainFrame(), (Component)this));
        }
        this.toFront();
        this.setAlwaysOnTop(true);
        this.requestFocus();
        this.countdown(Math.max(2, SubConfiguration.getConfig((String)"JAC").getIntegerProperty("JAC_SHOW_TIMEOUT", 20)));
        this.setVisible(true);
        this.toFront();
    }

    public void actionPerformed(ActionEvent e) {
        this.mouseEntered(null);
        this.dispose();
    }

    public Point getPoint() {
        return this.result;
    }

    protected void onCountdown() {
        this.dispose();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.interrupt();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.result = e.getPoint();
        this.dispose();
    }
}

