/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import jd.nutils.Screen;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class ProgressDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1749561448228487759L;
    private JButton btnNotOK;
    private JButton btnOK;
    private JLabel lblMessage;
    private JProgressBar progress;
    private Thread thread;

    public ProgressDialog(JFrame owner, String message, Thread ob, boolean ok, boolean cancel) {
        super(owner);
        this.setModal(true);
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[center]"));
        this.setAlwaysOnTop(true);
        this.setTitle(JDL.L((String)"gui.dialogs.progress.title", (String)"Fortschritt...bitte warten"));
        this.setDefaultCloseOperation(0);
        this.thread = ob;
        this.lblMessage = new JLabel(message);
        this.progress = new JProgressBar();
        this.add((Component)this.lblMessage, "growx");
        this.add((Component)this.progress, "growx");
        if (ok) {
            this.btnOK = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
            this.btnOK.addActionListener(this);
            this.getRootPane().setDefaultButton(this.btnOK);
            this.add((Component)this.btnOK, cancel ? "split 2" : "");
        }
        if (cancel) {
            this.btnNotOK = new JButton(JDL.L((String)"gui.btn_cancel", (String)"Abbrechen"));
            this.btnNotOK.addActionListener(this);
            this.add(this.btnNotOK);
        }
        this.setLocation(Screen.getCenterOfComponent((Component)owner, (Component)this));
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOK) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.dispose();
        } else if (e.getSource() == this.btnNotOK) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.dispose();
        }
    }

    public void setMaximum(int value) {
        this.progress.setMaximum(value);
    }

    public void setString(String txt) {
        this.progress.setString(txt);
    }

    public void setStringPainted(boolean b) {
        this.progress.setStringPainted(b);
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setValue(int value) {
        this.progress.setValue(value);
    }
}

