/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.event.JDEvent;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.maintab.ClosableTabHeader;
import jd.gui.swing.jdgui.views.ClosableView;
import jd.utils.JDUtilities;

public class MainTabbedPane
extends JTabbedPane
implements MouseListener {
    private static final long serialVersionUID = -1531827591735215594L;
    private static MainTabbedPane INSTANCE;
    protected View latestSelection;

    public static synchronized MainTabbedPane getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MainTabbedPane();
        }
        return INSTANCE;
    }

    public void remove(Component component) {
        throw new RuntimeException(" This method is not allowed");
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (this.getRootPane().getInputMap(2).get(ks) != null) {
            return false;
        }
        if (this.getRootPane().getInputMap(1).get(ks) != null) {
            return false;
        }
        return ret;
    }

    public void remove(View view) {
        super.remove(view);
        if (view != null) {
            view.getBroadcaster().fireEvent((JDEvent)new SwitchPanelEvent(view, 3));
        }
        if (this.getTabCount() > 0) {
            this.setSelectedComponent(this.getComponentAt(0));
        }
    }

    public void addTab(View view) {
        SwingGui.checkEDT();
        if (view instanceof ClosableView) {
            this.addClosableTab((ClosableView)view);
        } else {
            super.addTab(view.getTitle(), view.getIcon(), view, view.getTooltip());
            view.getBroadcaster().fireEvent((JDEvent)new SwitchPanelEvent(view, 2));
            this.setFocusable(false);
        }
    }

    private void addClosableTab(ClosableView view) {
        if (JDUtilities.getJavaVersion() >= 1.6) {
            super.addTab(view.getTitle(), view.getIcon(), view, view.getTooltip());
            view.getBroadcaster().fireEvent((JDEvent)new SwitchPanelEvent(view, 2));
            this.setTabComponentAt(this.getTabCount() - 1, new ClosableTabHeader(view));
        } else {
            super.addTab(view.getTitle(), new CloseTabIcon(view.getIcon()), view, view.getTooltip());
            view.getBroadcaster().fireEvent((JDEvent)new SwitchPanelEvent(view, 2));
        }
        this.setFocusable(false);
    }

    private MainTabbedPane() {
        this.setMinimumSize(new Dimension(300, 100));
        this.setTabLayoutPolicy(0);
        this.setOpaque(false);
        if (JDUtilities.getJavaVersion() < 1.6) {
            this.addMouseListener(this);
        }
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SwingGui.getInstance() != null) {
                    SwingGui.getInstance().setWaiting(true);
                }
                try {
                    View comp = (View)MainTabbedPane.this.getSelectedComponent();
                    if (comp == MainTabbedPane.this.latestSelection) {
                        return;
                    }
                    if (MainTabbedPane.this.latestSelection != null) {
                        MainTabbedPane.this.latestSelection.setHidden();
                    }
                    MainTabbedPane.this.latestSelection = comp;
                    comp.setShown();
                    MainTabbedPane.this.revalidate();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (SwingGui.getInstance() != null) {
            SwingGui.getInstance().setWaiting(false);
        }
    }

    public void onClose() {
        this.getSelectedView().setHidden();
    }

    public View getSelectedView() {
        SwingGui.checkEDT();
        return (View)super.getSelectedComponent();
    }

    public void setSelectedComponent(Component e) {
        SwingGui.checkEDT();
        super.setSelectedComponent(this.getComponentEquals((View)e));
    }

    public View getComponentEquals(View view) {
        SwingGui.checkEDT();
        int i = 0;
        while (i < this.getTabCount()) {
            Component c = this.getComponentAt(i);
            if (c.equals(view)) {
                return (View)c;
            }
            ++i;
        }
        return null;
    }

    public boolean contains(View view) {
        int i = 0;
        while (i < this.getTabCount()) {
            Component c = this.getComponentAt(i);
            if (c.equals(view)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        try {
            int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
            if (tabNumber < 0) {
                return;
            }
            Rectangle rect = ((CloseTabIcon)this.getIconAt(tabNumber)).getBounds();
            if (rect.contains(e.getX(), e.getY())) {
                ((ClosableView)this.getComponentAt(tabNumber)).close();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;

        public CloseTabIcon(Icon fileIcon) {
            this.fileIcon = fileIcon;
            this.width = 16;
            this.height = 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int h;
            int w;
            Color col;
            this.x_pos = x;
            this.y_pos = y;
            Icon ic = UIManager.getIcon("InternalFrame.closeIcon");
            int y_p = y + 2;
            if (ic == null) {
                col = g.getColor();
                g.drawLine(x + 3, y_p + 3, x + 10, y_p + 10);
                g.drawLine(x + 3, y_p + 4, x + 9, y_p + 10);
                g.drawLine(x + 4, y_p + 3, x + 10, y_p + 9);
                g.drawLine(x + 10, y_p + 3, x + 3, y_p + 10);
                g.drawLine(x + 10, y_p + 4, x + 4, y_p + 10);
                g.drawLine(x + 9, y_p + 3, x + 3, y_p + 9);
                g.setColor(col);
                w = 13;
                h = 13;
            } else {
                ic.paintIcon(c, g, x - 1, y_p - 1);
                w = ic.getIconWidth() - 3;
                h = ic.getIconHeight() - 3;
            }
            col = g.getColor();
            g.drawLine(x + 1, y_p, x + w - 1, y_p);
            g.drawLine(x + 1, y_p + h, x + w - 1, y_p + h);
            g.drawLine(x, y_p + 1, x, y_p + h - 1);
            g.drawLine(x + w, y_p + 1, x + w, y_p + h - 1);
            g.setColor(col);
            if (this.fileIcon != null) {
                this.fileIcon.paintIcon(c, g, x + this.width + 2, y_p);
            }
        }

        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

