/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import jd.controlling.ProgressController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.GuiRunnable;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class TabProgress
extends JPanel
implements ActionListener,
ControlListener,
MouseListener {
    private static final long serialVersionUID = -8537543161116653345L;
    private static final int MAX_BARS = 6;
    private ArrayList<ProgressController> controllers = new ArrayList();
    private ProgressEntry[] lines;
    private JLabel title;
    private boolean updateInProgress = false;
    private long latestUpdateTIme = 0L;

    public TabProgress() {
        JDUtilities.getController().addControlListener((ControlListener)this);
        this.addMouseListener(this);
        this.setVisible(false);
        this.lines = new ProgressEntry[6];
        this.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow]"));
        this.initGUI();
        this.setTitle(JDL.LF((String)"gui.progresspane.title", (String)"%s module(s) running", (Object[])new Object[]{0}));
    }

    private void setTitle(String lf) {
        this.title.setText(lf);
    }

    private void initGUI() {
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.getBackground().darker()));
        this.title = new JLabel("");
        this.add((Component)this.title, "split 3,gapleft 10,gapbottom 5,gaptop 5");
        this.title.setIcon(JDTheme.II((String)"gui.images.sort", (int)24, (int)24));
        this.title.setIconTextGap(15);
        this.add((Component)new JSeparator(), "growx,pushx,gapright 15");
        this.add(new JLabel(JDTheme.II((String)"gui.images.config.tip", (int)16, (int)16)));
        int i = 0;
        while (i < 6) {
            this.lines[i] = new ProgressEntry();
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addController(ProgressController source) {
        ArrayList<ProgressController> arrayList = this.controllers;
        synchronized (arrayList) {
            if (!this.controllers.contains(source)) {
                this.controllers.add(0, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeController(ProgressController source) {
        ArrayList<ProgressController> arrayList = this.controllers;
        synchronized (arrayList) {
            this.controllers.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlEvent(ControlEvent event) {
        ArrayList<ProgressController> arrayList = this.controllers;
        synchronized (arrayList) {
            if (event.getID() == 24 && event.getSource() instanceof ProgressController) {
                ProgressController source = (ProgressController)event.getSource();
                this.addController(source);
                if (source.isFinished()) {
                    this.removeController(source);
                    new GuiRunnable<Object>(){

                        @Override
                        public Object runSave() {
                            TabProgress.this.update(true);
                            return null;
                        }
                    }.start();
                } else {
                    new GuiRunnable<Object>(){

                        @Override
                        public Object runSave() {
                            TabProgress.this.update(false);
                            return null;
                        }
                    }.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(boolean force) {
        if (!force) {
            if (this.updateInProgress) {
                return;
            }
            if (System.currentTimeMillis() - this.latestUpdateTIme < 500L) {
                return;
            }
            this.updateInProgress = true;
        }
        this.sortControllers();
        ArrayList<ProgressController> arrayList = this.controllers;
        synchronized (arrayList) {
            int i = 0;
            while (i < Math.min(this.controllers.size(), 6)) {
                if (!this.lines[i].isAttached()) {
                    this.add((Component)this.lines[i], "height 20!");
                    this.lines[i].setAttached(true);
                }
                this.lines[i].update(this.controllers.get(i));
                ++i;
            }
            i = Math.max(0, Math.min(this.controllers.size(), 6));
            while (i < 6) {
                if (this.lines[i].isAttached()) {
                    this.remove(this.lines[i]);
                    this.lines[i].setAttached(false);
                }
                ++i;
            }
            if (this.controllers.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            this.setTitle(JDL.LF((String)"gui.progresspane.title", (String)"%s module(s) running", (Object[])new Object[]{"" + this.controllers.size()}));
            this.revalidate();
            this.repaint();
            if (!force) {
                this.updateInProgress = false;
            }
            this.latestUpdateTIme = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortControllers() {
        ArrayList<ProgressController> arrayList = this.controllers;
        synchronized (arrayList) {
            Collections.sort(this.controllers, new Comparator<ProgressController>(){

                @Override
                public int compare(ProgressController o1, ProgressController o2) {
                    if (o1.getPercent() == o2.getPercent()) {
                        return 0;
                    }
                    return o1.getPercent() < o2.getPercent() ? 1 : -1;
                }
            });
            Collections.sort(this.controllers, new Comparator<ProgressController>(){

                @Override
                public int compare(ProgressController o1, ProgressController o2) {
                    if (o1.isFinalizing()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private class ProgressEntry
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 2676301394570621548L;
        private JLabel label;
        private JProgressBar bar;
        private JButton cancel;
        private boolean attached = false;
        private ProgressController controller = null;
        private Color bgc;
        private Color fgc;

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public ProgressEntry() {
            this.setLayout((LayoutManager)new MigLayout("ins 0", "20![18!]11![grow,fill]5![20!]", "16!"));
            this.label = new JLabel();
            this.add(this.label);
            this.bar = new JProgressBar();
            this.add(this.bar);
            this.cancel = new JButton(JDTheme.II((String)"gui.images.cancel", (int)16, (int)16));
            this.add((Component)this.cancel, "width 16!,height 16!");
            this.bgc = this.bar.getBackground();
            this.fgc = this.bar.getForeground();
            this.cancel.setBorderPainted(false);
            this.cancel.setContentAreaFilled(false);
            this.cancel.setCursor(Cursor.getPredefinedCursor(12));
            this.cancel.setOpaque(false);
            this.cancel.setFocusable(false);
            this.cancel.addActionListener(this);
        }

        public boolean isAttached() {
            return this.attached;
        }

        public void update(ProgressController controller) {
            this.controller = controller;
            if (!controller.isInterruptable()) {
                this.cancel.setIcon(JDTheme.II((String)"gui.images.cancel", (int)16, (int)16));
                this.cancel.setEnabled(false);
                this.cancel.setToolTipText(JDL.L((String)"gui.progressbars.cancel.tooltip.disabled", (String)"Not possible to interrupt this module"));
            } else if (controller.isAbort()) {
                this.cancel.setIcon(JDTheme.II((String)"gui.images.bad", (int)16, (int)16));
                this.cancel.setEnabled(false);
                this.cancel.setToolTipText(JDL.L((String)"gui.progressbars.cancel.tooltip.interrupted", (String)"Termination in progress"));
            } else {
                this.cancel.setIcon(JDTheme.II((String)"gui.images.cancel", (int)16, (int)16));
                this.cancel.setEnabled(true);
                this.cancel.setToolTipText(JDL.L((String)"gui.progressbars.cancel.tooltip.enabled", (String)"Interrupt this module"));
            }
            this.label.setIcon(controller.getIcon() == null ? JDTheme.II((String)"gui.images.running", (int)16, (int)16) : controller.getIcon());
            this.label.setToolTipText(JDL.L((String)"gui.tooltip.progressicon", (String)"This module is active"));
            if (controller.isIndeterminate()) {
                this.bar.setIndeterminate(true);
            } else {
                this.bar.setMaximum(10000);
                this.bar.setValue(controller.getPercent());
            }
            this.bar.setStringPainted(true);
            this.bar.setString(controller.getStatusText());
            if (controller.getColor() != null) {
                this.bar.setBackground(controller.getColor());
                this.bar.setForeground(controller.getColor().brighter());
            } else {
                this.bar.setBackground(this.bgc);
                this.bar.setForeground(this.fgc);
            }
        }

        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == this.cancel && this.controller != null && !this.controller.isAbort()) {
                this.controller.fireCancelAction();
            }
        }
    }
}

