/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.ClipboardHandler;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.LinkGrabberController;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.Reconnecter;
import jd.event.ControlEvent;
import jd.event.ControlIDListener;
import jd.event.ControlListener;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.actions.ThreadedAction;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.views.downloadview.DownloadLinksPanel;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberPanel;
import jd.nutils.JDFlags;
import jd.plugins.LinkGrabberFilePackage;
import jd.utils.JDUtilities;
import jd.utils.WebUpdate;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionController {
    public static final String JDL_PREFIX = "jd.gui.swing.jdgui.actions.ActionController.";
    private static ArrayList<ToolBarAction> TOOLBAR_ACTION_LIST = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ToolBarAction action) {
        ArrayList<ToolBarAction> arrayList = TOOLBAR_ACTION_LIST;
        synchronized (arrayList) {
            if (TOOLBAR_ACTION_LIST.contains(action)) {
                return;
            }
            for (ToolBarAction act : TOOLBAR_ACTION_LIST) {
                if (!act.getID().equalsIgnoreCase(action.getID())) continue;
                return;
            }
            TOOLBAR_ACTION_LIST.add(action);
        }
    }

    public static void initActions() {
        new ToolBarAction("toolbar.separator", "-"){
            private static final long serialVersionUID = -4628452328096482738L;

            public void onAction(ActionEvent e) {
            }

            public void initDefaults() {
                this.setType(ToolBarAction.Types.SEPARATOR);
            }

            public void init() {
            }
        };
        new ThreadedAction("toolbar.control.start", "gui.images.next"){
            private static final long serialVersionUID = 1683169623090750199L;

            public void initDefaults() {
                this.setPriority(1000);
                this.setEnabled(true);
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.actions.ActionController.toolbar.control.start.tooltip", (String)"Start downloads in list"));
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                JDUtilities.getController().addControlListener((ControlListener)new ControlIDListener(new int[]{13, 1, 6}){

                    public void controlIDEvent(final ControlEvent event) {
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                switch (event.getID()) {
                                    case 13: {
                                        this.setEnabled(false);
                                        break;
                                    }
                                    case 1: 
                                    case 6: {
                                        this.setEnabled(true);
                                    }
                                }
                                return null;
                            }
                        }.start();
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void threadedActionPerformed(ActionEvent e) {
                if (!LinkGrabberPanel.getLinkGrabber().isNotVisible()) {
                    ArrayList fps = new ArrayList(LinkGrabberController.getInstance().getPackages());
                    Object object = LinkGrabberController.ControllerLock;
                    synchronized (object) {
                        LinkGrabberPanel linkGrabberPanel = LinkGrabberPanel.getLinkGrabber();
                        synchronized (linkGrabberPanel) {
                            for (LinkGrabberFilePackage fp : fps) {
                                LinkGrabberPanel.getLinkGrabber().confirmPackage(fp, null, -1);
                            }
                        }
                    }
                    fps = null;
                    UserIF.getInstance().requestPanel(UserIF.Panels.DOWNLOADLIST, null);
                }
                DownloadWatchDog.getInstance().startDownloads();
            }
        };
        new ToolBarAction("toolbar.control.pause", "gui.images.break"){
            private static final long serialVersionUID = 7153300370492212502L;

            public void onAction(ActionEvent e) {
                boolean b = ActionController.getToolBarAction("toolbar.control.pause").isSelected();
                DownloadWatchDog.getInstance().pauseDownloads(b);
            }

            public void initDefaults() {
                this.setPriority(999);
                this.setEnabled(false);
                this.setType(ToolBarAction.Types.TOGGLE);
                this.setToolTipText(JDL.LF((String)"gui.menu.action.break2.desc", (String)"Pause downloads. Limits global speed to %s kb/s", (Object[])new Object[]{String.valueOf(SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10))}));
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                JDUtilities.getController().addControlListener((ControlListener)new ControlIDListener(new int[]{13, 1, 6}){

                    public void controlIDEvent(final ControlEvent event) {
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                switch (event.getID()) {
                                    case 13: {
                                        this.setEnabled(true);
                                        this.setSelected(false);
                                        break;
                                    }
                                    case 1: 
                                    case 6: {
                                        this.setEnabled(false);
                                        this.setSelected(false);
                                    }
                                }
                                return null;
                            }
                        }.start();
                    }
                });
                JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"PAUSE_SPEED"}){

                    public void onPropertyChanged(Property source, String key) {
                        this.setToolTipText(JDL.LF((String)"gui.menu.action.break2.desc", (String)"Pause downloads. Limits global speed to %s kb/s", (Object[])new Object[]{String.valueOf(SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10))}));
                    }
                });
            }
        };
        new ThreadedAction("toolbar.control.stop", "gui.images.stop"){
            private static final long serialVersionUID = 1409143759105090751L;

            public void initDefaults() {
                this.setPriority(998);
                this.setEnabled(false);
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.actions.ActionController.toolbar.control.stop.tooltip", (String)"Stop all running downloads"));
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                JDUtilities.getController().addControlListener((ControlListener)new ControlIDListener(new int[]{13, 1, 6}){

                    public void controlIDEvent(final ControlEvent event) {
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                switch (event.getID()) {
                                    case 13: {
                                        this.setEnabled(true);
                                        break;
                                    }
                                    case 1: 
                                    case 6: {
                                        this.setEnabled(false);
                                    }
                                }
                                return null;
                            }
                        }.start();
                    }
                });
            }

            public void threadedActionPerformed(ActionEvent e) {
                final ProgressController pc = new ProgressController(JDL.L((String)"gui.downloadstop", (String)"Stopping current downloads..."));
                Thread test = new Thread(){

                    public void run() {
                        do {
                            pc.increase(1L);
                            try {
                                2.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        } while (DownloadWatchDog.getInstance().getDownloadStatus() != DownloadWatchDog.STATE.NOT_RUNNING);
                    }
                };
                test.start();
                DownloadWatchDog.getInstance().stopDownloads();
                test.interrupt();
                pc.doFinalize();
            }
        };
        new ThreadedAction("toolbar.interaction.reconnect", "gui.images.reconnect"){
            private static final long serialVersionUID = -1295253607970814759L;

            public void initDefaults() {
                this.setPriority(800);
                this.setEnabled(true);
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.actions.ActionController.toolbar.interaction.reconnect.tooltip", (String)"Get a new IP be resetting your internet connection"));
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"PARAM_RECONNECT_OKAY"}){

                    public void onPropertyChanged(Property source, String key) {
                        if (!source.getBooleanProperty(key, true).booleanValue()) {
                            this.setIcon("gui.images.reconnect_warning");
                            this.setToolTipText(JDL.L((String)"gui.menu.action.reconnect.notconfigured.tooltip", (String)"Your Reconnect is not configured correct"));
                            ActionController.getToolBarAction("toolbar.quickconfig.reconnecttoggle").setToolTipText(JDL.L((String)"gui.menu.action.reconnect.notconfigured.tooltip", (String)"Your Reconnect is not configured correct"));
                        } else {
                            this.setToolTipText(JDL.L((String)"gui.menu.action.reconnectman.desc", (String)"Manual reconnect. Get a new IP by resetting your internet connection"));
                            this.setIcon("gui.images.reconnect");
                            ActionController.getToolBarAction("toolbar.quickconfig.reconnecttoggle").setToolTipText(JDL.L((String)"gui.menu.action.reconnectauto.desc", (String)"Auto reconnect. Get a new IP by resetting your internet connection"));
                        }
                    }
                });
            }

            public void threadedActionPerformed(ActionEvent e) {
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(0, JDL.L((String)"gui.reconnect.confirm", (String)"Wollen Sie sicher eine neue Verbindung aufbauen?")), (int[])new int[]{2, 8})) {
                            new Thread(new Runnable(){

                                public void run() {
                                    Reconnecter.doManualReconnect();
                                }
                            }).start();
                        }
                        return null;
                    }
                }.start();
            }
        };
        new ThreadedAction("toolbar.interaction.update", "gui.images.update"){
            private static final long serialVersionUID = 4359802245569811800L;

            public void initDefaults() {
                this.setPriority(800);
                this.setEnabled(true);
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.actions.ActionController.toolbar.interaction.update.tooltip", (String)"Check for new updates"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                WebUpdate wu = new WebUpdate();
                wu.doUpdateCheck(true);
            }
        };
        new ToolBarAction("toolbar.quickconfig.clipboardoberserver", "gui.images.clipboard_enabled"){
            private static final long serialVersionUID = -6442494647304101403L;

            public void onAction(ActionEvent e) {
                ClipboardHandler.getClipboard().setEnabled(this.isSelected());
            }

            public void initDefaults() {
                this.setPriority(900);
                this.setEnabled(true);
                this.setType(ToolBarAction.Types.TOGGLE);
                this.setToolTipText(JDL.L((String)"gui.menu.action.clipboard.desc", (String)"-"));
                boolean b = JDUtilities.getConfiguration().getBooleanProperty("CLIPBOARD_ALWAYS_ACTIVE2", true);
                this.setSelected(b);
                this.setIcon(b ? "gui.images.clipboard_enabled" : "gui.images.clipboard_disabled");
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName() == "SwingSelectedKey") {
                            this.setIcon((Boolean)evt.getNewValue() != false ? "gui.images.clipboard_enabled" : "gui.images.clipboard_disabled");
                        }
                    }
                });
                JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"CLIPBOARD_ALWAYS_ACTIVE2"}){

                    public void onPropertyChanged(Property source, String key) {
                        if (source.getBooleanProperty(key, true).booleanValue()) {
                            this.setSelected(true);
                        } else {
                            this.setSelected(false);
                        }
                    }
                });
            }
        };
        new ToolBarAction("toolbar.quickconfig.reconnecttoggle", "gui.images.reconnect_disabled"){
            private static final long serialVersionUID = -2942320816429047941L;

            public void onAction(ActionEvent e) {
                Reconnecter.toggleReconnect();
            }

            public void initDefaults() {
                this.setPriority(899);
                this.setEnabled(true);
                this.setType(ToolBarAction.Types.TOGGLE);
                this.setToolTipText(JDL.L((String)"gui.menu.action.reconnect.desc", (String)"-"));
                this.setSelected(JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true));
                this.setIcon(this.isSelected() ? "gui.images.reconnect_enabled" : "gui.images.reconnect_disabled");
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName() == "SwingSelectedKey") {
                            this.setIcon((Boolean)evt.getNewValue() != false ? "gui.images.reconnect_enabled" : "gui.images.reconnect_disabled");
                        }
                    }
                });
                JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"ALLOW_RECONNECT"}){

                    public void onPropertyChanged(Property source, String key) {
                        if (source.getBooleanProperty(key, true).booleanValue()) {
                            this.setSelected(true);
                        } else {
                            this.setSelected(false);
                        }
                    }
                });
            }
        };
        new ToolBarAction("action.opendlfolder", "gui.images.package_opened"){
            private static final long serialVersionUID = -60944746807335951L;

            public void onAction(ActionEvent e) {
                String dlDir = JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY", null);
                if (dlDir == null) {
                    return;
                }
                JDUtilities.openExplorer((File)new File(dlDir));
            }

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.opendlfolder.tooltip", (String)"Open default Downloadfolder"));
            }

            public void init() {
            }
        };
        new ThreadedAction("toolbar.control.stopmark", "gui.images.stopmark.disabled"){
            private static final long serialVersionUID = 4359802245569811800L;

            public void initDefaults() {
                this.setPriority(800);
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.actions.ActionController.toolbar.control.stopmark.tooltip", (String)"Stop after current Downloads"));
                this.setEnabled(false);
                this.setType(ToolBarAction.Types.TOGGLE);
                this.setSelected(false);
                this.setIcon("gui.images.stopmark.disabled");
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName() == "SwingSelectedKey") {
                            this.setIcon((Boolean)evt.getNewValue() != false ? "gui.images.stopmark.enabled" : "gui.images.stopmark.disabled");
                        }
                    }
                });
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                if (DownloadWatchDog.getInstance().isStopMarkSet()) {
                    DownloadWatchDog.getInstance().setStopMark(null);
                } else if (DownloadWatchDog.getInstance().getActiveDownloads() > 0) {
                    Object obj = DownloadWatchDog.getInstance().getRunningDownloads().get(0);
                    DownloadWatchDog.getInstance().setStopMark(obj);
                } else {
                    this.setSelected(false);
                }
                if (DownloadWatchDog.getInstance().getDownloadStatus() != DownloadWatchDog.STATE.RUNNING && !DownloadWatchDog.getInstance().isStopMarkSet()) {
                    this.setEnabled(false);
                }
            }
        };
        new ThreadedAction("action.downloadview.movetobottom", "gui.images.go_bottom"){
            private static final long serialVersionUID = 6181260839200699153L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.downloadview.movetobottom.tooltip", (String)"Move to bottom"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                if (!LinkGrabberPanel.getLinkGrabber().isNotVisible()) {
                    LinkGrabberPanel.getLinkGrabber().move((byte)6);
                    LinkGrabberController.getInstance().throwRefresh();
                } else if (!DownloadLinksPanel.getDownloadLinksPanel().isNotVisible()) {
                    DownloadLinksPanel.getDownloadLinksPanel().move((byte)6);
                }
            }
        };
        new ThreadedAction("action.downloadview.movetotop", "gui.images.go_top"){
            private static final long serialVersionUID = 6181260839200699153L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.downloadview.movetotop.tooltip", (String)"Move to top"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                if (!LinkGrabberPanel.getLinkGrabber().isNotVisible()) {
                    LinkGrabberPanel.getLinkGrabber().move((byte)5);
                    LinkGrabberController.getInstance().throwRefresh();
                } else if (!DownloadLinksPanel.getDownloadLinksPanel().isNotVisible()) {
                    DownloadLinksPanel.getDownloadLinksPanel().move((byte)5);
                }
            }
        };
        new ThreadedAction("action.downloadview.moveup", "gui.images.up"){
            private static final long serialVersionUID = 6181260839200699153L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.downloadview.moveup.tooltip", (String)"Move up"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                if (!LinkGrabberPanel.getLinkGrabber().isNotVisible()) {
                    LinkGrabberPanel.getLinkGrabber().move((byte)7);
                    LinkGrabberController.getInstance().throwRefresh();
                } else if (!DownloadLinksPanel.getDownloadLinksPanel().isNotVisible()) {
                    DownloadLinksPanel.getDownloadLinksPanel().move((byte)7);
                }
            }
        };
        new ThreadedAction("action.downloadview.movedown", "gui.images.down"){
            private static final long serialVersionUID = 6181260839200699153L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.downloadview.movedown.tooltip", (String)"Move down"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                if (!LinkGrabberPanel.getLinkGrabber().isNotVisible()) {
                    LinkGrabberPanel.getLinkGrabber().move((byte)8);
                    LinkGrabberController.getInstance().throwRefresh();
                } else if (!DownloadLinksPanel.getDownloadLinksPanel().isNotVisible()) {
                    DownloadLinksPanel.getDownloadLinksPanel().move((byte)8);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolBarAction getToolBarAction(String keyid) {
        ArrayList<ToolBarAction> arrayList = TOOLBAR_ACTION_LIST;
        synchronized (arrayList) {
            for (ToolBarAction a : TOOLBAR_ACTION_LIST) {
                if (!a.getID().equals(keyid)) continue;
                return a;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ToolBarAction> getActions() {
        ArrayList<ToolBarAction> ret = new ArrayList<ToolBarAction>();
        ArrayList<ToolBarAction> arrayList = TOOLBAR_ACTION_LIST;
        synchronized (arrayList) {
            ret.addAll(TOOLBAR_ACTION_LIST);
        }
        return ret;
    }
}

