/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.premiumbar;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jd.HostPluginWrapper;
import jd.Main;
import jd.config.ConfigGroup;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.JDController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.components.premiumbar.TinyProgressBar;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.menu.HosterMenu;
import jd.gui.swing.menu.Menu;
import jd.nutils.Formatter;
import jd.nutils.JDFlags;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class PremiumStatus
extends JPanel
implements AccountControllerListener,
ActionListener,
MouseListener,
ControlListener {
    private static final long serialVersionUID = 7290466989514173719L;
    private static final int BARCOUNT = 15;
    private static final long ACCOUNT_UPDATE_DELAY = 1800000L;
    private TinyProgressBar[] bars = new TinyProgressBar[15];
    private JLabel lbl = new JLabel(JDL.L((String)"gui.statusbar.premiumloadlabel", (String)"< Add Accounts"));
    private boolean redrawinprogress = false;
    private JToggleButton premium;
    private boolean updating = false;
    private Timer updateIntervalTimer;
    private boolean updateinprogress = false;
    private JPopupMenu popup;
    private boolean guiInitComplete = false;

    public PremiumStatus() {
        this.setName(JDL.L((String)"quickhelp.premiumstatusbar", (String)"Premium statusbar"));
        this.setLayout((LayoutManager)new MigLayout("ins 0", "", "[::20, center]"));
        this.premium = new JToggleButton();
        this.premium.setToolTipText(JDL.L((String)"gui.menu.action.premium.desc", (String)"Enable Premiumusage globally"));
        this.premium.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                if (!PremiumStatus.this.premium.isSelected() && JDFlags.hasAllFlags((int)(answer = UserIO.getInstance().requestConfirmDialog(36, JDL.L((String)"dialogs.premiumstatus.global.title", (String)"Disable Premium?"), JDL.L((String)"dialogs.premiumstatus.global.message", (String)"Do you really want to disable all premium accounts?"), JDTheme.II((String)"gui.images.warning", (int)32, (int)32), JDL.L((String)"gui.btn_yes", (String)"Yes"), JDL.L((String)"gui.btn_no", (String)"No"))), (int[])new int[]{4}) && !JDFlags.hasAllFlags((int)answer, (int[])new int[]{8})) {
                    PremiumStatus.this.premium.setSelected(true);
                    return;
                }
                JDUtilities.getConfiguration().setProperty("USE_PREMIUM_V3", (Object)PremiumStatus.this.premium.isSelected());
                JDUtilities.getConfiguration().save();
            }
        });
        this.premium.setFocusPainted(false);
        this.premium.setContentAreaFilled(false);
        this.premium.setBorderPainted(false);
        this.updatePremiumButton();
        this.add((Component)this.premium, "hmax 20");
        this.premium.addMouseListener(this);
        this.add((Component)new JSeparator(1), "growy");
        this.add((Component)this.lbl, "hidemode 3");
        int i = 0;
        while (i < 15) {
            this.bars[i] = new TinyProgressBar();
            this.bars[i].setOpaque(false);
            this.bars[i].addMouseListener(this);
            this.bars[i].setEnabled(this.premium.isSelected());
            this.bars[i].setVisible(false);
            this.add((Component)this.bars[i], "hidemode 3, hmax 20");
            ++i;
        }
        this.setOpaque(false);
        this.updateIntervalTimer = new Timer(5000, this);
        this.updateIntervalTimer.setInitialDelay(5000);
        this.updateIntervalTimer.setRepeats(false);
        this.updateIntervalTimer.stop();
        JDUtilities.getController().addControlListener((ControlListener)this);
        Thread updateTimer = new Thread("PremiumStatusUpdateTimer"){

            public void run() {
                PremiumStatus.this.requestUpdate();
                while (true) {
                    try {
                        Thread.sleep(1800000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                    PremiumStatus.this.requestUpdate();
                }
            }
        };
        updateTimer.start();
        AccountController.getInstance().addListener((AccountControllerListener)this);
        JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"USE_PREMIUM_V3"}){

            public void onPropertyChanged(Property source, String valid) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PremiumStatus.this.updateGUI();
                    }
                });
            }
        });
    }

    private void updatePremiumButton() {
        if (JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true).booleanValue()) {
            this.premium.setSelected(true);
            this.premium.setIcon(JDTheme.II((String)"gui.images.premium_enabled", (int)16, (int)16));
        } else {
            this.premium.setSelected(false);
            this.premium.setIcon(JDTheme.II((String)"gui.images.premium_disabled", (int)16, (int)16));
        }
    }

    private void updateGUI() {
        this.updatePremiumButton();
        int i = 0;
        while (i < 15) {
            if (this.bars[i] != null) {
                this.bars[i].setEnabled(this.premium.isSelected());
            }
            ++i;
        }
    }

    private synchronized void updatePremium() {
        this.updating = true;
        String id = JDController.requestDelayExit((String)"updatePremium");
        for (HostPluginWrapper wrapper : HostPluginWrapper.getHostWrapper()) {
            String host = wrapper.getHost();
            if (!wrapper.isLoaded() || !wrapper.isEnabled()) continue;
            ArrayList accs = AccountController.getInstance().getAllAccounts(host);
            for (Account a : accs) {
                AccountController.getInstance().updateAccountInfo(host, a, false);
            }
        }
        JDController.releaseDelayExit((String)id);
        this.updating = false;
    }

    private synchronized void redraw() {
        if (this.redrawinprogress) {
            return;
        }
        this.redrawinprogress = true;
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                int ii = 0;
                try {
                    PremiumStatus.this.lbl.setVisible(false);
                    int i = 0;
                    while (i < 15) {
                        PremiumStatus.this.bars[i].setVisible(false);
                        ++i;
                    }
                    boolean enabled = false;
                    for (HostPluginWrapper wrapper : HostPluginWrapper.getHostWrapper()) {
                        ArrayList accs;
                        String host = wrapper.getHost();
                        if (!wrapper.isLoaded() || !wrapper.isEnabled() || (accs = AccountController.getInstance().getAllAccounts(host)).size() <= 0) continue;
                        PluginForHost plugin = wrapper.getPlugin();
                        long max = 0L;
                        long left = 0L;
                        enabled = false;
                        boolean special = false;
                        for (Account a : accs) {
                            if (!a.isEnabled()) continue;
                            enabled = true;
                            AccountInfo ai = a.getAccountInfo();
                            if (ai == null || ai.isExpired()) continue;
                            if (!ai.isUnlimitedTraffic()) {
                                if (a.isTempDisabled()) continue;
                                max += ai.getTrafficMax();
                                if (left == -1L) continue;
                                left += ai.getTrafficLeft();
                                if (!ai.isSpecialTraffic()) continue;
                                special = true;
                                continue;
                            }
                            left = -1L;
                        }
                        if (!enabled) continue;
                        PremiumStatus.this.bars[ii].setVisible(true);
                        PremiumStatus.this.bars[ii].setIcon(plugin.getHosterIcon());
                        PremiumStatus.this.bars[ii].setAlignmentX(1.0f);
                        PremiumStatus.this.bars[ii].setPlugin(plugin);
                        if (left == 0L) {
                            PremiumStatus.this.bars[ii].setMaximum(10L);
                            PremiumStatus.this.bars[ii].setValue(0L);
                            if (special) {
                                PremiumStatus.this.bars[ii].setToolTipText(JDL.LF((String)"gui.premiumstatus.expired_maybetraffic.tooltip", (String)"%s - %s account(s) -- At the moment it may be that no premium traffic is left.", (Object[])new Object[]{host, accs.size()}));
                            } else {
                                PremiumStatus.this.bars[ii].setToolTipText(JDL.LF((String)"gui.premiumstatus.expired_traffic.tooltip", (String)"%s - %s account(s) -- At the moment no premium traffic is available.", (Object[])new Object[]{host, accs.size()}));
                            }
                        } else if (left > 0L) {
                            PremiumStatus.this.bars[ii].setMaximum(max);
                            PremiumStatus.this.bars[ii].setValue(left);
                            PremiumStatus.this.bars[ii].setToolTipText(JDL.LF((String)"gui.premiumstatus.traffic.tooltip", (String)"%s - %s account(s) -- You can download up to %s today.", (Object[])new Object[]{host, accs.size(), Formatter.formatReadable((long)left)}));
                        } else {
                            PremiumStatus.this.bars[ii].setMaximum(10L);
                            PremiumStatus.this.bars[ii].setValue(10L);
                            PremiumStatus.this.bars[ii].setToolTipText(JDL.LF((String)"gui.premiumstatus.unlimited_traffic.tooltip", (String)"%s -- Unlimited traffic! You can download as much as you want to.", (Object[])new Object[]{host}));
                        }
                        if (++ii < 15) continue;
                        PremiumStatus.this.invalidate();
                        return null;
                    }
                    PremiumStatus.this.invalidate();
                    return null;
                }
                finally {
                    PremiumStatus.this.redrawinprogress = false;
                }
            }
        }.start();
    }

    public void onAccountControllerEvent(AccountControllerEvent event) {
        switch (event.getID()) {
            case 10: 
            case 11: 
            case 20: 
            case 30: 
            case 31: {
                this.requestUpdate();
                break;
            }
        }
    }

    public void requestUpdate() {
        this.updateIntervalTimer.restart();
    }

    private void doUpdate() {
        if (this.updateinprogress || !this.guiInitComplete) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("PremiumStatus: update");
                PremiumStatus.this.updateinprogress = true;
                if (!PremiumStatus.this.updating && JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true).booleanValue()) {
                    PremiumStatus.this.updatePremium();
                }
                PremiumStatus.this.redraw();
                PremiumStatus.this.updateinprogress = false;
            }
        }.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateIntervalTimer) {
            this.doUpdate();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.premium) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                if (this.popup == null) {
                    this.popup = new JPopupMenu();
                    HosterMenu.update(this.popup);
                }
                this.popup.show(this.premium, e.getPoint().x, e.getPoint().y);
            }
            return;
        }
        int i = 0;
        while (i < 15) {
            if (this.bars[i] == e.getSource()) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    ArrayList entries = this.bars[i].getPlugin().createMenuitems();
                    for (MenuAction next : entries) {
                        JMenuItem mi = Menu.getJMenuItem(next);
                        if (mi == null) {
                            popup.addSeparator();
                            continue;
                        }
                        popup.add(mi);
                    }
                    popup.show(this.bars[i], e.getPoint().x, e.getPoint().y);
                } else {
                    this.bars[i].getPlugin().getConfig().setGroup(new ConfigGroup(this.bars[i].getPlugin().getHost(), JDTheme.II((String)"gui.images.taskpanes.premium", (int)24, (int)24)));
                    UserIF.getInstance().requestPanel(UserIF.Panels.CONFIGPANEL, this.bars[i].getPlugin().getConfig());
                }
                return;
            }
            ++i;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void controlEvent(ControlEvent event) {
        if (event.getID() == 30 && event.getSource() instanceof Main) {
            this.guiInitComplete = true;
            JDUtilities.getController().removeControlListener((ControlListener)this);
            this.requestUpdate();
        }
    }
}

