/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.events;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jd.controlling.JDLogger;
import jd.gui.swing.components.MouseFollower;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.JDGui;
import jd.nutils.Formatter;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class EDTEventQueue
extends EventQueue {
    private int lastPoint = 0;
    private JPanel mouseOver = new JPanel((LayoutManager)new MigLayout("ins 3"));
    private JLabel lbl = new JLabel(JDTheme.II((String)"gui.images.help", (int)24, (int)24));

    public EDTEventQueue() {
        this.mouseOver.add((Component)this.lbl, "alignx left");
        this.mouseOver.setBorder(BorderFactory.createLineBorder(this.mouseOver.getBackground().darker()));
    }

    protected void dispatchEvent(AWTEvent ev) {
        MouseEvent e;
        if (ev instanceof MouseEvent) {
            Component source;
            Point point;
            e = (MouseEvent)ev;
            if ((e.getID() == 502 || e.getID() == 500) && this.lastPoint > 0) {
                --this.lastPoint;
            } else if (e.getID() == 501 && e.isControlDown() && e.isShiftDown()) {
                this.lastPoint = 2;
                point = e.getPoint();
                source = JDGui.getInstance().getMainFrame().getContentPane();
                point.x -= source.getLocationOnScreen().x - JDGui.getInstance().getMainFrame().getLocationOnScreen().x;
                point.y -= source.getLocationOnScreen().y - JDGui.getInstance().getMainFrame().getLocationOnScreen().y;
                final StringBuilder sb = new StringBuilder();
                while (source != null) {
                    Component source2 = source.getComponentAt(point);
                    if (source instanceof JTabbedPane) {
                        source2 = ((JTabbedPane)source).getSelectedComponent();
                    }
                    if (source2 == source || source2 == null) {
                        if (sb.length() > 0) {
                            new Thread(){

                                public void run() {
                                    try {
                                        String url = "http://jdownloader.org/quickhelp/" + sb;
                                        JLink.openURL(url);
                                        return;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        return;
                                    }
                                }
                            }.start();
                            return;
                        }
                        break;
                    }
                    if (source2 != null) {
                        point.x -= source2.getLocation().x;
                        point.y -= source2.getLocation().y;
                        if (source2.getName() != null) {
                            if (sb.length() > 0) {
                                sb.append(".");
                            }
                            sb.append(source2.getName().replace(" ", "-"));
                        }
                    }
                    source = source2;
                }
            } else {
                if (e.getID() == 501 && e.isControlDown() && e.isAltDown()) {
                    this.lastPoint = 2;
                    Point point2 = e.getPoint();
                    Component source2 = JDGui.getInstance().getMainFrame().getContentPane();
                    point2.x -= source2.getLocationOnScreen().x - JDGui.getInstance().getMainFrame().getLocationOnScreen().x;
                    point2.y -= source2.getLocationOnScreen().y - JDGui.getInstance().getMainFrame().getLocationOnScreen().y;
                    StringBuilder sb2 = new StringBuilder();
                    int i = 0;
                    while (source2 != null) {
                        Component source22 = ((Component)source2).getComponentAt(point2);
                        if (source2 instanceof JTabbedPane) {
                            source22 = ((JTabbedPane)source2).getSelectedComponent();
                        }
                        if (source22 == source2 || source22 == null) {
                            System.out.println(sb2);
                            return;
                        }
                        if (source22 != null) {
                            point2.x -= source22.getLocation().x;
                            point2.y -= source22.getLocation().y;
                            if (source22 != source2) {
                                sb2.append("\r\n" + Formatter.fillString((String)"", (String)" ", (String)"", (int)(i * 3)) + " - " + source22.getClass().getName() + "/" + (source22 instanceof JLabel) + "(" + source22.getName() + ")");
                                String text = null;
                                if (source22 instanceof JLabel) {
                                    text = ((JLabel)source22).getText();
                                } else {
                                    Method method = null;
                                    try {
                                        method = source22.getClass().getMethod("getText", new Class[0]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        method = source22.getClass().getMethod("getTitle", new Class[0]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (method != null) {
                                        try {
                                            text = "" + method.invoke((Object)source22, new Object[0]);
                                        }
                                        catch (IllegalArgumentException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (IllegalAccessException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (InvocationTargetException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                                if (text != null) {
                                    String[] keys = JDL.getKeysFor((String)text);
                                    if (keys != null) {
                                        String[] stringArray = keys;
                                        int n = keys.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String t = stringArray[n2];
                                            sb2.append("\r\n" + Formatter.fillString((String)"", (String)" ", (String)"", (int)(i * 3)) + " Possible Translation: " + JDL.L((String)t, (String)text) + " (" + t + ")");
                                            ++n2;
                                        }
                                        JDLogger.getLogger().info("" + sb2);
                                    }
                                    if (source22 instanceof JLabel) {
                                        ((JLabel)source22).setText(keys[0]);
                                    }
                                }
                            }
                        }
                        source2 = source22;
                    }
                    return;
                }
                if (e.getID() == 503 && e.isControlDown() && e.isShiftDown()) {
                    point = e.getPoint();
                    source = JDGui.getInstance().getMainFrame().getContentPane();
                    point.x -= source.getLocationOnScreen().x - JDGui.getInstance().getMainFrame().getLocationOnScreen().x;
                    point.y -= source.getLocationOnScreen().y - JDGui.getInstance().getMainFrame().getLocationOnScreen().y;
                    while (source != null) {
                        Component source2 = source.getComponentAt(point);
                        if (source instanceof JTabbedPane) {
                            source2 = ((JTabbedPane)source).getSelectedComponent();
                        }
                        if (source != null && source2 != null && source2 != source) {
                            source = source2;
                            point.x -= source.getLocation().x;
                            point.y -= source.getLocation().y;
                            if (source.getName() == null) continue;
                            this.lbl.setText(JDL.LF((String)"gui.quickhelp.text", (String)"Click for help: %s", (Object[])new Object[]{source.getName()}));
                            this.mouseOver.revalidate();
                            MouseFollower.show(this.mouseOver);
                        }
                        break;
                    }
                } else {
                    MouseFollower.hide();
                }
            }
        }
        super.dispatchEvent(ev);
        if (!(ev instanceof MouseEvent)) {
            return;
        }
        e = (MouseEvent)ev;
        if (!e.isPopupTrigger()) {
            return;
        }
        if (e.getComponent() == null) {
            return;
        }
        Component c = null;
        Point point = e.getPoint();
        if (e.getSource() instanceof JDialog) {
            c = SwingUtilities.getDeepestComponentAt((JDialog)e.getSource(), (int)point.getX(), (int)point.getY());
        } else {
            Container source = JDGui.getInstance().getMainFrame().getContentPane();
            point.x -= source.getLocationOnScreen().x - JDGui.getInstance().getMainFrame().getLocationOnScreen().x;
            point.y -= source.getLocationOnScreen().y - JDGui.getInstance().getMainFrame().getLocationOnScreen().y;
            c = SwingUtilities.getDeepestComponentAt(source, (int)point.getX(), (int)point.getY());
        }
        if (!(c instanceof JTextComponent)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        JTextComponent t = (JTextComponent)c;
        JPopupMenu menu = new JPopupMenu();
        menu.add(new MenuAbstractAction(t, JDL.L((String)"gui.textcomponent.context.cut", (String)"Ausschneiden"), JDTheme.II((String)"gui.icons.cut", (int)16, (int)16), JDL.L((String)"gui.textcomponent.context.cut.acc", (String)"ctrl X")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                this.c.cut();
            }

            public boolean isEnabled() {
                return !(this.c instanceof JPasswordField);
            }
        });
        menu.add(new MenuAbstractAction(t, JDL.L((String)"gui.textcomponent.context.copy", (String)"Kopieren"), JDTheme.II((String)"gui.icons.copy", (int)16, (int)16), JDL.L((String)"gui.textcomponent.context.copy.acc", (String)"ctrl C")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                this.c.copy();
            }

            public boolean isEnabled() {
                return !(this.c instanceof JPasswordField) && this.c.isEnabled() && this.c.getSelectedText() != null;
            }
        });
        menu.add(new MenuAbstractAction(t, JDL.L((String)"gui.textcomponent.context.paste", (String)"Einf\u00fcgen"), JDTheme.II((String)"gui.icons.paste", (int)16, (int)16), JDL.L((String)"gui.textcomponent.context.paste.acc", (String)"ctrl V")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                this.c.paste();
            }

            public boolean isEnabled() {
                if (this.c.isEditable() && this.c.isEnabled()) {
                    Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                    return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                }
                return false;
            }
        });
        menu.add(new MenuAbstractAction(t, JDL.L((String)"gui.textcomponent.context.delete", (String)"L\u00f6schen"), JDTheme.II((String)"gui.icons.delete", (int)16, (int)16), JDL.L((String)"gui.textcomponent.context.delete.acc", (String)"DELETE")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                this.c.replaceSelection(null);
            }
        });
        menu.add(new MenuAbstractAction(t, JDL.L((String)"gui.textcomponent.context.selectall", (String)"Alles ausw\u00e4hlen"), JDTheme.II((String)"gui.icons.select_all", (int)16, (int)16), JDL.L((String)"gui.textcomponent.context.selectall.acc", (String)"ctrl A")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                this.c.selectAll();
            }

            public boolean isEnabled() {
                return this.c.isEnabled() && this.c.getText().length() > 0;
            }
        });
        Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), t);
        menu.show(t, pt.x, pt.y);
    }

    abstract class MenuAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        JTextComponent c;

        public MenuAbstractAction(JTextComponent c, String text, ImageIcon icon, String acc) {
            super(text);
            this.c = c;
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(acc));
        }

        public boolean isEnabled() {
            return this.c.isEditable() && this.c.isEnabled() && this.c.getSelectedText() != null;
        }
    }
}

