/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.interfaces;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.interfaces.DroppedPanel;
import jd.gui.swing.jdgui.interfaces.SideBarPanel;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.toolbar.ViewToolbar;
import jd.utils.JDTheme;
import net.miginfocom.swing.MigLayout;

public abstract class View
extends SwitchPanel {
    private static final long serialVersionUID = 8661526331504317690L;
    public static final int ICON_SIZE = 16;
    public static final Border ORG_BORDER = BorderFactory.createEmptyBorder();
    private JPanel rightPane;
    protected JScrollPane sidebar;
    private SideBarPanel sidebarContent;
    private SwitchPanel content;
    private JPanel topContent;
    private JPanel bottomContent;
    private SwitchPanel infoPanel;
    private SwitchPanel defaultInfoPanel;
    private ViewToolbar toolbar;
    private Border orgSidebarBorder;

    public View() {
        SwingGui.checkEDT();
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[]0[grow,fill]", "[grow,fill]"));
        this.sidebar = new JScrollPane();
        this.add((Component)this.sidebar, "width 200!,hidemode 1,gapright 3");
        ColorUIResource line = MetalLookAndFeel.getControl();
        this.orgSidebarBorder = this.sidebar.getBorder();
        this.sidebar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, line));
        this.sidebar.setHorizontalScrollBarPolicy(31);
        this.sidebar.setVisible(false);
        this.rightPane = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.add(this.rightPane);
        this.topContent = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[]"));
        this.add((Component)this.topContent, "gapbottom 3,dock NORTH,hidemode 3");
        this.topContent.setVisible(false);
        this.bottomContent = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 0", "[grow,fill]", "[]"));
        this.add((Component)this.bottomContent, "dock SOUTH,hidemode 3");
        this.bottomContent.setVisible(false);
    }

    public void setSidebarBorder(Border b) {
        if (ORG_BORDER == b) {
            this.sidebar.setBorder(this.orgSidebarBorder);
        } else {
            this.sidebar.setBorder(b);
        }
    }

    protected void setDefaultInfoPanel(DroppedPanel panel) {
        this.defaultInfoPanel = panel;
        if (this.getInfoPanel() == null) {
            this.setInfoPanel(panel);
        }
    }

    public void setInfoPanel(SwitchPanel info) {
        SwingGui.checkEDT();
        if (info == null) {
            info = this.defaultInfoPanel;
        }
        if (this.infoPanel == info) {
            return;
        }
        if (info == null) {
            this.bottomContent.setVisible(false);
        } else {
            this.bottomContent.setVisible(true);
            this.bottomContent.removeAll();
            this.bottomContent.add(info);
        }
        if (this.infoPanel != null && this.isShown()) {
            this.infoPanel.setHidden();
        }
        this.revalidate();
        this.infoPanel = info;
        if (this.infoPanel != null && this.isShown()) {
            this.infoPanel.setShown();
        }
    }

    public SwitchPanel getInfoPanel() {
        return this.infoPanel;
    }

    protected void setToolBar(ViewToolbar toolbar) {
        SwingGui.checkEDT();
        if (toolbar == null) {
            this.topContent.setVisible(false);
        } else {
            this.topContent.setVisible(true);
            this.topContent.removeAll();
            this.topContent.add(toolbar);
        }
        this.toolbar = toolbar;
        this.revalidate();
    }

    public synchronized void setContent(SwitchPanel right) {
        SwingGui.checkEDT();
        boolean found = false;
        Component[] componentArray = this.rightPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setVisible(false);
            if (c == right) {
                found = true;
            }
            ++n2;
        }
        if (right != null) {
            right.setVisible(true);
            if (!found) {
                this.rightPane.add((Component)right, "hidemode 3");
            }
        }
        if (this.content != null && this.isShown()) {
            this.content.setHidden();
        }
        this.content = right;
        this.revalidate();
        if (this.content != null && this.isShown()) {
            this.content.setShown();
        }
    }

    public SwitchPanel getContent() {
        return this.content;
    }

    public void setSideBar(SideBarPanel left) {
        SwingGui.checkEDT();
        if (left == this.sidebarContent) {
            return;
        }
        if (left == null) {
            this.sidebar.setVisible(false);
        } else {
            this.sidebar.setVisible(true);
            this.sidebar.setViewportView(left);
        }
        if (this.sidebarContent != null && this.isShown()) {
            this.sidebarContent.setHidden();
        }
        this.sidebarContent = left;
        if (this.isShown()) {
            left.setShown();
        }
    }

    public SideBarPanel getSidebar() {
        return this.sidebarContent;
    }

    public abstract String getTooltip();

    public abstract String getTitle();

    public abstract Icon getIcon();

    public static Icon getDefaultIcon() {
        return JDTheme.II((String)"gui.images.add_package", (int)16, (int)16);
    }
}

