/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.JDController;
import jd.event.ControlListener;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.menu.JStartMenu;
import jd.gui.swing.menu.HosterMenu;
import jd.nutils.JDFlags;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class PremiumMenu
extends JStartMenu
implements ActionListener,
AccountControllerListener {
    private static final long serialVersionUID = 5075413754334671773L;
    private static PremiumMenu INSTANCE;
    private JMenuItem config;
    private Timer Update_Async = new Timer(250, this);
    private ToolBarAction tba;

    private PremiumMenu() {
        super("gui.menu.premium", "gui.images.taskpanes.premium");
        this.Update_Async.setInitialDelay(250);
        this.Update_Async.setRepeats(false);
        this.initAction();
        this.updateMenu();
        AccountController.getInstance().addListener((AccountControllerListener)this);
    }

    private void initAction() {
        this.tba = new ToolBarAction("premiumMenu.toggle", "gui.images.premium_enabled"){
            private static final long serialVersionUID = 4276436625882302179L;

            public void onAction(ActionEvent e) {
                int answer;
                if (!this.isSelected() && JDFlags.hasAllFlags((int)(answer = UserIO.getInstance().requestConfirmDialog(36, JDL.L((String)"dialogs.premiumstatus.global.title", (String)"Disable Premium?"), JDL.L((String)"dialogs.premiumstatus.global.message", (String)"Do you really want to disable all premium accounts?"), JDTheme.II((String)"gui.images.warning", (int)32, (int)32), JDL.L((String)"gui.btn_yes", (String)"Yes"), JDL.L((String)"gui.btn_no", (String)"No"))), (int[])new int[]{4}) && !JDFlags.hasAllFlags((int)answer, (int[])new int[]{8})) {
                    this.setSelected(true);
                    return;
                }
                JDUtilities.getConfiguration().setProperty("USE_PREMIUM_V3", (Object)this.isSelected());
                JDUtilities.getConfiguration().save();
            }

            public void initDefaults() {
                this.setEnabled(true);
                this.setToolTipText(JDL.L((String)"gui.menu.action.premium.desc", (String)"Enable Premiumusage globally"));
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName() == "SwingSelectedKey") {
                            this.setIcon((Boolean)evt.getNewValue() != false ? "gui.images.premium_enabled" : "gui.images.premium_disabled");
                        }
                    }
                });
                JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"USE_PREMIUM_V3"}){

                    public void onPropertyChanged(Property source, String key) {
                        if (source.getBooleanProperty(key, true).booleanValue()) {
                            this.setSelected(true);
                        } else {
                            this.setSelected(false);
                        }
                    }
                });
                this.setType(ToolBarAction.Types.TOGGLE);
                this.setSelected(JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true));
            }

            public void init() {
                if (this.inited) {
                    return;
                }
                this.inited = true;
            }
        };
    }

    public static PremiumMenu getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PremiumMenu();
        }
        return INSTANCE;
    }

    private void updateMenu() {
        this.add(new JCheckBoxMenuItem(this.tba));
        this.addSeparator();
        HosterMenu.update(this);
        this.addSeparator();
        this.config = new JMenuItem(JDL.L((String)"gui.menu.action.config.desc", (String)"Premium Settings"));
        this.config.addActionListener(this);
        this.add(this.config);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.Update_Async) {
            new GuiRunnable<Object>(){

                @Override
                public Object runSave() {
                    PremiumMenu.this.update();
                    return null;
                }
            }.start();
            return;
        }
        if (e.getSource() == this.config) {
            SwingGui.getInstance().requestPanel(UserIF.Panels.PREMIUMCONFIG, null);
        }
    }

    public void update() {
        this.removeAll();
        this.updateMenu();
    }

    public void onAccountControllerEvent(AccountControllerEvent event) {
        switch (event.getID()) {
            case 10: 
            case 11: {
                this.Update_Async.restart();
            }
        }
    }
}

