/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.gui.swing.Factory;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.settings.GUIConfigEntry;
import jd.nutils.JDFlags;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class ConfigPanel
extends SwitchPanel {
    private static final long serialVersionUID = 3383448498625377495L;
    protected ArrayList<GUIConfigEntry> entries = new ArrayList();
    protected Logger logger = JDLogger.getLogger();
    protected JPanel panel;
    private ConfigGroup currentGroup;
    private JPanel header;

    public ConfigPanel() {
        this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0", "[fill,grow]", "[fill,grow]"));
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new MigLayout("ins 0 10 10 10,wrap 2", "[fill,grow 10]10[fill,grow]"));
    }

    public ConfigPanel(ConfigContainer container) {
        this();
        for (ConfigEntry cfgEntry : container.getEntries()) {
            GUIConfigEntry ce = new GUIConfigEntry(cfgEntry);
            if (ce == null) continue;
            this.addGUIConfigEntry(ce);
        }
        this.load();
        this.add(this.panel);
    }

    public String getBreadcrum() {
        return "";
    }

    public static String getTitle() {
        return "NOTITLE";
    }

    public void addGUIConfigEntry(GUIConfigEntry entry, JPanel panel) {
        ConfigGroup group = entry.getConfigEntry().getGroup();
        if (group == null) {
            if (this.currentGroup != null) {
                panel.add((Component)new JSeparator(), "spanx,gapbottom 15,gaptop 15");
                this.currentGroup = null;
            }
            if (entry.getDecoration() != null) {
                switch (entry.getConfigEntry().getType()) {
                    case 10: 
                    case 110: {
                        panel.add((Component)entry.getDecoration(), "spany " + entry.getInput().length + ",spanx, gapright " + this.getGapRight());
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        panel.add((Component)entry.getDecoration(), "spany " + Math.max(1, entry.getInput().length) + (entry.getInput().length == 0 ? ",spanx" : ""));
                    }
                }
            }
            int i = 0;
            JComponent[] jComponentArray = entry.getInput();
            int n = jComponentArray.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent c = jComponentArray[n2];
                ++i;
                switch (entry.getConfigEntry().getType()) {
                    case 2: {
                        panel.add((Component)c, entry.getDecoration() == null ? "spanx,gapright " + this.getGapRight() : "width n:n:160,gapright " + this.getGapRight());
                        break;
                    }
                    case 10: 
                    case 110: {
                        panel.add((Component)new JScrollPane(c), "spanx,gapright " + this.getGapRight() + ",growy,pushy");
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        panel.add((Component)c, entry.getDecoration() == null ? "spanx,gapright " + this.getGapRight() : "gapright " + this.getGapRight());
                    }
                }
                ++n2;
            }
            this.entries.add(entry);
            this.currentGroup = null;
            return;
        }
        if (this.currentGroup != group) {
            this.header = Factory.createHeader(group);
            panel.add((Component)this.header, "spanx,hidemode 3");
            this.header.setVisible(false);
            this.currentGroup = group;
        }
        if (entry.getDecoration() != null) {
            switch (entry.getConfigEntry().getType()) {
                case 10: 
                case 110: {
                    panel.add((Component)entry.getDecoration(), "gapleft " + this.getGapLeft() + ",spany " + entry.getInput().length + ",spanx");
                    break;
                }
                default: {
                    panel.add((Component)entry.getDecoration(), "gapleft " + this.getGapLeft() + ",spany " + entry.getInput().length + (entry.getInput().length == 0 ? ",spanx" : ""));
                }
            }
        }
        int i = 0;
        JComponent[] jComponentArray = entry.getInput();
        int n = jComponentArray.length;
        int n3 = 0;
        while (n3 < n) {
            JComponent c = jComponentArray[n3];
            ++i;
            switch (entry.getConfigEntry().getType()) {
                case 2: {
                    panel.add((Component)c, entry.getDecoration() == null ? "spanx,gapright " + this.getGapRight() + ",gapleft " + this.getGapLeft() : "width n:n:160,gapright " + this.getGapRight());
                    this.header.setVisible(true);
                    break;
                }
                case 10: {
                    panel.add((Component)new JScrollPane(c), "spanx,gapright " + this.getGapRight() + ",growy,pushy,gapleft " + this.getGapLeft());
                    this.header.setVisible(true);
                    break;
                }
                default: {
                    panel.add((Component)c, entry.getDecoration() == null ? "spanx,gapright " + this.getGapRight() + ",gapleft " + this.getGapLeft() : "gapright " + this.getGapRight());
                    this.header.setVisible(true);
                }
            }
            ++n3;
        }
        this.entries.add(entry);
    }

    private String getGapLeft() {
        return "35";
    }

    private String getGapRight() {
        return "20";
    }

    public void addGUIConfigEntry(GUIConfigEntry entry) {
        this.addGUIConfigEntry(entry, this.panel);
    }

    public void initPanel() {
    }

    public final void load() {
        this.loadConfigEntries();
        this.loadSpecial();
    }

    private final void loadConfigEntries() {
        for (GUIConfigEntry akt : this.entries) {
            akt.load();
        }
    }

    public final void save() {
        this.saveSpecial();
        this.saveConfigEntries();
    }

    protected void loadSpecial() {
    }

    protected void saveSpecial() {
    }

    public void onShow() {
        this.load();
    }

    public void onHide() {
        int answer;
        ConfigEntry.PropertyType changes = this.hasChanges();
        this.save();
        if (changes == ConfigEntry.PropertyType.NEEDS_RESTART && !JDGui.getInstance().isExitRequested() && JDFlags.hasSomeFlags((int)(answer = UserIO.getInstance().requestConfirmDialog(0, JDL.L((String)"jd.gui.swing.jdgui.settings.ConfigPanel.restartquestion.title", (String)"Restart required!"), JDL.L((String)"jd.gui.swing.jdgui.settings.ConfigPanel.restartquestion", (String)"This option needs a JDownloader restart."), null, JDL.L((String)"jd.gui.swing.jdgui.settings.ConfigPanel.restartquestion.ok", (String)"Restart NOW!"), null)), (int[])new int[]{10})) {
            JDUtilities.restartJD((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry.PropertyType hasChanges() {
        ConfigEntry.PropertyType ret = ConfigEntry.PropertyType.NONE;
        ArrayList<GUIConfigEntry> arrayList = this.entries;
        synchronized (arrayList) {
            for (GUIConfigEntry akt : this.entries) {
                Object old;
                if (akt.getConfigEntry().getPropertyInstance() == null || akt.getConfigEntry().getPropertyName() == null) continue;
                if (akt.getConfigEntry().hasChanges()) {
                    ret = ret.getMax(ConfigEntry.PropertyType.NORMAL);
                }
                if ((old = akt.getConfigEntry().getPropertyInstance().getProperty(akt.getConfigEntry().getPropertyName())) == null && akt.getText() != null) {
                    ret = ret.getMax(akt.getConfigEntry().getPropertyType());
                    System.out.println(String.valueOf(akt.getConfigEntry().getPropertyName()) + "1: " + ret);
                    continue;
                }
                if (old == akt.getText()) {
                    System.out.println(String.valueOf(akt.getConfigEntry().getPropertyName()) + "2: " + ret);
                    continue;
                }
                if (old.equals(akt.getText())) continue;
                ret = ret.getMax(akt.getConfigEntry().getPropertyType());
                System.out.println(String.valueOf(akt.getConfigEntry().getPropertyName()) + "3: " + ret);
            }
        }
        return ret;
    }

    private final void saveConfigEntries() {
        ArrayList<SubConfiguration> subs = new ArrayList<SubConfiguration>();
        for (GUIConfigEntry akt : this.entries) {
            if (akt.getConfigEntry().getPropertyInstance() instanceof SubConfiguration && !subs.contains(akt.getConfigEntry().getPropertyInstance())) {
                subs.add((SubConfiguration)akt.getConfigEntry().getPropertyInstance());
            }
            akt.save();
        }
        for (SubConfiguration subConfiguration : subs) {
            subConfiguration.save();
        }
    }
}

