/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.premium.Columns;

import java.awt.Color;
import java.awt.Component;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.JDProgressBarRender;
import jd.gui.swing.jdgui.settings.panels.premium.HostAccounts;
import jd.nutils.Formatter;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class TrafficLeftColumn
extends JDTableColumn {
    private static final long serialVersionUID = -5291590062503352550L;
    private Color COL_PROGRESS = null;
    private Color COL_PROGRESS_ERROR = new Color(0xCC3300);
    private Color COL_PROGRESS_NORMAL;
    private JRendererLabel jlr;
    private JDProgressBarRender progress = new JDProgressBarRender();

    public TrafficLeftColumn(String name, JDTableModel table) {
        super(name, table);
        this.progress.setStringPainted(true);
        this.progress.setOpaque(true);
        this.COL_PROGRESS_NORMAL = this.progress.getForeground();
        this.jlr = new JRendererLabel();
        this.jlr.setBorder(null);
    }

    public Object getCellEditorValue() {
        return null;
    }

    public void handleSelected(Component c, JDTableModel table, Object value, boolean isSelected, int row, int column) {
        if (c instanceof JDProgressBarRender) {
            ((JDProgressBarRender)c).setForeground(this.COL_PROGRESS);
            if (isSelected) {
                ((JDProgressBarRender)c).setBackground(JDTableColumn.background);
                return;
            }
            ((JDProgressBarRender)c).setBackground(JDTableColumn.background);
            for (JDRowHighlighter high : table.getJDRowHighlighter()) {
                if (!high.doHighlight(value)) continue;
                ((JDProgressBarRender)c).setBackground(high.getColor());
                return;
            }
        } else {
            super.handleSelected(c, table, value, isSelected, row, column);
        }
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Account) {
            return ((Account)obj).isEnabled();
        }
        if (obj instanceof HostAccounts) {
            return ((HostAccounts)((Object)obj)).isEnabled();
        }
        return true;
    }

    public boolean isSortable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Account) {
            Account ac = (Account)value;
            AccountInfo ai = ac.getAccountInfo();
            if (!ac.isValid()) {
                value = "Invalid account";
                this.progress.setMaximum(10);
                this.progress.setValue(10);
                this.COL_PROGRESS = this.COL_PROGRESS_ERROR;
            } else if (ai == null) {
                value = "Unknown";
                this.progress.setMaximum(10);
                this.progress.setValue(10);
                this.COL_PROGRESS = this.COL_PROGRESS_ERROR;
            } else {
                this.COL_PROGRESS = this.COL_PROGRESS_NORMAL;
                if (ai.isUnlimitedTraffic()) {
                    value = "Unlimited";
                    this.progress.setMaximum(10);
                    this.progress.setValue(10);
                } else {
                    value = String.valueOf(Formatter.formatReadable((long)ai.getTrafficLeft())) + "/" + Formatter.formatReadable((long)ai.getTrafficMax());
                    this.progress.setMaximum(ai.getTrafficMax());
                    this.progress.setValue(ai.getTrafficLeft());
                }
            }
            this.progress.setString((String)value);
            return this.progress;
        }
        HostAccounts ha = (HostAccounts)((Object)value);
        if (!ha.gotAccountInfos()) {
            this.jlr.setText("Unknown");
        } else if (ha.getTraffic() < 0L) {
            this.jlr.setText("Unlimited");
        } else if (ha.getTraffic() == 0L) {
            this.jlr.setText("No Traffic left");
        } else {
            this.jlr.setText(Formatter.formatReadable((long)ha.getTraffic()));
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public void sort(Object obj, boolean sortingToggle) {
    }
}

