/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.premium;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import jd.HostPluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Configuration;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.AccountDialog;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.jdgui.actions.ThreadedAction;
import jd.gui.swing.jdgui.settings.ConfigPanel;
import jd.gui.swing.jdgui.settings.JDLabelListRenderer;
import jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel;
import jd.gui.swing.jdgui.settings.panels.premium.PremiumTable;
import jd.gui.swing.jdgui.views.toolbar.ViewToolbar;
import jd.nutils.JDFlags;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class Premium
extends ConfigPanel
implements ActionListener,
AccountControllerListener {
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.settings.panels.premium.Premium.";
    private static final long serialVersionUID = -7685744533817989161L;
    private PremiumTable internalTable;
    private JScrollPane scrollPane;
    private JCheckBox checkBox;
    private Timer Update_Async;
    protected Logger logger = JDLogger.getLogger();

    public Premium(Configuration configuration) {
        this.initPanel();
        this.load();
    }

    public String getBreadcrum() {
        return JDL.L((String)(String.valueOf(this.getClass().getName()) + ".breadcrum"), (String)this.getClass().getSimpleName());
    }

    public static String getTitle() {
        return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.title", (String)"Premium");
    }

    public void initPanel() {
        this.panel.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]", "[][fill,grow]"));
        this.initPanel(this.panel);
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setOpaque(false);
        tabbed.add(this.getBreadcrum(), this.panel);
        this.add(tabbed);
    }

    private void initPanel(JPanel panel) {
        this.internalTable = new PremiumTable(this);
        this.internalTable.addJDRowHighlighter(new JDRowHighlighter(this.internalTable.getBackground().darker()){

            public boolean doHighlight(Object obj) {
                return !(obj instanceof Account);
            }
        });
        this.scrollPane = new JScrollPane((Component)((Object)this.internalTable));
        this.Update_Async = new Timer(250, this);
        this.Update_Async.setInitialDelay(250);
        this.Update_Async.setRepeats(false);
        AccountController.getInstance().addListener((AccountControllerListener)this);
        this.initActions();
        ViewToolbar vt = new ViewToolbar();
        vt.setList(new String[]{"action.premiumview.addacc", "action.premiumview.removeacc", "action.premium.buy"});
        panel.add((Component)vt, "gapleft 3, split2");
        this.checkBox = new JCheckBox(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.accountSelection", (String)"Always select the premium account with the most traffic left for downloading"));
        panel.add((Component)this.checkBox, "w min!, right");
        this.checkBox.setHorizontalTextPosition(10);
        this.checkBox.setSelected(AccountController.getInstance().getBooleanProperty("ACCOUNT_SELECTION", true));
        panel.add(this.scrollPane);
    }

    protected void saveSpecial() {
        AccountController.getInstance().setProperty("ACCOUNT_SELECTION", (Object)this.checkBox.isSelected());
        AccountController.getInstance().save();
    }

    public ConfigEntry.PropertyType hasChanges() {
        return ConfigEntry.PropertyType.NORMAL;
    }

    private void initActions() {
        new ThreadedAction("action.premiumview.addacc", "gui.images.newlogins"){
            private static final long serialVersionUID = -4407938288408350792L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.premiumview.addacc.tooltip", (String)"Add a new Account"));
            }

            public void init() {
            }

            public void threadedActionPerformed(final ActionEvent e) {
                Premium.this.internalTable.editingStopped(null);
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        if (e.getSource() instanceof PluginForHost) {
                            AccountDialog.showDialog((PluginForHost)e.getSource());
                        } else {
                            AccountDialog.showDialog(null);
                        }
                        return null;
                    }
                }.start();
            }
        };
        new ThreadedAction("action.premiumview.removeacc", "gui.images.delete"){
            private static final long serialVersionUID = -4407938288408350792L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.premiumview.removeacc.tooltip", (String)"Remove selected Account(s)"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                ArrayList<Account> accs = Premium.this.internalTable.getAllSelectedAccounts();
                Premium.this.internalTable.editingStopped(null);
                if (accs.size() == 0) {
                    return;
                }
                if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(0, String.valueOf(JDL.L((String)"action.premiumview.removeacc.ask", (String)"Remove selected?")) + " (" + JDL.LF((String)"action.premiumview.removeacc.accs", (String)"%s Account(s)", (Object[])new Object[]{accs.size()}) + ")"), (int[])new int[]{2, 8})) {
                    for (Account acc : accs) {
                        AccountController.getInstance().removeAccount(null, acc);
                    }
                }
            }
        };
        new ThreadedAction("action.premium.buy", "gui.images.buy"){
            private static final long serialVersionUID = -4407938288408350792L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.buy.tooltip", (String)"Buy a new premium account."));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                Premium.this.internalTable.editingStopped(null);
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        ArrayList plugins = JDUtilities.getPremiumPluginsForHost();
                        Collections.sort(plugins, new Comparator<HostPluginWrapper>(){

                            @Override
                            public int compare(HostPluginWrapper a, HostPluginWrapper b) {
                                return a.getHost().compareToIgnoreCase(b.getHost());
                            }
                        });
                        Object[] data = plugins.toArray(new HostPluginWrapper[plugins.size()]);
                        int selection = UserIO.getInstance().requestComboDialog(0, JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.buy.title", (String)"Buy Premium"), JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.buy.message", (String)"Which hoster are you interested in?"), data, 0, null, JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.Premium.continue", (String)"Continue"), null, new JDLabelListRenderer());
                        try {
                            JLink.openURL(data[selection].getPlugin().getBuyPremiumUrl());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                }.start();
            }
        };
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void onHide() {
        super.onHide();
        this.Update_Async.stop();
        AccountController.getInstance().removeListener((AccountControllerListener)this);
    }

    public void fireTableChanged() {
        try {
            this.internalTable.fireTableChanged();
        }
        catch (Exception e) {
            this.logger.severe("TreeTable Exception, complete refresh!");
            this.Update_Async.restart();
        }
    }

    public void onShow() {
        super.onShow();
        AccountController.getInstance().addListener((AccountControllerListener)this);
        this.fireTableChanged();
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.Update_Async) {
            this.fireTableChanged();
            return;
        }
    }

    public void onAccountControllerEvent(AccountControllerEvent event) {
        switch (event.getID()) {
            case 10: 
            case 11: 
            case 20: 
            case 30: 
            case 31: {
                this.Update_Async.restart();
                break;
            }
        }
    }

    public void setSelectedAccount(Account param) {
        int row = ((PremiumJTableModel)this.internalTable.getModel()).getRowforObject(param);
        this.internalTable.getSelectionModel().setSelectionInterval(row, row);
        this.internalTable.scrollRowToVisible(row);
    }
}

