/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import jd.controlling.DownloadController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.nutils.NaturalOrderComparator;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class FileColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private Border leftGap = BorderFactory.createEmptyBorder(0, 30, 0, 0);
    private ImageIcon icon_fp_open = JDTheme.II((String)"gui.images.package_opened_tree", (int)16, (int)16);
    private ImageIcon icon_fp_open_error = JDTheme.II((String)"gui.images.package_open_error_tree", (int)16, (int)16);
    private ImageIcon icon_fp_closed = JDTheme.II((String)"gui.images.package_closed_tree", (int)16, (int)16);
    private ImageIcon icon_fp_closed_error = JDTheme.II((String)"gui.images.package_closed_error_tree", (int)16, (int)16);
    private ImageIcon imgFileFailed = JDTheme.II((String)"gui.images.offlinefile", (int)16, (int)16);
    private FilePackage fp;
    private JRendererLabel jlr = new JRendererLabel();

    public FileColumn(String name, JDTableModel table) {
        super(name, table);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.fp = (FilePackage)value;
            this.jlr.setText(String.valueOf(this.fp.getName()) + " [" + this.fp.size() + "]");
            if (this.fp.getLinksFailed() > 0) {
                this.jlr.setIcon((Icon)(this.fp.getBooleanProperty("expanded", false) == false ? this.icon_fp_closed_error : this.icon_fp_open_error));
            } else {
                this.jlr.setIcon((Icon)(this.fp.getBooleanProperty("expanded", false) == false ? this.icon_fp_closed : this.icon_fp_open));
            }
            this.jlr.setBorder(null);
        } else {
            this.dLink = (DownloadLink)value;
            if (this.dLink.getLinkStatus().isFailed()) {
                this.jlr.setIcon((Icon)this.imgFileFailed);
            } else {
                this.jlr.setIcon((Icon)this.dLink.getIcon());
            }
            this.jlr.setText(this.dLink.getName());
            this.jlr.setBorder(this.leftGap);
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        final NaturalOrderComparator nc = new NaturalOrderComparator();
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = DownloadController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = DownloadController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<FilePackage>(){

                        @Override
                        public int compare(FilePackage a, FilePackage b) {
                            FilePackage aa = a;
                            FilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            return nc.compare(aa.getName(), bb.getName());
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (FilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinkList(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = a;
                                if (sortingToggle) {
                                    aa = a;
                                    bb = b;
                                }
                                return nc.compare(aa.getName(), bb.getName());
                            }
                        });
                    }
                }
            }
        }
        DownloadController.getInstance().fireStructureUpdate();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }
}

