/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import jd.controlling.DownloadController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.StatusLabel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class HosterColumn
extends JDTableColumn {
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.views.downloadview.TableRenderer.";
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private FilePackage fp;
    private StatusLabel statuspanel = new StatusLabel();
    private FontMetrics fontmetrics;
    private int counter = 0;
    private ImageIcon imgResume;
    private ImageIcon imgPremium;
    private String strResume;
    private String strPremium;
    private String strLoadingFrom;
    private JRendererLabel jlr;

    public HosterColumn(String name, JDTableModel table) {
        super(name, table);
        this.statuspanel.setBorder(null);
        this.fontmetrics = this.statuspanel.getFontMetrics(this.statuspanel.getFont());
        this.jlr = new JRendererLabel();
        this.jlr.setBorder(null);
        this.imgResume = JDTheme.II((String)"gui.images.resume", (int)16, (int)16);
        this.imgPremium = JDTheme.II((String)"gui.images.premium", (int)16, (int)16);
        this.strResume = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.resume", (String)"Resumable download");
        this.strPremium = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.premium", (String)"Loading with Premium");
        this.strLoadingFrom = String.valueOf(JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.loadingFrom", (String)"Loading from")) + " ";
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.fp = (FilePackage)value;
            this.jlr.setText(this.fp.getHoster());
            return this.jlr;
        }
        this.dLink = (DownloadLink)value;
        this.statuspanel.setText(this.dLink.getLinkStatus().getStatusString());
        this.counter = 0;
        if (this.dLink.getTransferStatus().usesPremium()) {
            this.statuspanel.setIcon(this.counter, this.imgPremium, this.strPremium);
            ++this.counter;
        }
        if (this.dLink.getTransferStatus().supportsResume()) {
            this.statuspanel.setIcon(this.counter, this.imgResume, this.strResume);
            ++this.counter;
        }
        if (this.dLink.getPlugin() == null) {
            this.statuspanel.setText("plugin missing");
        } else {
            String s = String.valueOf(this.dLink.getPlugin().getHost()) + this.dLink.getPlugin().getSessionInfo();
            if (this.getCurWidth() > (this.counter + 2) * 16 + this.fontmetrics.stringWidth(s)) {
                this.statuspanel.setText(s);
            } else {
                this.statuspanel.setText("");
            }
            this.statuspanel.setIcon(-1, this.dLink.getPlugin().getHosterIcon(), String.valueOf(this.strLoadingFrom) + this.dLink.getPlugin().getHost());
        }
        this.statuspanel.clearIcons(this.counter);
        return this.statuspanel;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = DownloadController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = DownloadController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<FilePackage>(){

                        @Override
                        public int compare(FilePackage a, FilePackage b) {
                            FilePackage aa = a;
                            FilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            return aa.getHoster().compareToIgnoreCase(bb.getHoster());
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (FilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinkList(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = a;
                                if (sortingToggle) {
                                    aa = a;
                                    bb = b;
                                }
                                return aa.getHost().compareToIgnoreCase(bb.getHost());
                            }
                        });
                    }
                }
            }
        }
        DownloadController.getInstance().fireStructureUpdate();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }
}

