/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.DownloadController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class LoadedColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private FilePackage fp;
    private JRendererLabel jlr = new JRendererLabel();

    public LoadedColumn(String name, JDTableModel table) {
        super(name, table);
        this.jlr.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public boolean defaultVisible() {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.fp = (FilePackage)value;
            if (this.fp.getTotalKBLoaded() < 0L) {
                this.jlr.setText("0 B");
            } else {
                this.jlr.setText(Formatter.formatReadable((long)this.fp.getTotalKBLoaded()));
            }
        } else {
            this.dLink = (DownloadLink)value;
            if (this.dLink.getDownloadCurrent() <= 0L) {
                this.jlr.setText("0 B");
            } else {
                this.jlr.setText(Formatter.formatReadable((long)this.dLink.getDownloadCurrent()));
            }
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = DownloadController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = DownloadController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<FilePackage>(){

                        @Override
                        public int compare(FilePackage a, FilePackage b) {
                            FilePackage aa = a;
                            FilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            if (aa.getTotalKBLoaded() == bb.getTotalKBLoaded()) {
                                return 0;
                            }
                            return aa.getTotalKBLoaded() < bb.getTotalKBLoaded() ? -1 : 1;
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (FilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinkList(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = a;
                                if (sortingToggle) {
                                    aa = a;
                                    bb = b;
                                }
                                if (aa.getDownloadCurrent() == bb.getDownloadCurrent()) {
                                    return 0;
                                }
                                return aa.getDownloadCurrent() < bb.getDownloadCurrent() ? -1 : 1;
                            }
                        });
                    }
                }
            }
        }
        DownloadController.getInstance().fireStructureUpdate();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }
}

