/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.DownloadController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class PartColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private JRendererLabel jlr = new JRendererLabel();

    public PartColumn(String name, JDTableModel table) {
        super(name, table);
        this.jlr.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public boolean defaultVisible() {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.jlr.setText("");
        } else {
            this.dLink = (DownloadLink)value;
            this.jlr.setText(this.dLink.getPart());
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        if (obj == null && DownloadController.getInstance().getPackages().size() == 1) {
            return true;
        }
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = DownloadController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = DownloadController.getInstance().getPackages();
                if (obj != null && packages.size() > 1) {
                    packages = (ArrayList)obj;
                }
                for (FilePackage fp : packages) {
                    Collections.sort(fp.getDownloadLinkList(), new Comparator<DownloadLink>(){

                        @Override
                        public int compare(DownloadLink a, DownloadLink b) {
                            DownloadLink aa = b;
                            DownloadLink bb = a;
                            if (sortingToggle) {
                                aa = a;
                                bb = b;
                            }
                            return aa.getPart().compareToIgnoreCase(bb.getPart());
                        }
                    });
                }
            }
        }
        DownloadController.getInstance().fireStructureUpdate();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }
}

