/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import jd.controlling.ClipboardHandler;
import jd.controlling.DownloadController;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkCheck;
import jd.controlling.LinkCheckEvent;
import jd.controlling.LinkCheckListener;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.DownloadView;
import jd.gui.swing.jdgui.views.downloadview.DownloadTable;
import jd.gui.swing.jdgui.views.downloadview.FilePackageInfo;
import jd.gui.swing.jdgui.views.downloadview.TableAction;
import jd.nutils.JDFlags;
import jd.nutils.io.JDFileFilter;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadLinksPanel
extends SwitchPanel
implements ActionListener,
DownloadControllerListener,
LinkCheckListener {
    private static final long serialVersionUID = -6029423913449902141L;
    private static final int NO_JOB = -1;
    public static final int REFRESH_ALL_DATA_CHANGED = 1;
    public static final int REFRESH_DATA_AND_STRUCTURE_CHANGED = 0;
    public static final int REFRESH_DATA_AND_STRUCTURE_CHANGED_FAST = 10;
    public static final int REFRESH_SPECIFIED_LINKS = 2;
    private static final int UPDATE_TIMING = 250;
    private static DownloadLinksPanel INSTANCE = null;
    private int jobID = 0;
    private ArrayList<Object> jobObjects = new ArrayList();
    private boolean lastSort = true;
    protected Logger logger = JDLogger.getLogger();
    private DownloadTable internalTable = new DownloadTable(this);
    private Timer asyncUpdate;
    private long latestAsyncUpdate;
    private FilePackageInfo filePackageInfo;
    private JScrollPane scrollPane = new JScrollPane((Component)((Object)this.internalTable));
    private boolean notvisible = true;

    private DownloadLinksPanel() {
        super((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow, fill]", "[grow, fill]"));
        this.filePackageInfo = new FilePackageInfo();
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "cell 0 0");
        JDUtilities.getDownloadController().addListener((DownloadControllerListener)this);
        this.asyncUpdate = new Timer(250, this);
        this.latestAsyncUpdate = 0L;
        this.asyncUpdate.setInitialDelay(250);
        this.asyncUpdate.setRepeats(false);
        this.asyncUpdate.restart();
        this.internalTable.getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movetotop").getKeyStroke());
        this.internalTable.getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.moveup").getKeyStroke());
        this.internalTable.getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movedown").getKeyStroke());
        this.internalTable.getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movetobottom").getKeyStroke());
        this.internalTable.getInputMap(0).remove(ActionController.getToolBarAction("action.downloadview.movetotop").getKeyStroke());
        this.internalTable.getInputMap(0).remove(ActionController.getToolBarAction("action.downloadview.moveup").getKeyStroke());
        this.internalTable.getInputMap(0).remove(ActionController.getToolBarAction("action.downloadview.movedown").getKeyStroke());
        this.internalTable.getInputMap(0).remove(ActionController.getToolBarAction("action.downloadview.movetobottom").getKeyStroke());
        this.internalTable.getInputMap(1).remove(ActionController.getToolBarAction("action.downloadview.movetotop").getKeyStroke());
        this.internalTable.getInputMap(1).remove(ActionController.getToolBarAction("action.downloadview.moveup").getKeyStroke());
        this.internalTable.getInputMap(1).remove(ActionController.getToolBarAction("action.downloadview.movedown").getKeyStroke());
        this.internalTable.getInputMap(1).remove(ActionController.getToolBarAction("action.downloadview.movetobottom").getKeyStroke());
        MainTabbedPane.getInstance().getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movetotop").getKeyStroke());
        MainTabbedPane.getInstance().getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.moveup").getKeyStroke());
        MainTabbedPane.getInstance().getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movedown").getKeyStroke());
        MainTabbedPane.getInstance().getInputMap(2).remove(ActionController.getToolBarAction("action.downloadview.movetobottom").getKeyStroke());
    }

    public boolean isNotVisible() {
        return this.notvisible;
    }

    public static synchronized DownloadLinksPanel getDownloadLinksPanel() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadLinksPanel();
        }
        return INSTANCE;
    }

    public DownloadTable getInternalTable() {
        return this.internalTable;
    }

    public void move(byte mode) {
        ArrayList<FilePackage> fps = this.internalTable.getSelectedFilePackages();
        ArrayList<DownloadLink> links = this.internalTable.getSelectedDownloadLinks();
        if (fps.size() > 0) {
            DownloadController.getInstance().move(fps, null, mode);
        }
        if (links.size() > 0) {
            DownloadController.getInstance().move(links, null, mode);
        }
    }

    public boolean needsViewport() {
        return false;
    }

    public void showFilePackageInfo(FilePackage fp) {
        this.filePackageInfo.setPackage(fp);
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                DownloadView.getInstance().setInfoPanel(DownloadLinksPanel.this.filePackageInfo);
                return null;
            }
        }.start();
    }

    public void showDownloadLinkInfo(DownloadLink downloadLink) {
        this.filePackageInfo.setDownloadLink(downloadLink);
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                DownloadView.getInstance().setInfoPanel(DownloadLinksPanel.this.filePackageInfo);
                return null;
            }
        }.start();
    }

    public void hideFilePackageInfo() {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                DownloadView.getInstance().setInfoPanel(null);
                return null;
            }
        }.start();
    }

    public void fireTableChanged(int id, ArrayList<Object> objs) {
        try {
            ArrayList<Object> objs2 = new ArrayList<Object>(objs);
            int id2 = id;
            this.internalTable.fireTableChanged(id2, objs2);
        }
        catch (Exception e) {
            this.logger.severe("TreeTable Exception, complete refresh!");
            this.updateTableTask(0, null);
        }
    }

    @Override
    public void onShow() {
        this.updateTableTask(10, null);
        JDUtilities.getDownloadController().addListener((DownloadControllerListener)this);
        this.internalTable.removeKeyListener(this.internalTable);
        this.internalTable.addKeyListener(this.internalTable);
        this.notvisible = false;
    }

    @Override
    public void onHide() {
        this.notvisible = true;
        JDUtilities.getDownloadController().removeListener((DownloadControllerListener)this);
        this.asyncUpdate.stop();
        this.internalTable.removeKeyListener(this.internalTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTableTask(int id, Object Param) {
        if (!this.isShown()) {
            this.asyncUpdate.stop();
            return;
        }
        boolean changed = false;
        this.asyncUpdate.stop();
        if (id == 10) {
            this.jobID = 10;
            this.fireTableTask();
            this.asyncUpdate.restart();
            return;
        }
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList<Object> arrayList = this.jobObjects;
            synchronized (arrayList) {
                block4 : switch (id) {
                    case 0: {
                        changed = true;
                        this.jobID = 0;
                        this.jobObjects.clear();
                        break;
                    }
                    case 1: {
                        switch (this.jobID) {
                            case 0: 
                            case 1: {
                                break block4;
                            }
                            case -1: 
                            case 2: {
                                changed = true;
                                this.jobID = 1;
                                this.jobObjects.clear();
                                break block4;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.jobID) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            case -1: 
                            case 2: {
                                this.jobID = 2;
                                if (Param instanceof DownloadLink) {
                                    if (!this.jobObjects.contains(Param)) {
                                        changed = true;
                                        this.jobObjects.add(Param);
                                    }
                                    if (this.jobObjects.contains(((DownloadLink)Param).getFilePackage())) break;
                                    changed = true;
                                    this.jobObjects.add(((DownloadLink)Param).getFilePackage());
                                    break;
                                }
                                if (!(Param instanceof ArrayList)) break;
                                for (DownloadLink dl : (ArrayList)Param) {
                                    if (!this.jobObjects.contains(dl)) {
                                        changed = true;
                                        this.jobObjects.add(dl);
                                    }
                                    if (this.jobObjects.contains(dl.getFilePackage())) continue;
                                    changed = true;
                                    this.jobObjects.add(dl.getFilePackage());
                                }
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        if (!changed && System.currentTimeMillis() - this.latestAsyncUpdate > 350L) {
            this.fireTableTask();
        }
        this.asyncUpdate.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableTask() {
        this.latestAsyncUpdate = System.currentTimeMillis();
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList<Object> arrayList = this.jobObjects;
            synchronized (arrayList) {
                if (this.isShown() && this.jobID != -1) {
                    this.fireTableChanged(this.jobID, this.jobObjects);
                }
                this.jobID = -1;
                this.jobObjects.clear();
            }
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        new Thread(){

            public void run() {
                this.setName("DownloadLinks: actionPerformed");
                if (e.getSource() == DownloadLinksPanel.this.asyncUpdate) {
                    DownloadLinksPanel.this.fireTableTask();
                    return;
                }
                ArrayList<FilePackage> selectedPackages = new ArrayList<FilePackage>();
                ArrayList<DownloadLink> selectedLinks = new ArrayList<DownloadLink>();
                HashMap prop = new HashMap();
                HashSet<String> List2 = new HashSet<String>();
                StringBuilder build = new StringBuilder();
                String string = null;
                Object obj = null;
                FilePackage fp = null;
                DownloadLink link = null;
                File folder = null;
                int col = 0;
                if (e.getSource() instanceof JMenuItem) {
                    switch (e.getID()) {
                        case 11: 
                        case 101: {
                            selectedPackages = (ArrayList<FilePackage>)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("packages");
                            break;
                        }
                        case 103: {
                            col = (Integer)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("col");
                            selectedLinks = new ArrayList<DownloadLink>(DownloadLinksPanel.this.internalTable.getSelectedDownloadLinks());
                            selectedPackages = new ArrayList<FilePackage>(DownloadLinksPanel.this.internalTable.getSelectedFilePackages());
                            break;
                        }
                        case 200: 
                        case 400: {
                            prop = (HashMap)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("infos");
                            selectedLinks = (ArrayList)prop.get("links");
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 20: 
                        case 22: 
                        case 100: 
                        case 201: 
                        case 301: 
                        case 401: 
                        case 500: 
                        case 999: 
                        case 9991: {
                            selectedLinks = (ArrayList<DownloadLink>)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("links");
                            break;
                        }
                        case 1: {
                            folder = (File)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("folder");
                            break;
                        }
                        case 7: {
                            link = (DownloadLink)((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("downloadlink");
                            break;
                        }
                        case 600: {
                            obj = ((TableAction)((JMenuItem)e.getSource()).getAction()).getProperty().getProperty("item");
                        }
                    }
                } else if (e.getSource() instanceof TableAction) {
                    switch (e.getID()) {
                        case 1031: {
                            col = (Integer)((TableAction)e.getSource()).getProperty().getProperty("col");
                            break;
                        }
                        case 999: {
                            selectedLinks = (ArrayList)((TableAction)e.getSource()).getProperty().getProperty("links");
                        }
                    }
                }
                switch (e.getID()) {
                    case 401: {
                        DownloadWatchDog.getInstance().forceDownload(selectedLinks);
                        break;
                    }
                    case 600: {
                        DownloadWatchDog.getInstance().toggleStopMark(obj);
                        break;
                    }
                    case 101: {
                        final ArrayList selected_packages2 = new ArrayList(selectedPackages);
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                File ret;
                                JDFileChooser fc = new JDFileChooser();
                                fc.setApproveButtonText(JDL.L((String)"gui.btn_ok", (String)"OK"));
                                fc.setFileSelectionMode(1);
                                fc.setCurrentDirectory(((FilePackage)selected_packages2.get(0)).getDownloadDirectory() != null ? new File(((FilePackage)selected_packages2.get(0)).getDownloadDirectory()) : JDUtilities.getResourceFile((String)"downloads"));
                                if (fc.showOpenDialog(DownloadLinksPanel.this) == 0 && (ret = fc.getSelectedFile()) != null) {
                                    int i = 0;
                                    while (i < selected_packages2.size()) {
                                        ((FilePackage)selected_packages2.get(i)).setDownloadDirectory(ret.getAbsolutePath());
                                        ++i;
                                    }
                                }
                                return null;
                            }
                        }.start();
                        break;
                    }
                    case 11: {
                        String name = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"gui.linklist.editpackagename.message", (String)"Neuer Paketname"), ((FilePackage)selectedPackages.get(0)).getName());
                        if (name == null) break;
                        int i = 0;
                        while (i < selectedPackages.size()) {
                            selectedPackages.get(i).setName(name);
                            ++i;
                        }
                        break;
                    }
                    case 22: {
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            ((DownloadLink)selectedLinks.get(i)).getLinkStatus().setStatus(1);
                            selectedLinks.get(i).getLinkStatus().resetWaitTime();
                            selectedLinks.get(i).getLinkStatus().setStatusText(JDL.L((String)"gui.linklist.status.doresume", (String)"Warte auf Fortsetzung"));
                            ++i;
                        }
                        Set hosts = DownloadLink.getHosterList((ArrayList)selectedLinks);
                        for (String host : hosts) {
                            DownloadWatchDog.getInstance().resetIPBlockWaittime(host);
                            DownloadWatchDog.getInstance().resetTempUnavailWaittime(host);
                        }
                        break;
                    }
                    case 7: {
                        if (link.getLinkType() != 0) break;
                        try {
                            JLink.openURL(link.getBrowserUrl());
                        }
                        catch (Exception e1) {
                            JDLogger.exception((Throwable)e1);
                        }
                        break;
                    }
                    case 1: {
                        JDUtilities.openExplorer(folder);
                        break;
                    }
                    case 20: {
                        GuiRunnable<File> temp = new GuiRunnable<File>(){

                            @Override
                            public File runSave() {
                                JDFileChooser fc = new JDFileChooser("_LOADSAVEDLC");
                                fc.setFileFilter((FileFilter)new JDFileFilter(null, ".dlc", true));
                                if (fc.showSaveDialog(SwingGui.getInstance().getMainFrame()) == 0) {
                                    return fc.getSelectedFile();
                                }
                                return null;
                            }
                        };
                        File ret = (File)temp.getReturnValue();
                        if (ret == null) {
                            return;
                        }
                        if (JDIO.getFileExtension((File)ret) == null || !JDIO.getFileExtension((File)ret).equalsIgnoreCase("dlc")) {
                            ret = new File(String.valueOf(ret.getAbsolutePath()) + ".dlc");
                        }
                        JDUtilities.getController().saveDLC(ret, selectedLinks);
                        break;
                    }
                    case 4: {
                        final ArrayList<DownloadLink> links = selectedLinks;
                        new Thread(){

                            public void run() {
                                if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(0, String.valueOf(JDL.L((String)"gui.downloadlist.reset", (String)"Reset selected downloads?")) + " (" + JDL.LF((String)"gui.downloadlist.delete.size_packagev2", (String)"%s links", (Object[])new Object[]{links.size()}) + ")"), (int[])new int[]{2, 8})) {
                                    int i = 0;
                                    while (i < links.size()) {
                                        ((DownloadLink)links.get(i)).reset();
                                        ++i;
                                    }
                                }
                            }
                        }.start();
                        break;
                    }
                    case 3: {
                        string = DownloadLinksPanel.getPasswordSelectedLinks(selectedLinks);
                        ClipboardHandler.getClipboard().setOldText(string);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                        break;
                    }
                    case 301: {
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            String url;
                            if (((DownloadLink)selectedLinks.get(i)).getLinkType() == 0 && !List2.contains(url = selectedLinks.get(i).getBrowserUrl())) {
                                if (List2.size() > 0) {
                                    build.append("\r\n");
                                }
                                List2.add(url);
                                build.append(url);
                            }
                            ++i;
                        }
                        string = build.toString();
                        ClipboardHandler.getClipboard().setOldText(string);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                        break;
                    }
                    case 200: {
                        int prio = (Integer)prop.get("prio");
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            selectedLinks.get(i).setPriority(prio);
                            ++i;
                        }
                        DownloadController.getInstance().fireDownloadLinkUpdate(selectedLinks);
                        break;
                    }
                    case 500: {
                        LinkCheck.getLinkChecker().checkLinks(selectedLinks, true);
                        LinkCheck.getLinkChecker().getBroadcaster().addListener((EventListener)DownloadLinksPanel.this);
                        break;
                    }
                    case 1031: {
                        if (DownloadController.getInstance().size() == 1) {
                            ((FilePackage)DownloadController.getInstance().getPackages().get(0)).sort(col);
                            break;
                        }
                        DownloadLinksPanel.this.sort(col);
                        break;
                    }
                    case 103: {
                        if (selectedLinks.size() > 0) {
                            ((DownloadLink)selectedLinks.get(0)).getFilePackage().sort(col);
                            break;
                        }
                        int i = 0;
                        while (i < selectedPackages.size()) {
                            ((FilePackage)selectedPackages.get(i)).sort(col);
                            ++i;
                        }
                        break;
                    }
                    case 400: {
                        Boolean b = (Boolean)prop.get("boolean");
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            selectedLinks.get(i).setEnabled(b.booleanValue());
                            ++i;
                        }
                        JDUtilities.getDownloadController().fireStructureUpdate();
                        break;
                    }
                    case 100: {
                        fp = selectedLinks.get(0).getFilePackage();
                        string = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"gui.linklist.newpackage.message", (String)"Name of the new package"), fp.getName());
                        if (string == null) break;
                        FilePackage nfp = FilePackage.getInstance();
                        nfp.setName(string);
                        nfp.setDownloadDirectory(fp.getDownloadDirectory());
                        nfp.setExtractAfterDownload(fp.isExtractAfterDownload());
                        nfp.setComment(fp.getComment());
                        for (DownloadLink link2 : selectedLinks) {
                            FilePackage fp2 = link2.getFilePackage();
                            link2.addSourcePluginPassword(fp2.getPassword());
                        }
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            selectedLinks.get(i).setFilePackage(nfp);
                            ++i;
                        }
                        if (GUIUtils.getConfig().getBooleanProperty("PARAM_INSERT_NEW_LINKS_AT2", false).booleanValue()) {
                            JDUtilities.getDownloadController().addPackageAt(nfp, 0, 0);
                            break;
                        }
                        JDUtilities.getDownloadController().addPackage(nfp);
                        break;
                    }
                    case 201: {
                        String pw = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"gui.linklist.setpw.message", (String)"Set download password"), null);
                        int i = 0;
                        while (i < selectedLinks.size()) {
                            selectedLinks.get(i).setProperty("pass", (Object)pw);
                            ++i;
                        }
                        break;
                    }
                    case 999: {
                        if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(544, String.valueOf(JDL.L((String)"gui.downloadlist.delete", (String)"Ausgew\u00e4hlte Links wirklich entfernen?")) + " (" + JDL.LF((String)"gui.downloadlist.delete.size_packagev2", (String)"%s links", (Object[])new Object[]{selectedLinks.size()}) + ")"), (int[])new int[]{2, 8})) {
                            int i = 0;
                            while (i < selectedLinks.size()) {
                                selectedLinks.get(i).setEnabled(false);
                                ++i;
                            }
                            i = 0;
                            while (i < selectedLinks.size()) {
                                selectedLinks.get(i).deleteFile(true, false);
                                selectedLinks.get(i).getFilePackage().remove(selectedLinks.get(i));
                                ++i;
                            }
                        }
                        return;
                    }
                    case 9991: {
                        int counter = 0;
                        for (DownloadLink tmp : selectedLinks) {
                            if (!tmp.existsFile()) continue;
                            ++counter;
                        }
                        if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(544, String.valueOf(JDL.L((String)"gui.downloadlist.delete2", (String)"Delete links from downloadlist and disk?")) + " (" + JDL.LF((String)"gui.downloadlist.delete.links", (String)"%s links", (Object[])new Object[]{selectedLinks.size()}) + " / " + " " + JDL.LF((String)"gui.downloadlist.delete.files", (String)"%s files", (Object[])new Object[]{counter}) + ")"), (int[])new int[]{2, 8})) {
                            int i = 0;
                            while (i < selectedLinks.size()) {
                                selectedLinks.get(i).setEnabled(false);
                                ++i;
                            }
                            i = 0;
                            while (i < selectedLinks.size()) {
                                selectedLinks.get(i).deleteFile(true, true);
                                selectedLinks.get(i).getFilePackage().remove(selectedLinks.get(i));
                                ++i;
                            }
                        }
                        return;
                    }
                }
            }
        }.start();
    }

    public static String getPasswordSelectedLinks(ArrayList<DownloadLink> selectedLinks) {
        HashSet<String> List2 = new HashSet<String>();
        StringBuilder build = new StringBuilder("");
        int i = 0;
        while (i < selectedLinks.size()) {
            String pw = selectedLinks.get(i).getFilePackage().getPassword();
            if (!List2.contains(pw)) {
                if (List2.size() > 0) {
                    build.append("\r\n");
                }
                List2.add(pw);
                build.append(pw);
            }
            if (selectedLinks.get(i).getStringProperty("pass", null) != null && !List2.contains(pw = selectedLinks.get(i).getStringProperty("pass", null))) {
                if (List2.size() > 0) {
                    build.append("\r\n");
                }
                List2.add(pw);
                build.append(pw);
            }
            ++i;
        }
        return build.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(final int col) {
        ArrayList packages;
        this.lastSort = !this.lastSort;
        ArrayList arrayList = packages = JDUtilities.getDownloadController().getPackages();
        synchronized (arrayList) {
            Collections.sort(packages, new Comparator<FilePackage>(){

                @Override
                public int compare(FilePackage a, FilePackage b) {
                    FilePackage aa = a;
                    FilePackage bb = b;
                    if (DownloadLinksPanel.this.lastSort) {
                        aa = b;
                        bb = a;
                    }
                    switch (col) {
                        case 0: {
                            return aa.getName().compareToIgnoreCase(bb.getName());
                        }
                        case 1: {
                            return aa.getHoster().compareToIgnoreCase(bb.getHoster());
                        }
                        case 2: {
                            return aa.getRemainingLinks() > bb.getRemainingLinks() ? 1 : -1;
                        }
                        case 3: {
                            return aa.getPercent() > bb.getPercent() ? 1 : -1;
                        }
                    }
                    return -1;
                }
            });
        }
        JDUtilities.getDownloadController().fireStructureUpdate();
    }

    public void onDownloadControllerEvent(DownloadControllerEvent event) {
        switch (event.getID()) {
            case 3: {
                if (this.filePackageInfo.getPackage() == null || this.filePackageInfo.getPackage() != (FilePackage)event.getParameter()) break;
                this.hideFilePackageInfo();
                break;
            }
            case 5: {
                if (this.filePackageInfo.getDownloadLink() == null || this.filePackageInfo.getDownloadLink() != (DownloadLink)event.getParameter()) break;
                this.hideFilePackageInfo();
                break;
            }
            case 1: {
                this.updateTableTask(0, null);
                break;
            }
            case 11: {
                this.updateTableTask(2, event.getParameter());
                break;
            }
            case 12: {
                this.updateTableTask(1, null);
            }
        }
    }

    public void onLinkCheckEvent(LinkCheckEvent event) {
        switch (event.getID()) {
            case 2: 
            case 3: {
                LinkCheck.getLinkChecker().getBroadcaster().removeListener((EventListener)this);
            }
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isFilePackageInfoVisible(Object obj) {
        boolean visible;
        boolean bl = visible = DownloadView.getInstance().getInfoPanel() == this.filePackageInfo;
        if (obj != null) {
            if (obj instanceof DownloadLink && this.filePackageInfo.getDownloadLink() == obj && visible) {
                return true;
            }
            return obj instanceof FilePackage && this.filePackageInfo.getPackage() == obj && visible;
        }
        return visible;
    }
}

