/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.info;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.borders.InsideShadowBorder;
import jd.gui.swing.jdgui.interfaces.DroppedPanel;
import net.miginfocom.swing.MigLayout;

public abstract class InfoPanel
extends DroppedPanel {
    private static final long serialVersionUID = 5465564955866972884L;
    protected EventListenerList listenerList;
    private JLabel iconContainer;
    private Color valueColor;
    private Color titleColor;
    private HashMap<String, JComponent> map;

    public InfoPanel() {
        SwingGui.checkEDT();
        InsideShadowBorder b = new InsideShadowBorder(5, 0, 0, 0);
        b.setBorderInsets(0, 3, 0, 0);
        this.setBorder(b);
        this.listenerList = new EventListenerList();
        this.map = new HashMap();
        this.setLayout((LayoutManager)new MigLayout("ins 5", "[]5[]", "[][]"));
        this.valueColor = this.getBackground().darker().darker().darker().darker().darker();
        this.titleColor = this.getBackground().darker().darker();
        this.iconContainer = new JLabel();
        this.add((Component)this.iconContainer, "spany 2,cell 0 0,gapleft 1");
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void broadcastEvent(ActionEvent e) {
        ActionListener[] actionListenerArray = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(e);
            ++n2;
        }
    }

    protected void updateInfo(String key, Object value) {
        SwingGui.checkEDT();
        JComponent c = this.map.get(key);
        if (c != null && c instanceof JLabel) {
            ((JLabel)c).setText(value.toString());
        }
    }

    protected void addInfoEntry(String title, String value, int x, int y) {
        SwingGui.checkEDT();
        JLabel myValue = new JLabel(value);
        myValue.setForeground(this.valueColor);
        this.addComponent(title, myValue, x, y);
    }

    protected void addComponent(JComponent myComponent, int x, int y) {
        SwingGui.checkEDT();
        x *= 2;
        myComponent.setForeground(this.valueColor);
        this.add((Component)myComponent, "gapleft 20,cell " + ++x + " " + y + ",spanx 2");
        this.map.put(myComponent.getName(), myComponent);
    }

    protected void addComponent(String title, JComponent myComponent, int x, int y) {
        SwingGui.checkEDT();
        x *= 2;
        JLabel myTitle = new JLabel(title != null && title.length() > 0 ? String.valueOf(title) + ":" : "");
        myTitle.setForeground(this.titleColor);
        myComponent.setForeground(this.valueColor);
        this.add((Component)myTitle, "gapleft 20,alignx right,cell " + ++x + " " + y);
        this.add((Component)myComponent, "cell " + (x + 1) + " " + y);
        this.map.put(title, myComponent);
    }

    protected JComponent getComponent(String key) {
        return this.map.get(key);
    }

    protected void setIcon(ImageIcon ii) {
        this.iconContainer.setIcon(ii);
    }

    public void onHide() {
    }

    public void onShow() {
    }
}

