/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.info;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.views.info.InfoPanel;
import jd.nutils.Formatter;
import jd.plugins.LinkGrabberFilePackage;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;

public class LinkGrabberInfoPanel
extends InfoPanel {
    private static final long serialVersionUID = 2276105693934789404L;
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.";
    private LinkGrabberController lgi;
    protected long links;
    protected long tot;
    protected ArrayList<LinkGrabberFilePackage> fps = new ArrayList();

    public LinkGrabberInfoPanel() {
        this.setIcon(JDTheme.II((String)"gui.images.taskpanes.linkgrabber", (int)32, (int)32));
        this.addInfoEntry(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.packages", (String)"Package(s)"), "0", 0, 0);
        this.addInfoEntry(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.links", (String)"Links(s)"), "0", 0, 1);
        this.addInfoEntry(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.filteredlinks", (String)" filtered Links(s)"), "0", 1, 1);
        this.addInfoEntry(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.size", (String)"Total size"), "0", 1, 0);
        this.addCheckboxes();
        this.lgi = LinkGrabberController.getInstance();
        Thread updateTimer = new Thread(){

            public void run() {
                this.setName("LinkGrabberView: infoupdate");
                while (true) {
                    LinkGrabberInfoPanel.this.update();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        };
        updateTimer.start();
    }

    private void addCheckboxes() {
        final JCheckBox topOrBottom = new JCheckBox(JDL.L((String)"gui.taskpanes.download.linkgrabber.config.addattop", (String)"Add at top"));
        topOrBottom.setOpaque(false);
        topOrBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.getConfig().setProperty("PARAM_INSERT_NEW_LINKS_AT2", (Object)topOrBottom.isSelected());
                GUIUtils.getConfig().save();
            }
        });
        if (GUIUtils.getConfig().getBooleanProperty("PARAM_INSERT_NEW_LINKS_AT2", false).booleanValue()) {
            topOrBottom.setSelected(true);
        }
        topOrBottom.setToolTipText(JDL.L((String)"gui.tooltips.linkgrabber.topOrBottom", (String)"if selected, new links will be added at top of your downloadlist"));
        topOrBottom.setIconTextGap(3);
        final JCheckBox startAfterAdding = new JCheckBox(JDL.L((String)"gui.taskpanes.download.linkgrabber.config.startofter", (String)"Start after adding"));
        startAfterAdding.setOpaque(false);
        startAfterAdding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.getConfig().setProperty("PARAM_START_AFTER_ADDING_LINKS", (Object)startAfterAdding.isSelected());
                GUIUtils.getConfig().save();
            }
        });
        if (GUIUtils.getConfig().getBooleanProperty("PARAM_START_AFTER_ADDING_LINKS", true).booleanValue()) {
            startAfterAdding.setSelected(true);
        }
        startAfterAdding.setToolTipText(JDL.L((String)"gui.tooltips.linkgrabber.startlinksafteradd", (String)"Is selected, download starts after adding new links"));
        startAfterAdding.setIconTextGap(3);
        this.addComponent(topOrBottom, 2, 0);
        this.addComponent(startAfterAdding, 2, 1);
    }

    private void update() {
        if (!this.isShown()) {
            return;
        }
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                LinkGrabberInfoPanel.this.tot = 0L;
                LinkGrabberInfoPanel.this.links = 0L;
                LinkGrabberInfoPanel.this.fps.addAll(LinkGrabberInfoPanel.this.lgi.getPackages());
                for (LinkGrabberFilePackage fp : LinkGrabberInfoPanel.this.fps) {
                    LinkGrabberInfoPanel.this.tot += fp.getDownloadSize(false);
                    LinkGrabberInfoPanel.this.links += (long)fp.getDownloadLinks().size();
                }
                LinkGrabberInfoPanel.this.updateInfo(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.packages", (String)"Package(s)"), LinkGrabberInfoPanel.this.fps.size());
                LinkGrabberInfoPanel.this.updateInfo(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.links", (String)"Links(s)"), LinkGrabberInfoPanel.this.links);
                LinkGrabberInfoPanel.this.updateInfo(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.filteredlinks", (String)"filtered Links(s)"), LinkGrabberInfoPanel.this.lgi.getFilterPackage().size());
                LinkGrabberInfoPanel.this.updateInfo(JDL.L((String)"jd.gui.swing.jdgui.views.info.LinkGrabberInfoPanel.size", (String)"Total size"), Formatter.formatReadable((long)LinkGrabberInfoPanel.this.tot));
                LinkGrabberInfoPanel.this.fps.clear();
                return null;
            }
        }.start();
    }

    public void onHide() {
    }

    public void onShow() {
    }
}

