/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackage;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class SizeColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private LinkGrabberFilePackage fp;
    private JRendererLabel jlr = new JRendererLabel();

    public SizeColumn(String name, JDTableModel table) {
        super(name, table);
        this.jlr.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof LinkGrabberFilePackage) {
            this.fp = (LinkGrabberFilePackage)value;
            this.jlr.setText(this.fp.getDownloadSize(false) > 0L ? Formatter.formatReadable((long)this.fp.getDownloadSize(false)) : "~");
        } else if (value instanceof DownloadLink) {
            this.dLink = (DownloadLink)value;
            this.jlr.setText(this.dLink.getDownloadSize() > 0L ? Formatter.formatReadable((long)this.dLink.getDownloadSize()) : "~");
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = LinkGrabberController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = LinkGrabberController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<LinkGrabberFilePackage>(){

                        @Override
                        public int compare(LinkGrabberFilePackage a, LinkGrabberFilePackage b) {
                            LinkGrabberFilePackage aa = a;
                            LinkGrabberFilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            if (aa.getDownloadSize(false) == bb.getDownloadSize(false)) {
                                return 0;
                            }
                            return aa.getDownloadSize(false) < bb.getDownloadSize(false) ? -1 : 1;
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (LinkGrabberFilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinks(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = a;
                                if (sortingToggle) {
                                    aa = a;
                                    bb = b;
                                }
                                if (aa.getDownloadSize() == bb.getDownloadSize()) {
                                    return 0;
                                }
                                return aa.getDownloadSize() < bb.getDownloadSize() ? -1 : 1;
                            }
                        });
                    }
                }
            }
        }
        LinkGrabberController.getInstance().throwRefresh();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        return true;
    }
}

