/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.StatusLabel;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class StatusColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private LinkGrabberFilePackage fp;
    private String strOnline;
    private String strOffline;
    private String strUnchecked;
    private String strUncheckable;
    private StringBuilder sb = new StringBuilder();
    private ImageIcon imgOnline;
    private ImageIcon imgFailed;
    private ImageIcon imgPriorityS;
    private ImageIcon imgPriority1;
    private ImageIcon imgPriority2;
    private ImageIcon imgPriority3;
    private ImageIcon imgUncheckable;
    private String strPriorityS;
    private String strPriority1;
    private String strPriority2;
    private String strPriority3;
    private StatusLabel statuspanel;
    private int counter = 0;

    public StatusColumn(String name, JDTableModel table) {
        super(name, table);
        this.strOnline = JDL.L((String)"linkgrabber.onlinestatus.online", (String)"online");
        this.strOffline = JDL.L((String)"linkgrabber.onlinestatus.offline", (String)"offline");
        this.strUnchecked = JDL.L((String)"linkgrabber.onlinestatus.unchecked", (String)"not checked");
        this.strUncheckable = JDL.L((String)"linkgrabber.onlinestatus.uncheckable", (String)"temp. uncheckable");
        this.imgOnline = JDTheme.II((String)"gui.images.ok", (int)16, (int)16);
        this.imgFailed = JDTheme.II((String)"gui.images.bad", (int)16, (int)16);
        this.imgPriorityS = JDTheme.II((String)"gui.images.priority-1", (int)16, (int)16);
        this.imgPriority1 = JDTheme.II((String)"gui.images.priority1", (int)16, (int)16);
        this.imgPriority2 = JDTheme.II((String)"gui.images.priority2", (int)16, (int)16);
        this.imgPriority3 = JDTheme.II((String)"gui.images.priority3", (int)16, (int)16);
        this.imgUncheckable = JDTheme.II((String)"gui.images.help", (int)16, (int)16);
        this.strPriorityS = JDL.L((String)"gui.treetable.tooltip.priority-1", (String)"Low Priority");
        this.strPriority1 = JDL.L((String)"gui.treetable.tooltip.priority1", (String)"High Priority");
        this.strPriority2 = JDL.L((String)"gui.treetable.tooltip.priority2", (String)"Higher Priority");
        this.strPriority3 = JDL.L((String)"gui.treetable.tooltip.priority3", (String)"Highest Priority");
        this.statuspanel = new StatusLabel();
        this.statuspanel.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.counter = 0;
        if (value instanceof LinkGrabberFilePackage) {
            this.fp = (LinkGrabberFilePackage)value;
            int failedCount = this.fp.countFailedLinks(false);
            int size = this.fp.getDownloadLinks().size();
            if (failedCount > 0) {
                this.statuspanel.setText(JDL.LF((String)"gui.linkgrabber.packageofflinepercent", (String)"%s offline", (Object[])new Object[]{JDUtilities.getPercent((long)failedCount, (long)size)}));
            } else {
                this.statuspanel.setText("");
            }
            if (this.fp.hasCustomIcon()) {
                this.statuspanel.setIcon(-1, this.fp.getCustomIcon(), this.fp.getCustomIconText());
            }
            this.statuspanel.clearIcons(this.counter);
        } else if (value instanceof DownloadLink) {
            this.dLink = (DownloadLink)value;
            this.clearSB();
            if (this.dLink.getLinkStatus().getErrorMessage() != null && this.dLink.getLinkStatus().getErrorMessage().trim().length() > 0) {
                this.sb.append('>').append(this.dLink.getLinkStatus().getErrorMessage());
            } else if (this.dLink.getLinkStatus().getStatusString() != null && this.dLink.getLinkStatus().getStatusString().trim().length() > 0) {
                this.sb.append('>').append(this.dLink.getLinkStatus().getStatusString());
            }
            this.statuspanel.setText(this.sb.toString());
            if (!this.dLink.isAvailabilityStatusChecked()) {
                this.statuspanel.setText(String.valueOf(this.strUnchecked) + this.sb.toString());
            } else {
                switch (this.dLink.getAvailableStatus()) {
                    case FALSE: {
                        this.statuspanel.setText(String.valueOf(this.strOffline) + this.sb.toString());
                        this.statuspanel.setIcon(-1, this.imgFailed, this.strOffline);
                        break;
                    }
                    case TRUE: {
                        this.statuspanel.setText(String.valueOf(this.strOnline) + this.sb.toString());
                        this.statuspanel.setIcon(-1, this.imgOnline, this.strOnline);
                        break;
                    }
                    case UNCHECKABLE: {
                        this.statuspanel.setText(String.valueOf(this.strUncheckable) + this.sb.toString());
                        this.statuspanel.setIcon(-1, this.imgUncheckable, this.strUncheckable);
                        break;
                    }
                    case UNCHECKED: {
                        this.statuspanel.setText(String.valueOf(this.strUnchecked) + this.sb.toString());
                    }
                }
            }
            if (this.dLink.getPriority() != 0) {
                switch (this.dLink.getPriority()) {
                    case -1: {
                        this.statuspanel.setIcon(this.counter, this.imgPriorityS, this.strPriorityS);
                        ++this.counter;
                        break;
                    }
                    case 1: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority1, this.strPriority1);
                        ++this.counter;
                        break;
                    }
                    case 2: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority2, this.strPriority2);
                        ++this.counter;
                        break;
                    }
                    case 3: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority3, this.strPriority3);
                        ++this.counter;
                    }
                }
            }
            if (this.dLink.hasCustomIcon()) {
                this.statuspanel.setIcon(this.counter, this.dLink.getCustomIcon(), this.dLink.getCustomIconText());
                ++this.counter;
            }
            this.statuspanel.clearIcons(this.counter);
        }
        return this.statuspanel;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    private void clearSB() {
        this.sb.delete(0, this.sb.capacity());
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = LinkGrabberController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = LinkGrabberController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<LinkGrabberFilePackage>(){

                        @Override
                        public int compare(LinkGrabberFilePackage a, LinkGrabberFilePackage b) {
                            LinkGrabberFilePackage aa = a;
                            LinkGrabberFilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            if (aa.countFailedLinks(false) == bb.countFailedLinks(false)) {
                                return 0;
                            }
                            return aa.countFailedLinks(false) < bb.countFailedLinks(false) ? -1 : 1;
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (LinkGrabberFilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinks(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = b;
                                if (sortingToggle) {
                                    aa = b;
                                    bb = a;
                                }
                                if (aa.isAvailabilityStatusChecked() && aa.isAvailable() && bb.isAvailabilityStatusChecked() && bb.isAvailable()) {
                                    return 0;
                                }
                                if (aa.isAvailabilityStatusChecked() && aa.isAvailable()) {
                                    return 1;
                                }
                                return -1;
                            }
                        });
                    }
                }
            }
        }
        LinkGrabberController.getInstance().throwRefresh();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        return true;
    }
}

