/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.components.ComboBrowseFile;
import jd.gui.swing.components.JDCollapser;
import jd.gui.swing.components.JDTextField;
import jd.gui.swing.jdgui.views.LinkgrabberView;
import jd.plugins.LinkGrabberFilePackage;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class LinkGrabberFilePackageInfo
extends JDCollapser
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5410296068527460629L;
    private ComboBrowseFile brwSaveTo;
    private JDTextField txtComment;
    private JDTextField txtName;
    private JDTextField txtPassword;
    private JCheckBox chbExtract;
    private JCheckBox chbUseSubdirectory;
    private LinkGrabberFilePackage fp = null;
    private JDTextField txtPassword2;

    public LinkGrabberFilePackageInfo() {
        this.buildGui();
        this.fp = null;
        this.menutitle.setText(JDL.L((String)"gui.linkgrabber.packagetab.title", (String)"File package"));
    }

    public void setPackage(LinkGrabberFilePackage fp) {
        if (this.fp != null && this.fp == fp) {
            this.update();
            return;
        }
        this.fp = fp;
        if (this.fp != null) {
            this.update();
        }
    }

    public void update() {
        if (this.fp == null) {
            return;
        }
        this.txtName.setText(this.fp.getName());
        this.txtComment.setText(this.fp.getComment());
        this.txtPassword.setText(this.fp.getPassword());
        this.txtPassword2.setText(this.fp.getPasswordAuto().toString());
        this.brwSaveTo.setText(this.fp.getDownloadDirectory());
        this.chbExtract.setSelected(this.fp.isExtractAfterDownload());
        this.chbUseSubdirectory.setSelected(this.fp.useSubDir());
        this.revalidate();
    }

    public LinkGrabberFilePackage getPackage() {
        return this.fp;
    }

    private void buildGui() {
        this.txtName = new JDTextField(true);
        this.txtName.addActionListener(this);
        this.txtName.addFocusListener(this);
        this.brwSaveTo = new ComboBrowseFile("DownloadSaveTo");
        this.brwSaveTo.setEditable(true);
        this.brwSaveTo.setFileSelectionMode(1);
        this.brwSaveTo.setText(JDUtilities.getDefaultDownloadDirectory());
        this.brwSaveTo.addActionListener(this);
        this.txtPassword = new JDTextField(true);
        this.txtPassword.addActionListener(this);
        this.txtPassword.addFocusListener(this);
        this.txtPassword2 = new JDTextField(true);
        this.txtPassword2.setEditable(false);
        this.txtComment = new JDTextField(true);
        this.txtComment.addActionListener(this);
        this.txtComment.addFocusListener(this);
        this.chbExtract = new JCheckBox(JDL.L((String)"gui.linkgrabber.packagetab.chb.extractAfterdownload", (String)"Extract"));
        this.chbExtract.setSelected(true);
        this.chbExtract.setHorizontalTextPosition(2);
        this.chbExtract.addActionListener(this);
        this.chbUseSubdirectory = new JCheckBox(JDL.L((String)"gui.linkgrabber.packagetab.chb.useSubdirectory", (String)"Use Subdirectory"));
        this.chbUseSubdirectory.setSelected(JDUtilities.getConfiguration().getBooleanProperty("USE_PACKETNAME_AS_SUBFOLDER", false));
        this.chbUseSubdirectory.setHorizontalTextPosition(2);
        this.chbUseSubdirectory.addActionListener(this);
        this.content.setLayout((LayoutManager)new MigLayout("ins 10, wrap 3", "[]10[grow,fill][]", "[]5[]5[]5[]"));
        this.content.add(new JLabel(JDL.L((String)"gui.linkgrabber.packagetab.lbl.name", (String)"Paketname")));
        this.content.add((Component)this.txtName, "span 2");
        this.content.add(new JLabel(JDL.L((String)"gui.linkgrabber.packagetab.lbl.saveto", (String)"Speichern unter")));
        this.content.add((Component)this.brwSaveTo.getInput(), "gapright 10, growx");
        this.content.add((Component)this.brwSaveTo.getButton(), "pushx,growx");
        this.content.add((Component)new JLabel(JDL.L((String)"gui.linkgrabber.packagetab.lbl.password", (String)"Archivpasswort")), "newline");
        this.content.add((Component)this.txtPassword, " gapright 10, growx");
        this.content.add((Component)this.chbExtract, "alignx right");
        this.content.add((Component)new JLabel(JDL.L((String)"gui.linkgrabber.packagetab.lbl.password2", (String)"Archive Password(auto)")), "newline");
        this.content.add((Component)this.txtPassword2, " gapright 10, growx");
        this.content.add((Component)this.chbUseSubdirectory, "alignx right");
        this.content.add(new JLabel(JDL.L((String)"gui.linkgrabber.packagetab.lbl.comment", (String)"Kommentar")));
        this.content.add((Component)this.txtComment, "gapright 10, growx");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fp == null) {
            return;
        }
        if (e.getSource() == this.txtName) {
            this.fp.setName(this.txtName.getText());
        }
        if (e.getSource() == this.brwSaveTo) {
            this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        }
        if (e.getSource() == this.txtComment) {
            this.fp.setComment(this.txtComment.getText());
        }
        if (e.getSource() == this.txtPassword) {
            this.fp.setPassword(this.txtPassword.getText());
        }
        if (e.getSource() == this.chbExtract) {
            this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
        }
        if (e.getSource() == this.chbUseSubdirectory) {
            this.fp.setUseSubDir(this.chbUseSubdirectory.isSelected());
        }
        LinkGrabberController.getInstance().throwRefresh();
    }

    public void onShow() {
        this.update();
    }

    public void onHideSave() {
        if (this.fp == null) {
            return;
        }
        this.fp.setName(this.txtName.getText());
        this.fp.setComment(this.txtComment.getText());
        this.fp.setPassword(this.txtPassword.getText());
        this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
        this.fp.setUseSubDir(this.chbUseSubdirectory.isSelected());
    }

    public void onHide() {
        if (this.fp == null) {
            return;
        }
        this.onHideSave();
        this.fp = null;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.fp == null) {
            return;
        }
        if (e.getSource() == this.txtName) {
            this.fp.setName(this.txtName.getText());
        }
        if (e.getSource() == this.brwSaveTo) {
            this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        }
        if (e.getSource() == this.txtComment) {
            this.fp.setComment(this.txtComment.getText());
        }
        if (e.getSource() == this.txtPassword) {
            this.fp.setPassword(this.txtPassword.getText());
        }
        if (e.getSource() == this.chbExtract) {
            this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
        }
        if (e.getSource() == this.chbUseSubdirectory) {
            this.fp.setUseSubDir(this.chbUseSubdirectory.isSelected());
        }
        LinkGrabberController.getInstance().throwRefresh();
    }

    public void onClosed() {
        LinkgrabberView.getInstance().setInfoPanel(null);
    }
}

