/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.logview;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import jd.controlling.JDLogHandler;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.jdgui.views.ClosableView;
import jd.gui.swing.jdgui.views.info.LogInfoPanel;
import jd.gui.swing.jdgui.views.logview.LogPane;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class LogView
extends ClosableView
implements ControlListener {
    private static final long serialVersionUID = -4440872942373187410L;
    private static final String IDENT_PREFIX = "jd.gui.swing.jdgui.views.logview.";
    private static LogView INSTANCE = null;
    private LogInfoPanel lip;

    public static LogView getLogView() {
        if (INSTANCE == null) {
            INSTANCE = new LogView();
        }
        return INSTANCE;
    }

    private LogView() {
        LogPane lp = new LogPane();
        this.setContent(lp);
        this.lip = new LogInfoPanel();
        this.setDefaultInfoPanel(this.lip);
        this.lip.addActionListener(lp);
        this.init();
    }

    public Icon getIcon() {
        return JDTheme.II((String)"gui.images.taskpanes.log", (int)16, (int)16);
    }

    public String getTitle() {
        return JDL.L((String)"jd.gui.swing.jdgui.views.logview.tab.title", (String)"Log");
    }

    public String getTooltip() {
        return JDL.L((String)"jd.gui.swing.jdgui.views.logview.tab.tooltip", (String)"See or Upload the Log");
    }

    protected void onHide() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    protected void onShow() {
        JDUtilities.getController().addControlListener((ControlListener)this);
        int severe = 0;
        int warning = 0;
        int exceptions = 0;
        int http = 0;
        ArrayList buff = JDLogHandler.getHandler().getBuffer();
        for (LogRecord r : buff) {
            if (r.getMessage() != null && r.getMessage().contains("exception")) {
                ++exceptions;
                continue;
            }
            if (r.getLevel() == Level.SEVERE) {
                ++severe;
                continue;
            }
            if (r.getLevel() == Level.WARNING) {
                ++warning;
                continue;
            }
            if (r.getMessage() == null || !r.getMessage().contains("--Request--")) continue;
            ++http;
        }
        this.lip.setSevereCount(severe);
        this.lip.setWarningCount(warning);
        this.lip.setExceptionCount(exceptions);
        this.lip.setHttpCount(http);
        this.lip.update();
    }

    public void controlEvent(ControlEvent event) {
        if (event.getID() == 29) {
            LogRecord r = (LogRecord)event.getParameter();
            if (r.getMessage() != null && r.getMessage().contains("exception")) {
                this.lip.setExceptionCount(this.lip.getExceptionCount() + 1);
                this.lip.update();
            } else if (r.getLevel() == Level.SEVERE) {
                this.lip.setSevereCount(this.lip.getSevereCount() + 1);
                this.lip.update();
            } else if (r.getLevel() == Level.WARNING) {
                this.lip.setWarningCount(this.lip.getWarningCount() + 1);
                this.lip.update();
            } else if (r.getMessage() != null && r.getMessage().contains("--Request--")) {
                this.lip.setHttpCount(this.lip.getHttpCount() + 1);
                this.lip.update();
            }
        }
    }
}

