/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.sidebars.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.gui.swing.jdgui.settings.ConfigPanel;
import jd.utils.locale.JDL;

public class AddonConfig
extends ConfigPanel {
    private static final long serialVersionUID = 5561326475681668634L;
    private static HashMap<String, AddonConfig> MAP;
    private ConfigContainer container;
    private String name;

    private AddonConfig(ConfigContainer container, String name) {
        this.container = container;
        this.name = name;
        this.initPanel();
        this.load();
    }

    public String getBreadcrum() {
        return String.valueOf(JDL.L((String)(String.valueOf(this.getClass().getName()) + ".breadcrum"), (String)this.getClass().getSimpleName())) + " - " + this.name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void initPanel() {
        this.panel = new ConfigPanel(this.container);
        ArrayList<ConfigEntry> cont = new ArrayList<ConfigEntry>();
        for (ConfigEntry cfgEntry : this.container.getEntries()) {
            if (cfgEntry.getType() != 13) continue;
            cont.add(cfgEntry);
        }
        final JTabbedPane tabbed = new JTabbedPane();
        tabbed.addChangeListener(new ChangeListener(){
            private ConfigPanel latestSelection;

            public void stateChanged(ChangeEvent e) {
                try {
                    ConfigPanel comp = (ConfigPanel)tabbed.getSelectedComponent();
                    if (comp == this.latestSelection) {
                        return;
                    }
                    if (this.latestSelection != null) {
                        this.latestSelection.setHidden();
                    }
                    this.latestSelection = comp;
                    if (comp != null) {
                        comp.setShown();
                    }
                    AddonConfig.this.revalidate();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        tabbed.setOpaque(false);
        tabbed.add(this.getBreadcrum(), this.panel);
        for (ConfigEntry c : cont) {
            ConfigPanel p = new ConfigPanel(c.getContainer());
            tabbed.add(c.getContainer().getTitle(), p);
            tabbed.setIconAt(tabbed.getTabCount() - 1, c.getContainer().getIcon());
        }
        this.add(tabbed);
    }

    public static synchronized AddonConfig getInstance(ConfigContainer container2, String name2, String ext) {
        AddonConfig p;
        if (MAP == null) {
            MAP = new HashMap();
        }
        if ((p = MAP.get(container2 + "_" + name2 + ext)) != null) {
            return p;
        }
        p = new AddonConfig(container2, name2);
        MAP.put(container2 + "_" + name2 + ext, p);
        return p;
    }
}

