/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.toolbar;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import jd.controlling.JDLogger;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.utils.JDTheme;
import net.miginfocom.swing.MigLayout;

public class ViewToolbar
extends JPanel {
    private static String[] defaultlist = new String[0];
    private static final long serialVersionUID = 7533137014274040205L;
    public static String BUTTON_CONSTRAINTS = "gaptop 2, gapleft 2";
    private static final String GUIINSTANCE = "GUI";
    private static final String PROPERTY_CHANGE_LISTENER = "PROPERTY_CHANGE_LISTENER";
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 3;
    public static final int SOUTH = 4;
    public static final int FIRST_COL = -1;
    public static final int LAST_COL = -2;
    private String[] current = null;
    protected int halign = 2;
    private boolean contentPainted = true;
    private boolean textPainted = true;

    public ViewToolbar() {
        ActionController.initActions();
        this.current = defaultlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(String[] newlist) {
        if (newlist == this.current) {
            return;
        }
        String[] stringArray = this.current;
        synchronized (this.current) {
            this.current = newlist == null || newlist.length == 0 ? defaultlist : newlist;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.updateToolbar();
            return;
        }
    }

    public String[] getList() {
        return this.current;
    }

    private String getColConstraints(String[] list) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColConstraint(-1, null));
        int i = 0;
        while (i < list.length) {
            sb.append(this.getColConstraint(i, this.current[i]));
            ++i;
        }
        sb.append(this.getColConstraint(-2, null));
        return sb.toString();
    }

    public String getColConstraint(int col, String string) {
        switch (col) {
            case -1: {
                return this.halign == 1 ? "[grow]5" : "";
            }
            case -2: {
                return this.halign == 1 ? "" : "[grow,fill]";
            }
        }
        return "[]5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initToolbar(String[] list) {
        if (list == null) {
            return;
        }
        String[] stringArray = list;
        synchronized (list) {
            SwingGui.checkEDT();
            this.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", this.getColConstraints(list)));
            int i = -1;
            String[] stringArray2 = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray2[n2];
                ++i;
                ToolBarAction action = ActionController.getToolBarAction(key);
                if (action == null) {
                    JDLogger.warning((Object)("The Action " + key + " is not available"));
                } else {
                    action.init();
                    AbstractButton ab = null;
                    switch (action.getType()) {
                        case NORMAL: {
                            ab = new JButton(action);
                            this.add((Component)ab, this.getButtonConstraint(i, action));
                            break;
                        }
                        case SEPARATOR: {
                            this.add((Component)new JSeparator(1), "height 32,gapleft 10,gapright 10");
                            break;
                        }
                        case TOGGLE: {
                            ab = new JToggleButton(action);
                            this.add((Component)ab, this.getButtonConstraint(i, action));
                        }
                    }
                    if (ab != null) {
                        ab.setContentAreaFilled(this.contentPainted);
                        ab.setFocusPainted(false);
                        if (action.getValue("MnemonicKey") != null) {
                            ab.setToolTipText(String.valueOf(action.getTooltipText()) + " [Alt+" + new String(new byte[]{((Integer)action.getValue("MnemonicKey")).byteValue()}) + "]");
                        } else {
                            ab.setToolTipText(action.getTooltipText());
                        }
                        ab.setIcon(JDTheme.II((String)("" + action.getValue("IMAGE_KEY")), (int)16, (int)16));
                        if (!this.textPainted) {
                            ab.setText("");
                        }
                        ab.setToolTipText(action.getTooltipText());
                        ab.setEnabled(action.isEnabled());
                        ab.setSelected(action.isSelected());
                        this.setDefaults(i, ab);
                        action.putValue(GUIINSTANCE, ab);
                        PropertyChangeListener pcl = new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent evt) {
                                ToolBarAction action = (ToolBarAction)evt.getSource();
                                try {
                                    AbstractButton ab = (AbstractButton)action.getValue(ViewToolbar.GUIINSTANCE);
                                    if (action.getValue("MnemonicKey") != null) {
                                        ab.setToolTipText(String.valueOf(action.getTooltipText()) + " [Alt+" + new String(new byte[]{((Integer)action.getValue("MnemonicKey")).byteValue()}) + "]");
                                    } else {
                                        ab.setToolTipText(action.getTooltipText());
                                    }
                                    ab.setEnabled(action.isEnabled());
                                    ab.setSelected(action.isSelected());
                                }
                                catch (Throwable w) {
                                    JDLogger.exception((Throwable)w);
                                    action.removePropertyChangeListener(this);
                                }
                            }
                        };
                        action.addPropertyChangeListener(pcl);
                        if (action.getValue(PROPERTY_CHANGE_LISTENER) != null) {
                            action.removePropertyChangeListener((PropertyChangeListener)action.getValue(PROPERTY_CHANGE_LISTENER));
                        }
                        action.putValue(PROPERTY_CHANGE_LISTENER, pcl);
                    }
                }
                ++n2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setDefaults(int i, AbstractButton ab) {
    }

    public String getButtonConstraint(int i, ToolBarAction action) {
        if (this.halign == 1) {
            return String.valueOf(BUTTON_CONSTRAINTS) + ", alignx right";
        }
        return BUTTON_CONSTRAINTS;
    }

    protected void updateToolbar() {
        if (this.current == null) {
            return;
        }
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                ViewToolbar.this.setVisible(false);
                ViewToolbar.this.removeAll();
                ViewToolbar.this.initToolbar(ViewToolbar.this.current);
                ViewToolbar.this.setVisible(true);
                ViewToolbar.this.revalidate();
                return null;
            }
        }.waitForEDT();
    }

    public void setHorizontalAlign(int align) {
        this.halign = align;
        this.updateToolbar();
    }

    public void setContentPainted(boolean b) {
        this.contentPainted = b;
        this.updateToolbar();
    }

    public boolean isTextPainted() {
        return this.textPainted;
    }

    public void setTextPainted(boolean textPainted) {
        this.textPainted = textPainted;
        this.updateToolbar();
    }

    public boolean isContentPainted() {
        return this.contentPainted;
    }
}

