/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffMatchPatch {
    public float diffTimeout = 1.0f;
    public short diffEditCost = (short)4;
    public short diffDualThreshold = (short)32;
    public float matchBalance = 0.5f;
    public float matchThreshold = 0.5f;
    public int matchMinLength = 100;
    public int matchMaxLength = 1000;
    public short patchMargin = (short)4;
    private int matchMaxBits = 32;
    private Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diffMain(String text1, String text2) {
        return this.diffMain(text1, text2, true);
    }

    public LinkedList<Diff> diffMain(String text1, String text2, boolean checklines) {
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            diffs.add(new Diff(Operation.EQUAL, text1));
            return diffs;
        }
        int commonlength = this.diffCommonPrefix(text1, text2);
        String commonPrefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diffCommonSuffix(text1, text2);
        String commonSuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diffCompute(text1, text2, checklines);
        if (commonPrefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonPrefix));
        }
        if (commonSuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonSuffix));
        }
        this.diffCleanupMerge(diffs);
        return diffs;
    }

    protected LinkedList<Diff> diffCompute(String text1, String text2, boolean checkLines) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        longtext = null;
        shorttext = null;
        String[] hm = this.diffHalfMatch(text1, text2);
        if (hm != null) {
            String text1A = hm[0];
            String text1B = hm[1];
            String text2A = hm[2];
            String text2B = hm[3];
            String midCommon = hm[4];
            LinkedList<Diff> diffsA = this.diffMain(text1A, text2A, checkLines);
            LinkedList<Diff> diffsB = this.diffMain(text1B, text2B, checkLines);
            diffs = diffsA;
            diffs.add(new Diff(Operation.EQUAL, midCommon));
            diffs.addAll(diffsB);
            return diffs;
        }
        if (checkLines && (text1.length() < 100 || text2.length() < 100)) {
            checkLines = false;
        }
        ArrayList lineArray = null;
        if (checkLines) {
            Object[] b = this.diffLinesToChars(text1, text2);
            text1 = (String)b[0];
            text2 = (String)b[1];
            lineArray = (ArrayList)b[2];
        }
        if ((diffs = this.diffMap(text1, text2)) == null) {
            diffs = new LinkedList();
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
        }
        if (checkLines) {
            this.diffCharsToLines(diffs, lineArray);
            this.diffCleanupSemantic(diffs);
            diffs.add(new Diff(Operation.EQUAL, ""));
            int countDelete = 0;
            int count_insert = 0;
            String textDelete = "";
            String text_insert = "";
            ListIterator<Diff> pointer = diffs.listIterator();
            Diff thisDiff = (Diff)pointer.next();
            while (thisDiff != null) {
                switch (thisDiff.operation) {
                    case INSERT: {
                        ++count_insert;
                        text_insert = String.valueOf(text_insert) + thisDiff.text;
                        break;
                    }
                    case DELETE: {
                        ++countDelete;
                        textDelete = String.valueOf(textDelete) + thisDiff.text;
                        break;
                    }
                    case EQUAL: {
                        if (countDelete >= 1 && count_insert >= 1) {
                            pointer.previous();
                            int j = 0;
                            while (j < countDelete + count_insert) {
                                pointer.previous();
                                pointer.remove();
                                ++j;
                            }
                            for (Diff newDiff : this.diffMain(textDelete, text_insert, false)) {
                                pointer.add(newDiff);
                            }
                        }
                        count_insert = 0;
                        countDelete = 0;
                        textDelete = "";
                        text_insert = "";
                    }
                }
                Diff diff = thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            diffs.removeLast();
        }
        return diffs;
    }

    public Object[] diffLinesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diffLinesToCharsMunge(text1, lineArray, lineHash);
        String chars2 = this.diffLinesToCharsMunge(text2, lineArray, lineHash);
        return new Object[]{chars1, chars2, lineArray};
    }

    private String diffLinesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            String line = text.substring(lineStart, lineEnd + 1);
            lineStart = lineEnd + 1;
            if (lineHash.containsKey(line)) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
                continue;
            }
            lineArray.add(line);
            lineHash.put(line, lineArray.size() - 1);
            chars.append(String.valueOf((char)(lineArray.size() - 1)));
        }
        return chars.toString();
    }

    public void diffCharsToLines(LinkedList<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            int y = 0;
            while (y < diff.text.length()) {
                text.append(lineArray.get(diff.text.charAt(y)));
                ++y;
            }
            diff.text = text.toString();
        }
    }

    public LinkedList<Diff> diffMap(String text1, String text2) {
        long ms_end = System.currentTimeMillis() + (long)(this.diffTimeout * 1000.0f);
        int maxD = text1.length() + text2.length() - 1;
        boolean doubleEnd = this.diffDualThreshold * 2 < maxD;
        List<Set<Long>> vMap1 = new ArrayList<Set<Long>>();
        List<Set<Long>> vMap2 = new ArrayList();
        HashMap<Integer, Integer> v1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> v2 = new HashMap<Integer, Integer>();
        v1.put(1, 0);
        v2.put(1, 0);
        Long footstep = 0L;
        HashMap<Long, Integer> footsteps = new HashMap<Long, Integer>();
        boolean done = false;
        boolean front = (text1.length() + text2.length()) % 2 == 1;
        int d = 0;
        while (d < maxD) {
            int y;
            int x;
            if (this.diffTimeout > 0.0f && System.currentTimeMillis() > ms_end) {
                return null;
            }
            vMap1.add(new HashSet());
            int k = -d;
            while (k <= d) {
                x = k == -d || k != d && (Integer)v1.get(k - 1) < (Integer)v1.get(k + 1) ? (Integer)v1.get(k + 1) : (Integer)v1.get(k - 1) + 1;
                y = x - k;
                if (doubleEnd) {
                    footstep = this.diffFootprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) {
                        footsteps.put(footstep, d);
                    }
                }
                while (!done && x < text1.length() && y < text2.length() && text1.charAt(x) == text2.charAt(y)) {
                    ++x;
                    ++y;
                    if (!doubleEnd) continue;
                    footstep = this.diffFootprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (front) continue;
                    footsteps.put(footstep, d);
                }
                v1.put(k, x);
                ((Set)vMap1.get(d)).add(this.diffFootprint(x, y));
                if (x == text1.length() && y == text2.length()) {
                    return this.diffPath1(vMap1, text1, text2);
                }
                if (done) {
                    vMap2 = vMap2.subList(0, (Integer)footsteps.get(footstep) + 1);
                    LinkedList<Diff> a = this.diffPath1(vMap1, text1.substring(0, x), text2.substring(0, y));
                    a.addAll(this.diffPath2(vMap2, text1.substring(x), text2.substring(y)));
                    return a;
                }
                k += 2;
            }
            if (doubleEnd) {
                vMap2.add(new HashSet());
                k = -d;
                while (k <= d) {
                    x = k == -d || k != d && (Integer)v2.get(k - 1) < (Integer)v2.get(k + 1) ? (Integer)v2.get(k + 1) : (Integer)v2.get(k - 1) + 1;
                    y = x - k;
                    footstep = this.diffFootprint(text1.length() - x, text2.length() - y);
                    if (!front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (front) {
                        footsteps.put(footstep, d);
                    }
                    while (!done && x < text1.length() && y < text2.length() && text1.charAt(text1.length() - x - 1) == text2.charAt(text2.length() - y - 1)) {
                        footstep = this.diffFootprint(text1.length() - ++x, text2.length() - ++y);
                        if (!front && footsteps.containsKey(footstep)) {
                            done = true;
                        }
                        if (!front) continue;
                        footsteps.put(footstep, d);
                    }
                    v2.put(k, x);
                    ((Set)vMap2.get(d)).add(this.diffFootprint(x, y));
                    if (done) {
                        vMap1 = vMap1.subList(0, (Integer)footsteps.get(footstep) + 1);
                        LinkedList<Diff> a = this.diffPath1(vMap1, text1.substring(0, text1.length() - x), text2.substring(0, text2.length() - y));
                        a.addAll(this.diffPath2(vMap2, text1.substring(text1.length() - x), text2.substring(text2.length() - y)));
                        return a;
                    }
                    k += 2;
                }
            }
            ++d;
        }
        return null;
    }

    public LinkedList<Diff> diffPath1(List<Set<Long>> vMap, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        int d = vMap.size() - 2;
        while (d >= 0) {
            while (true) {
                if (vMap.get(d).contains(this.diffFootprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        path.getFirst().text = String.valueOf(text1.charAt(x)) + path.getFirst().text;
                    } else {
                        path.addFirst(new Diff(Operation.DELETE, text1.substring(x, x + 1)));
                    }
                    last_op = Operation.DELETE;
                    break;
                }
                if (vMap.get(d).contains(this.diffFootprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        path.getFirst().text = String.valueOf(text2.charAt(y)) + path.getFirst().text;
                    } else {
                        path.addFirst(new Diff(Operation.INSERT, text2.substring(y, y + 1)));
                    }
                    last_op = Operation.INSERT;
                    break;
                }
                assert (text1.charAt(--x) == text2.charAt(--y)) : "No diagonal.  Can't happen. (diffPath1)";
                if (last_op == Operation.EQUAL) {
                    path.getFirst().text = String.valueOf(text1.charAt(x)) + path.getFirst().text;
                } else {
                    path.addFirst(new Diff(Operation.EQUAL, text1.substring(x, x + 1)));
                }
                last_op = Operation.EQUAL;
            }
            --d;
        }
        return path;
    }

    public LinkedList<Diff> diffPath2(List<Set<Long>> vMap, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        int d = vMap.size() - 2;
        while (d >= 0) {
            while (true) {
                if (vMap.get(d).contains(this.diffFootprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        path.getLast().text = String.valueOf(path.getLast().text) + text1.charAt(text1.length() - x - 1);
                    } else {
                        path.addLast(new Diff(Operation.DELETE, text1.substring(text1.length() - x - 1, text1.length() - x)));
                    }
                    last_op = Operation.DELETE;
                    break;
                }
                if (vMap.get(d).contains(this.diffFootprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        path.getLast().text = String.valueOf(path.getLast().text) + text2.charAt(text2.length() - y - 1);
                    } else {
                        path.addLast(new Diff(Operation.INSERT, text2.substring(text2.length() - y - 1, text2.length() - y)));
                    }
                    last_op = Operation.INSERT;
                    break;
                }
                assert (text1.charAt(text1.length() - --x - 1) == text2.charAt(text2.length() - --y - 1)) : "No diagonal.  Can't happen. (diffPath2)";
                if (last_op == Operation.EQUAL) {
                    path.getLast().text = String.valueOf(path.getLast().text) + text1.charAt(text1.length() - x - 1);
                } else {
                    path.addLast(new Diff(Operation.EQUAL, text1.substring(text1.length() - x - 1, text1.length() - x)));
                }
                last_op = Operation.EQUAL;
            }
            --d;
        }
        return path;
    }

    public Long diffFootprint(int x, int y) {
        long result = x;
        result <<= 32;
        return result += (long)y;
    }

    public int diffCommonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        int i = 0;
        while (i < n) {
            if (text1.charAt(i) != text2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return n;
    }

    public int diffCommonSuffix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        int i = 0;
        while (i < n) {
            if (text1.charAt(text1.length() - i - 1) != text2.charAt(text2.length() - i - 1)) {
                return i;
            }
            ++i;
        }
        return n;
    }

    public String[] diffHalfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 10 || shorttext.length() < 1) {
            return null;
        }
        String[] hm1 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diffHalfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        String bestCommon = "";
        String bestLongtextA = "";
        String bestLongtextB = "";
        String bestShorttextA = "";
        String bestShorttextB = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diffCommonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diffCommonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (bestCommon.length() >= suffixLength + prefixLength) continue;
            bestCommon = String.valueOf(shorttext.substring(j - suffixLength, j)) + shorttext.substring(j, j + prefixLength);
            bestLongtextA = longtext.substring(0, i - suffixLength);
            bestLongtextB = longtext.substring(i + prefixLength);
            bestShorttextA = shorttext.substring(0, j - suffixLength);
            bestShorttextB = shorttext.substring(j + prefixLength);
        }
        if (bestCommon.length() >= longtext.length() / 2) {
            return new String[]{bestLongtextA, bestLongtextB, bestShorttextA, bestShorttextB, bestCommon};
        }
        return null;
    }

    public void diffCleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int lengthChanges1 = 0;
        int lengthChanges2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                equalities.push(thisDiff);
                lengthChanges1 = lengthChanges2;
                lengthChanges2 = 0;
                lastequality = thisDiff.text;
            } else if (lastequality != null && lastequality.length() <= lengthChanges1 && lastequality.length() <= (lengthChanges2 += thisDiff.text.length())) {
                while (thisDiff != equalities.lastElement()) {
                    thisDiff = (Diff)pointer.previous();
                }
                pointer.next();
                pointer.set(new Diff(Operation.DELETE, lastequality));
                pointer.add(new Diff(Operation.INSERT, lastequality));
                equalities.pop();
                if (!equalities.empty()) {
                    equalities.pop();
                }
                if (equalities.empty()) {
                    while (pointer.hasPrevious()) {
                        pointer.previous();
                    }
                } else {
                    thisDiff = (Diff)equalities.lastElement();
                    while (thisDiff != pointer.previous()) {
                    }
                }
                lengthChanges1 = 0;
                lengthChanges2 = 0;
                lastequality = null;
                changes = true;
            }
            Diff diff = thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
        this.diffCleanupSemanticLossless(diffs);
    }

    public void diffCleanupSemanticLossless(LinkedList<Diff> diffs) {
        ListIterator pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                String equality1 = prevDiff.text;
                String edit = thisDiff.text;
                String equality2 = nextDiff.text;
                int commonOffset = this.diffCommonSuffix(equality1, edit);
                if (commonOffset != 0) {
                    String commonString = edit.substring(edit.length() - commonOffset);
                    equality1 = equality1.substring(0, equality1.length() - commonOffset);
                    edit = String.valueOf(commonString) + edit.substring(0, edit.length() - commonOffset);
                    equality2 = String.valueOf(commonString) + equality2;
                }
                String bestEquality1 = equality1;
                String bestEdit = edit;
                String bestEquality2 = equality2;
                int bestScore = this.diffCleanupSemanticScore(equality1, edit) + this.diffCleanupSemanticScore(edit, equality2);
                while (edit.length() != 0 && equality2.length() != 0 && edit.charAt(0) == equality2.charAt(0)) {
                    equality1 = String.valueOf(equality1) + edit.charAt(0);
                    edit = String.valueOf(edit.substring(1)) + equality2.charAt(0);
                    equality2 = equality2.substring(1);
                    int score = this.diffCleanupSemanticScore(equality1, edit) + this.diffCleanupSemanticScore(edit, equality2);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1;
                    bestEdit = edit;
                    bestEquality2 = equality2;
                }
                if (!prevDiff.text.equals(bestEquality1)) {
                    if (bestEquality1.length() != 0) {
                        prevDiff.text = bestEquality1;
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.text = bestEdit;
                    if (bestEquality2.length() != 0) {
                        nextDiff.text = bestEquality2;
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private int diffCleanupSemanticScore(String one, String two) {
        if (one.length() == 0 || two.length() == 0) {
            return 5;
        }
        int score = 0;
        if (!Character.isLetterOrDigit(one.charAt(one.length() - 1)) || !Character.isLetterOrDigit(two.charAt(0))) {
            ++score;
            if (Character.isWhitespace(one.charAt(one.length() - 1)) || Character.isWhitespace(two.charAt(0))) {
                ++score;
                if (Character.getType(one.charAt(one.length() - 1)) == 15 || Character.getType(two.charAt(0)) == 15) {
                    ++score;
                    if (this.BLANKLINEEND.matcher(one).find() || this.BLANKLINESTART.matcher(two).find()) {
                        ++score;
                    }
                }
            }
        }
        return score;
    }

    public void diffCleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean pre_ins = false;
        boolean preDel = false;
        boolean post_ins = false;
        boolean postDel = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.length() < this.diffEditCost && (post_ins || postDel)) {
                    equalities.push(thisDiff);
                    pre_ins = post_ins;
                    preDel = postDel;
                    lastequality = thisDiff.text;
                } else {
                    equalities.clear();
                    lastequality = null;
                    safeDiff = thisDiff;
                }
                postDel = false;
                post_ins = false;
            } else {
                if (thisDiff.operation == Operation.DELETE) {
                    postDel = true;
                } else {
                    post_ins = true;
                }
                if (lastequality != null && (pre_ins && preDel && post_ins && postDel || lastequality.length() < this.diffEditCost / 2 && (pre_ins ? 1 : 0) + (preDel ? 1 : 0) + (post_ins ? 1 : 0) + (postDel ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    thisDiff = new Diff(Operation.INSERT, lastequality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastequality = null;
                    if (pre_ins && preDel) {
                        postDel = true;
                        post_ins = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.empty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.empty() ? safeDiff : (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                        postDel = false;
                        post_ins = false;
                    }
                    changes = true;
                }
            }
            Diff diff = thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public void diffCleanupMerge(LinkedList<Diff> diffs) {
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int countDelete = 0;
        int count_insert = 0;
        String textDelete = "";
        String text_insert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++count_insert;
                    text_insert = String.valueOf(text_insert) + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++countDelete;
                    textDelete = String.valueOf(textDelete) + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (countDelete != 0 || count_insert != 0) {
                        pointer.previous();
                        while (countDelete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (count_insert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (countDelete != 0 && count_insert != 0) {
                            int commonlength = this.diffCommonPrefix(text_insert, textDelete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    assert (thisDiff.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    thisDiff.text = String.valueOf(thisDiff.text) + text_insert.substring(0, commonlength);
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, text_insert.substring(0, commonlength)));
                                }
                                text_insert = text_insert.substring(commonlength);
                                textDelete = textDelete.substring(commonlength);
                            }
                            if ((commonlength = this.diffCommonSuffix(text_insert, textDelete)) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.text = String.valueOf(text_insert.substring(text_insert.length() - commonlength)) + thisDiff.text;
                                text_insert = text_insert.substring(0, text_insert.length() - commonlength);
                                textDelete = textDelete.substring(0, textDelete.length() - commonlength);
                                pointer.previous();
                            }
                        }
                        if (textDelete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, textDelete));
                        }
                        if (text_insert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, text_insert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.text = String.valueOf(prevEqual.text) + thisDiff.text;
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    count_insert = 0;
                    countDelete = 0;
                    textDelete = "";
                    text_insert = "";
                    prevEqual = thisDiff;
                }
            }
            Diff diff = thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().text.length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.endsWith(prevDiff.text)) {
                    thisDiff.text = String.valueOf(prevDiff.text) + thisDiff.text.substring(0, thisDiff.text.length() - prevDiff.text.length());
                    nextDiff.text = String.valueOf(prevDiff.text) + nextDiff.text;
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.text.startsWith(nextDiff.text)) {
                    prevDiff.text = String.valueOf(prevDiff.text) + nextDiff.text;
                    thisDiff.text = String.valueOf(thisDiff.text.substring(nextDiff.text.length())) + nextDiff.text;
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public int diffXIndex(LinkedList<Diff> diffs, int loc) {
        int chars1 = 0;
        int chars2 = 0;
        int lastChars1 = 0;
        int lastChars2 = 0;
        Diff lastDiff = null;
        for (Diff aDiff : diffs) {
            if (aDiff.operation != Operation.INSERT) {
                chars1 += aDiff.text.length();
            }
            if (aDiff.operation != Operation.DELETE) {
                chars2 += aDiff.text.length();
            }
            if (chars1 > loc) {
                lastDiff = aDiff;
                break;
            }
            lastChars1 = chars1;
            lastChars2 = chars2;
        }
        if (lastDiff != null && lastDiff.operation == Operation.DELETE) {
            return lastChars2;
        }
        return lastChars2 + (loc - lastChars1);
    }

    public String diffPrettyHtml(LinkedList<Diff> diffs) {
        StringBuilder html = new StringBuilder();
        int i = 0;
        for (Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<BR>");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<INS STYLE=\"background:#E6FFE6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</INS>");
                    break;
                }
                case DELETE: {
                    html.append("<DEL STYLE=\"background:#FFE6E6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</DEL>");
                    break;
                }
                case EQUAL: {
                    html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text).append("</SPAN>");
                }
            }
            if (aDiff.operation == Operation.DELETE) continue;
            i += aDiff.text.length();
        }
        return html.toString();
    }

    public String diffText1(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.INSERT) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public String diffText2(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.DELETE) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public int diffLevenshtein(LinkedList<Diff> diffs) {
        int levenshtein = 0;
        int insertions = 0;
        int deletions = 0;
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    insertions += aDiff.text.length();
                    break;
                }
                case DELETE: {
                    deletions += aDiff.text.length();
                    break;
                }
                case EQUAL: {
                    levenshtein += Math.max(insertions, deletions);
                    insertions = 0;
                    deletions = 0;
                }
            }
        }
        return levenshtein += Math.max(insertions, deletions);
    }

    public String diffToDelta(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    try {
                        text.append("+").append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                }
                case DELETE: {
                    text.append("-").append(aDiff.text.length()).append("\t");
                    break;
                }
                case EQUAL: {
                    text.append("=").append(aDiff.text.length()).append("\t");
                }
            }
        }
        String delta = text.toString();
        if (delta.length() != 0) {
            delta = delta.substring(0, delta.length() - 1);
            delta = DiffMatchPatch.unescapeForEncodeUriCompatability(delta);
        }
        return delta;
    }

    public LinkedList<Diff> diffFromDelta(String text1, String delta) throws IllegalArgumentException {
        String[] tokens;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        int pointer = 0;
        String[] stringArray = tokens = delta.split("\t");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() != 0) {
                String param = token.substring(1);
                switch (token.charAt(0)) {
                    case '+': {
                        param = param.replace("+", "%2B");
                        try {
                            param = URLDecoder.decode(param, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new Error("This system does not support UTF-8.", e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Illegal escape in diffFromDelta: " + param, e);
                        }
                        diffs.add(new Diff(Operation.INSERT, param));
                        break;
                    }
                    case '-': 
                    case '=': {
                        String text;
                        int n3;
                        try {
                            n3 = Integer.parseInt(param);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid number in diffFromDelta: " + param, e);
                        }
                        if (n3 < 0) {
                            throw new IllegalArgumentException("Negative number in diffFromDelta: " + param);
                        }
                        try {
                            text = text1.substring(pointer, pointer += n3);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("Delta length (" + pointer + ") larger than source text length (" + text1.length() + ").", e);
                        }
                        if (token.charAt(0) == '=') {
                            diffs.add(new Diff(Operation.EQUAL, text));
                            break;
                        }
                        diffs.add(new Diff(Operation.DELETE, text));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid diff operation in diffFromDelta: " + token.charAt(0));
                    }
                }
            }
            ++n2;
        }
        if (pointer != text1.length()) {
            throw new IllegalArgumentException("Delta length (" + pointer + ") smaller than source text length (" + text1.length() + ").");
        }
        return diffs;
    }

    public int matchMain(String text, String pattern, int loc) {
        loc = Math.max(0, Math.min(loc, text.length() - pattern.length()));
        if (text.equals(pattern)) {
            return 0;
        }
        if (text.length() == 0) {
            return -1;
        }
        if (text.substring(loc, loc + pattern.length()).equals(pattern)) {
            return loc;
        }
        return this.matchBitap(text, pattern, loc);
    }

    public int matchBitap(String text, String pattern, int loc) {
        assert (this.matchMaxBits == 0 || pattern.length() <= this.matchMaxBits) : "Pattern too long for this application.";
        Map<Character, Integer> s = this.matchAlphabet(pattern);
        int scoreTextLength = text.length();
        scoreTextLength = Math.max(scoreTextLength, this.matchMinLength);
        scoreTextLength = Math.min(scoreTextLength, this.matchMaxLength);
        double scoreThreshold = this.matchThreshold;
        int bestLoc = text.indexOf(pattern, loc);
        if (bestLoc != -1) {
            scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, scoreTextLength, pattern), scoreThreshold);
        }
        if ((bestLoc = text.lastIndexOf(pattern, loc + pattern.length())) != -1) {
            scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, scoreTextLength, pattern), scoreThreshold);
        }
        int matchmask = 1 << pattern.length() - 1;
        bestLoc = -1;
        int binMax = Math.max(loc + loc, text.length());
        int[] last_rd = new int[]{};
        int d = 0;
        while (d < pattern.length()) {
            int[] rd = new int[text.length()];
            int binMin = loc;
            int binMid = binMax;
            while (binMin < binMid) {
                if (this.matchBitapScore(d, binMid, loc, scoreTextLength, pattern) < scoreThreshold) {
                    binMin = binMid;
                } else {
                    binMax = binMid;
                }
                binMid = (binMax - binMin) / 2 + binMin;
            }
            binMax = binMid;
            int start = Math.max(0, loc - (binMid - loc) - 1);
            int finish = Math.min(text.length() - 1, pattern.length() + binMid);
            rd[finish] = text.charAt(finish) == pattern.charAt(pattern.length() - 1) ? (1 << d + 1) - 1 : (1 << d) - 1;
            int j = finish - 1;
            while (j >= start) {
                double score;
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & (s.containsKey(Character.valueOf(text.charAt(j))) ? s.get(Character.valueOf(text.charAt(j))) : 0) : (rd[j + 1] << 1 | 1) & (s.containsKey(Character.valueOf(text.charAt(j))) ? s.get(Character.valueOf(text.charAt(j))) : 0) | (last_rd[j + 1] << 1 | 1) | (last_rd[j] << 1 | 1) | last_rd[j + 1];
                if ((rd[j] & matchmask) != 0 && (score = this.matchBitapScore(d, j, loc, scoreTextLength, pattern)) <= scoreThreshold) {
                    scoreThreshold = score;
                    bestLoc = j;
                    if (j <= loc) break;
                    start = Math.max(0, loc - (j - loc));
                }
                --j;
            }
            if (this.matchBitapScore(d + 1, loc, loc, scoreTextLength, pattern) > scoreThreshold) break;
            last_rd = rd;
            ++d;
        }
        return bestLoc;
    }

    private double matchBitapScore(int e, int x, int loc, int scoreTextLength, String pattern) {
        int d = Math.abs(loc - x);
        return (double)((float)e / (float)pattern.length() / this.matchBalance) + (double)((float)d / (float)scoreTextLength) / (1.0 - (double)this.matchBalance);
    }

    public Map<Character, Integer> matchAlphabet(String pattern) {
        char[] charPattern;
        HashMap<Character, Integer> s = new HashMap<Character, Integer>();
        char[] cArray = charPattern = pattern.toCharArray();
        int n = charPattern.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            s.put(Character.valueOf(c), 0);
            ++n2;
        }
        int i = 0;
        char[] cArray2 = charPattern;
        int n3 = charPattern.length;
        n = 0;
        while (n < n3) {
            char c = cArray2[n];
            s.put(Character.valueOf(c), (Integer)s.get(Character.valueOf(c)) | 1 << pattern.length() - i - 1);
            ++i;
            ++n;
        }
        return s;
    }

    public void patchAddContext(Patch patch, String text) {
        String suffix;
        String pattern = text.substring(patch.start2, patch.start2 + patch.length1);
        int padding = 0;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < this.matchMaxBits - this.patchMargin - this.patchMargin) {
            pattern = text.substring(Math.max(0, patch.start2 - (padding += this.patchMargin)), Math.min(text.length(), patch.start2 + patch.length1 + padding));
        }
        String prefix = text.substring(Math.max(0, patch.start2 - (padding += this.patchMargin)), patch.start2);
        if (prefix.length() != 0) {
            patch.diffs.addFirst(new Diff(Operation.EQUAL, prefix));
        }
        if ((suffix = text.substring(patch.start2 + patch.length1, Math.min(text.length(), patch.start2 + patch.length1 + padding))).length() != 0) {
            patch.diffs.addLast(new Diff(Operation.EQUAL, suffix));
        }
        patch.start1 -= prefix.length();
        patch.start2 -= prefix.length();
        patch.length1 += prefix.length() + suffix.length();
        patch.length2 += prefix.length() + suffix.length();
    }

    public LinkedList<Patch> patchMake(String text1, String text2) {
        LinkedList<Diff> diffs = this.diffMain(text1, text2, true);
        if (diffs.size() > 2) {
            this.diffCleanupSemantic(diffs);
            this.diffCleanupEfficiency(diffs);
        }
        return this.patchMake(text1, diffs);
    }

    public LinkedList<Patch> patchMake(LinkedList<Diff> diffs) {
        String text1 = this.diffText1(diffs);
        return this.patchMake(text1, diffs);
    }

    public LinkedList<Patch> patchMake(String text1, LinkedList<Diff> diffs) {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (diffs.isEmpty()) {
            return patches;
        }
        Patch patch = new Patch();
        int charCount1 = 0;
        int charCount2 = 0;
        String prepatchText = text1;
        String postpatchText = text1;
        for (Diff aDiff : diffs) {
            if (patch.diffs.isEmpty() && aDiff.operation != Operation.EQUAL) {
                patch.start1 = charCount1;
                patch.start2 = charCount2;
            }
            switch (aDiff.operation) {
                case INSERT: {
                    patch.diffs.add(aDiff);
                    patch.length2 += aDiff.text.length();
                    postpatchText = String.valueOf(postpatchText.substring(0, charCount2)) + aDiff.text + postpatchText.substring(charCount2);
                    break;
                }
                case DELETE: {
                    patch.length1 += aDiff.text.length();
                    patch.diffs.add(aDiff);
                    postpatchText = String.valueOf(postpatchText.substring(0, charCount2)) + postpatchText.substring(charCount2 + aDiff.text.length());
                    break;
                }
                case EQUAL: {
                    if (aDiff.text.length() <= 2 * this.patchMargin && !patch.diffs.isEmpty() && aDiff != diffs.getLast()) {
                        patch.diffs.add(aDiff);
                        patch.length1 += aDiff.text.length();
                        patch.length2 += aDiff.text.length();
                    }
                    if (aDiff.text.length() < 2 * this.patchMargin || patch.diffs.isEmpty()) break;
                    this.patchAddContext(patch, prepatchText);
                    patches.add(patch);
                    patch = new Patch();
                    prepatchText = postpatchText;
                    charCount1 = charCount2;
                }
            }
            if (aDiff.operation != Operation.INSERT) {
                charCount1 += aDiff.text.length();
            }
            if (aDiff.operation == Operation.DELETE) continue;
            charCount2 += aDiff.text.length();
        }
        if (!patch.diffs.isEmpty()) {
            this.patchAddContext(patch, prepatchText);
            patches.add(patch);
        }
        return patches;
    }

    protected LinkedList<Patch> patchDeepCopy(LinkedList<Patch> patches) {
        LinkedList<Patch> patchesCopy = new LinkedList<Patch>();
        for (Patch aPatch : patches) {
            Patch patchCopy = new Patch();
            for (Diff aDiff : aPatch.diffs) {
                Diff diffCopy = new Diff(aDiff.operation, aDiff.text);
                patchCopy.diffs.add(diffCopy);
            }
            patchCopy.start1 = aPatch.start1;
            patchCopy.start2 = aPatch.start2;
            patchCopy.length1 = aPatch.length1;
            patchCopy.length2 = aPatch.length2;
            patchesCopy.add(patchCopy);
        }
        return patchesCopy;
    }

    public Object[] patchApply(LinkedList<Patch> patches, String text) {
        if (patches.isEmpty()) {
            return new Object[]{text, new boolean[0]};
        }
        patches = this.patchDeepCopy(patches);
        String nullPadding = this.patchAddPadding(patches);
        text = String.valueOf(nullPadding) + text + nullPadding;
        this.patchSplitMax(patches);
        int x = 0;
        int delta = 0;
        boolean[] results = new boolean[patches.size()];
        for (Patch aPatch : patches) {
            int expectedLoc = aPatch.start2 + delta;
            String text1 = this.diffText1(aPatch.diffs);
            int startLoc = this.matchMain(text, text1, expectedLoc);
            if (startLoc == -1) {
                results[x] = false;
            } else {
                results[x] = true;
                delta = startLoc - expectedLoc;
                String text2 = text.substring(startLoc, Math.min(startLoc + text1.length(), text.length()));
                if (text1.equals(text2)) {
                    text = String.valueOf(text.substring(0, startLoc)) + this.diffText2(aPatch.diffs) + text.substring(startLoc + text1.length());
                } else {
                    LinkedList<Diff> diffs = this.diffMain(text1, text2, false);
                    this.diffCleanupSemanticLossless(diffs);
                    int index1 = 0;
                    for (Diff aDiff : aPatch.diffs) {
                        if (aDiff.operation != Operation.EQUAL) {
                            int index2 = this.diffXIndex(diffs, index1);
                            if (aDiff.operation == Operation.INSERT) {
                                text = String.valueOf(text.substring(0, startLoc + index2)) + aDiff.text + text.substring(startLoc + index2);
                            } else if (aDiff.operation == Operation.DELETE) {
                                text = String.valueOf(text.substring(0, startLoc + index2)) + text.substring(startLoc + this.diffXIndex(diffs, index1 + aDiff.text.length()));
                            }
                        }
                        if (aDiff.operation == Operation.DELETE) continue;
                        index1 += aDiff.text.length();
                    }
                }
            }
            ++x;
        }
        text = text.substring(nullPadding.length(), text.length() - nullPadding.length());
        return new Object[]{text, results};
    }

    public String patchAddPadding(LinkedList<Patch> patches) {
        int extraLength;
        String nullPadding = "";
        int x = 0;
        while (x < this.patchMargin) {
            nullPadding = String.valueOf(nullPadding) + String.valueOf((char)x);
            ++x;
        }
        for (Patch aPatch : patches) {
            aPatch.start1 += nullPadding.length();
            aPatch.start2 += nullPadding.length();
        }
        Patch patch = patches.getFirst();
        LinkedList<Diff> diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getFirst().operation != Operation.EQUAL) {
            diffs.addFirst(new Diff(Operation.EQUAL, nullPadding));
            patch.start1 -= nullPadding.length();
            patch.start2 -= nullPadding.length();
            patch.length1 += nullPadding.length();
            patch.length2 += nullPadding.length();
        } else if (nullPadding.length() > diffs.getFirst().text.length()) {
            Diff firstDiff = diffs.getFirst();
            extraLength = nullPadding.length() - firstDiff.text.length();
            firstDiff.text = String.valueOf(nullPadding.substring(firstDiff.text.length())) + firstDiff.text;
            patch.start1 -= extraLength;
            patch.start2 -= extraLength;
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        patch = patches.getLast();
        diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getLast().operation != Operation.EQUAL) {
            diffs.addLast(new Diff(Operation.EQUAL, nullPadding));
            patch.length1 += nullPadding.length();
            patch.length2 += nullPadding.length();
        } else if (nullPadding.length() > diffs.getLast().text.length()) {
            Diff lastDiff = diffs.getLast();
            extraLength = nullPadding.length() - lastDiff.text.length();
            lastDiff.text = String.valueOf(lastDiff.text) + nullPadding.substring(0, extraLength);
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        return nullPadding;
    }

    public void patchSplitMax(LinkedList<Patch> patches) {
        ListIterator<Patch> pointer = patches.listIterator();
        Patch bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        while (bigpatch != null) {
            if (bigpatch.length1 <= this.matchMaxBits) {
                bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
                continue;
            }
            pointer.remove();
            int patchSize = this.matchMaxBits;
            int start1 = bigpatch.start1;
            int start2 = bigpatch.start2;
            String precontext = "";
            while (!bigpatch.diffs.isEmpty()) {
                Patch patch = new Patch();
                boolean empty = true;
                patch.start1 = start1 - precontext.length();
                patch.start2 = start2 - precontext.length();
                if (precontext.length() != 0) {
                    patch.length1 = patch.length2 = precontext.length();
                    patch.diffs.add(new Diff(Operation.EQUAL, precontext));
                }
                while (!bigpatch.diffs.isEmpty() && patch.length1 < patchSize - this.patchMargin) {
                    Operation diffType = bigpatch.diffs.getFirst().operation;
                    String diffText = bigpatch.diffs.getFirst().text;
                    if (diffType == Operation.INSERT) {
                        patch.length2 += diffText.length();
                        start2 += diffText.length();
                        patch.diffs.addLast(bigpatch.diffs.removeFirst());
                        empty = false;
                        continue;
                    }
                    diffText = diffText.substring(0, Math.min(diffText.length(), patchSize - patch.length1 - this.patchMargin));
                    patch.length1 += diffText.length();
                    start1 += diffText.length();
                    if (diffType == Operation.EQUAL) {
                        patch.length2 += diffText.length();
                        start2 += diffText.length();
                    } else {
                        empty = false;
                    }
                    patch.diffs.add(new Diff(diffType, diffText));
                    if (diffText.equals(bigpatch.diffs.getFirst().text)) {
                        bigpatch.diffs.removeFirst();
                        continue;
                    }
                    bigpatch.diffs.getFirst().text = bigpatch.diffs.getFirst().text.substring(diffText.length());
                }
                precontext = this.diffText2(patch.diffs);
                precontext = precontext.substring(Math.max(0, precontext.length() - this.patchMargin));
                String postcontext = this.diffText1(bigpatch.diffs).length() > this.patchMargin ? this.diffText1(bigpatch.diffs).substring(0, this.patchMargin) : this.diffText1(bigpatch.diffs);
                if (postcontext.length() != 0) {
                    patch.length1 += postcontext.length();
                    patch.length2 += postcontext.length();
                    if (!patch.diffs.isEmpty() && patch.diffs.getLast().operation == Operation.EQUAL) {
                        patch.diffs.getLast().text = String.valueOf(patch.diffs.getLast().text) + postcontext;
                    } else {
                        patch.diffs.add(new Diff(Operation.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch);
            }
            Patch patch = bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        }
    }

    public String patchToText(List<Patch> patches) {
        StringBuilder text = new StringBuilder();
        for (Patch aPatch : patches) {
            text.append(aPatch);
        }
        return text.toString();
    }

    public List<Patch> patchFromText(String textline) throws IllegalArgumentException {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (textline.length() == 0) {
            return patches;
        }
        List<String> textList = Arrays.asList(textline.split("\n"));
        LinkedList<String> text = new LinkedList<String>(textList);
        Pattern patchHeader = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!text.isEmpty()) {
            Matcher m = patchHeader.matcher(text.getFirst());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + text.getFirst());
            }
            Patch patch = new Patch();
            patches.add(patch);
            patch.start1 = Integer.parseInt(m.group(1));
            if (m.group(2).length() == 0) {
                --patch.start1;
                patch.length1 = 1;
            } else if (m.group(2).equals("0")) {
                patch.length1 = 0;
            } else {
                --patch.start1;
                patch.length1 = Integer.parseInt(m.group(2));
            }
            patch.start2 = Integer.parseInt(m.group(3));
            if (m.group(4).length() == 0) {
                --patch.start2;
                patch.length2 = 1;
            } else if (m.group(4).equals("0")) {
                patch.length2 = 0;
            } else {
                --patch.start2;
                patch.length2 = Integer.parseInt(m.group(4));
            }
            text.removeFirst();
            while (!text.isEmpty()) {
                char sign;
                try {
                    sign = text.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    text.removeFirst();
                    continue;
                }
                String line = text.getFirst().substring(1);
                line = line.replace("+", "%2B");
                try {
                    line = URLDecoder.decode(line, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Illegal escape in patchFromText: " + line, e);
                }
                if (sign == '-') {
                    patch.diffs.add(new Diff(Operation.DELETE, line));
                } else if (sign == '+') {
                    patch.diffs.add(new Diff(Operation.INSERT, line));
                } else if (sign == ' ') {
                    patch.diffs.add(new Diff(Operation.EQUAL, line));
                } else {
                    if (sign == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + sign + "' in: " + line);
                }
                text.removeFirst();
            }
        }
        return patches;
    }

    private static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String text) {
            this.operation = operation;
            this.text = text;
        }

        public String toString() {
            String prettyText = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + prettyText + "\")";
        }

        public boolean equals(Object d) {
            if (d == null) {
                return false;
            }
            try {
                return ((Diff)d).operation == this.operation && ((Diff)d).text.equals(this.text);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    public static class Patch {
        public LinkedList<Diff> diffs = new LinkedList();
        public int start1;
        public int start2;
        public int length1;
        public int length2;

        public String toString() {
            String coords1 = this.length1 == 0 ? String.valueOf(this.start1) + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : String.valueOf(this.start1 + 1) + "," + this.length1);
            String coords2 = this.length2 == 0 ? String.valueOf(this.start2) + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : String.valueOf(this.start2 + 1) + "," + this.length2);
            StringBuilder text = new StringBuilder();
            text.append("@@ -").append(coords1).append(" +").append(coords2).append(" @@\n");
            for (Diff aDiff : this.diffs) {
                switch (aDiff.operation) {
                    case INSERT: {
                        text.append('+');
                        break;
                    }
                    case DELETE: {
                        text.append('-');
                        break;
                    }
                    case EQUAL: {
                        text.append(' ');
                    }
                }
                try {
                    text.append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
            }
            return DiffMatchPatch.unescapeForEncodeUriCompatability(text.toString());
        }
    }
}

