/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import jd.nutils.encoding.Encoding;

public class Formatter {
    private static SimpleDateFormat DATE_FORMAT = null;

    public static String formatSeconds(long eta) {
        return Formatter.formatSeconds(eta, true);
    }

    public static String formatSeconds(long eta, boolean showsec) {
        if (eta < 0L) {
            return "~";
        }
        long days = eta / 86400L;
        long hours = (eta -= days * 24L * 60L * 60L) / 3600L;
        long minutes = (eta -= hours * 60L * 60L) / 60L;
        long seconds = eta - minutes * 60L;
        StringBuilder ret = new StringBuilder();
        if (days != 0L) {
            ret.append(days).append('d');
        }
        if (hours != 0L || ret.length() != 0) {
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(hours).append('h');
        }
        if (minutes != 0L || ret.length() != 0) {
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(Formatter.fillInteger(minutes, 2, "0")).append('m');
        }
        if (showsec || ret.length() != 0) {
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(Formatter.fillInteger(seconds, 2, "0")).append('s');
        }
        return ret.toString();
    }

    public static String formatMilliseconds(long ms) {
        return String.valueOf(Formatter.formatSeconds(ms / 1000L)) + "." + Formatter.fillInteger(ms % 1000L, 3, "0");
    }

    public static String formatFilesize(double value, int size) {
        if (value > 1024.0 && size < 5) {
            return Formatter.formatFilesize(value / 1024.0, ++size);
        }
        DecimalFormat c = new DecimalFormat("0.00");
        switch (size) {
            case 0: {
                return String.valueOf(c.format(value)) + " B";
            }
            case 1: {
                return String.valueOf(c.format(value)) + " KB";
            }
            case 2: {
                return String.valueOf(c.format(value)) + " MB";
            }
            case 3: {
                return String.valueOf(c.format(value)) + " GB";
            }
            case 4: {
                return String.valueOf(c.format(value)) + " TB";
            }
        }
        return null;
    }

    public static String formatReadable(long value) {
        if (value < 0L) {
            value = 0L;
        }
        DecimalFormat c = new DecimalFormat("0.00");
        if (value >= 0x10000000000L) {
            return String.valueOf(c.format((double)value / 1.099511627776E12)) + " TB";
        }
        if (value >= 0x40000000L) {
            return String.valueOf(c.format((double)value / 1.073741824E9)) + " GB";
        }
        if (value >= 0x100000L) {
            return String.valueOf(c.format((double)value / 1048576.0)) + " MB";
        }
        if (value >= 1024L) {
            return String.valueOf(c.format((double)value / 1024.0)) + " KB";
        }
        return String.valueOf(value) + " B";
    }

    public static String fillString(String binaryString, String pre, String post, int length) {
        while (binaryString.length() < length) {
            if (binaryString.length() < length) {
                binaryString = String.valueOf(pre) + binaryString;
            }
            if (binaryString.length() >= length) continue;
            binaryString = String.valueOf(binaryString) + post;
        }
        return binaryString;
    }

    public static String fillInteger(long i, int num, String fill) {
        String ret = "" + i;
        while (ret.length() < num) {
            ret = String.valueOf(fill) + ret;
        }
        return ret;
    }

    public static int filterInt(String src) {
        try {
            return Integer.parseInt(Encoding.filterString(src, "1234567890"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long filterLong(String src) {
        try {
            return Long.parseLong(Encoding.filterString(src, "1234567890"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String formatTime(long time) {
        if (DATE_FORMAT == null) {
            DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
            DATE_FORMAT.setLenient(true);
        }
        return DATE_FORMAT.format(new Date(time)).substring(0, 29);
    }

    public static String getRevision(String rev) {
        try {
            int start = rev.indexOf("Revision: ") + 10;
            return rev.substring(start, rev.indexOf(" ", start + 1));
        }
        catch (Exception e) {
            return "-1";
        }
    }
}

