/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.StringTokenizer;
import jd.event.JDBroadcaster;
import jd.event.JDEvent;
import jd.nutils.FtpEvent;
import jd.nutils.FtpListener;
import jd.nutils.JDHash;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFTP {
    private static final int TIMEOUT = 10000;
    private boolean binarymode = false;
    private static boolean DEBUG = true;
    private BufferedReader reader = null;
    private Socket socket = null;
    private BufferedWriter writer = null;
    private String dir = "/";
    private String host;
    private JDBroadcaster<FtpListener, FtpEvent> broadcaster;

    public JDBroadcaster<FtpListener, FtpEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public SimpleFTP() {
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<FtpListener, FtpEvent>(){

            protected void fireEvent(FtpListener listener, FtpEvent event) {
                if (event.getID() == 0) {
                    listener.onDownloadProgress(event);
                }
            }
        };
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        String response = this.readLine();
        boolean b = response.startsWith("200 ");
        if (this.binarymode && b) {
            this.binarymode = false;
        }
        return b;
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        String response = this.readLine();
        boolean b = response.startsWith("200 ");
        if (!this.binarymode && b) {
            this.binarymode = true;
        }
        return b;
    }

    public synchronized void connect(String host) throws IOException {
        this.connect(host, 21);
    }

    public synchronized void connect(String host, int port) throws IOException {
        this.connect(host, port, "anonymous", "anonymous");
    }

    public synchronized void connect(String host, int port, String user, String pass) throws IOException {
        if (this.socket != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.socket = new Socket(host, port);
        this.host = host;
        this.socket.setSoTimeout(10000);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String response = this.readLines(220, "SimpleFTP received an unknown response when connecting to the FTP server: ");
        this.sendLine("USER " + user);
        response = this.readLines(331, "SimpleFTP received an unknown response after sending the user: ");
        this.sendLine("PASS " + pass);
        response = this.readLines(230, "SimpleFTP was unable to log in with the supplied password: ");
        this.sendLine("PWD");
        while ((response = this.readLine()).startsWith("230") || response.charAt(0) >= '9' || response.charAt(0) <= '0') {
        }
        if (!response.startsWith("257 ")) {
            throw new IOException("PWD COmmand not understood " + response);
        }
        this.dir = new Regex(response, "\"(.*)\"").getMatch(0);
    }

    public synchronized boolean cwd(String dir) throws IOException {
        if ((dir = dir.replaceAll("[\\\\|//]+?", "/")).equals(this.dir)) {
            return true;
        }
        this.sendLine("CWD " + dir);
        String response = this.readLine();
        boolean ret = response.startsWith("250 ");
        if (!ret) {
            return ret;
        }
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + "/";
        }
        this.dir = dir.startsWith("/") ? dir : String.valueOf(this.dir) + dir;
        return ret;
    }

    public synchronized void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
        }
        finally {
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int firstQuote;
        int secondQuote;
        this.sendLine("PWD");
        String dir = null;
        String response = this.readLine();
        if (response.startsWith("257 ") && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
            dir = response.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (DEBUG) {
            System.out.println(String.valueOf(this.host) + " < " + line);
        }
        return line;
    }

    private String readLines(int expectcode, String errormsg) throws IOException {
        StringBuilder sb = new StringBuilder();
        String response = null;
        do {
            if ((response = this.readLine()) == null) {
                return sb.toString();
            }
            sb.append(String.valueOf(response) + "\r\n");
            if (!response.startsWith(expectcode + " ")) continue;
            return sb.toString();
        } while (response.startsWith("" + expectcode));
        throw new IOException(String.valueOf(errormsg != null ? errormsg : "revieved unexpected responsecode ") + sb.toString());
    }

    public boolean remove(String string) throws IOException {
        this.sendLine("DELE " + string);
        String response = this.readLine();
        return response.startsWith("250");
    }

    public boolean rename(String from, String to) throws IOException {
        this.sendLine("RNFR " + from);
        String response = this.readLine();
        if (!response.startsWith("350")) {
            return false;
        }
        this.sendLine("RNTO " + to);
        response = this.readLine();
        return response.startsWith("250");
    }

    private void sendLine(String line) throws IOException {
        if (this.socket == null) {
            throw new IOException("SimpleFTP is not connected.");
        }
        try {
            this.writer.write(String.valueOf(line) + "\r\n");
            this.writer.flush();
            if (DEBUG) {
                System.out.println(String.valueOf(this.host) + " > " + line);
            }
        }
        catch (IOException e) {
            this.socket = null;
            throw e;
        }
    }

    public synchronized boolean stor(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("SimpleFTP cannot upload a directory.");
        }
        String filename = file.getName();
        return this.stor(new FileInputStream(file), filename);
    }

    public synchronized boolean stor(InputStream inputStream, String filename) throws IOException {
        try {
            BufferedInputStream input = new BufferedInputStream(inputStream);
            InetSocketAddress pasv = this.pasv();
            this.sendLine("STOR " + filename);
            Socket dataSocket = new Socket(pasv.getHostName(), pasv.getPort());
            String response = this.readLine();
            if (!response.startsWith("150 ") && !response.startsWith("125 ")) {
                throw new IOException("SimpleFTP was not allowed to send the file: " + response);
            }
            BufferedOutputStream output = new BufferedOutputStream(dataSocket.getOutputStream());
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            output.flush();
            output.close();
            input.close();
            this.shutDownSocket(dataSocket);
            response = this.readLine();
            return response.startsWith("226 ");
        }
        catch (ConnectException e) {
            e.printStackTrace();
            this.cancelTransfer();
            return this.stor(inputStream, filename);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.cancelTransfer();
            return this.stor(inputStream, filename);
        }
    }

    private void cancelTransfer() {
        try {
            this.sendLine("ABOR");
            this.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InetSocketAddress pasv() throws IOException {
        this.sendLine("PASV");
        String response = this.readLine();
        if (!response.startsWith("227 ")) {
            throw new IOException("SimpleFTP could not request passive mode: " + response);
        }
        String ip = null;
        int port = -1;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                ip = String.valueOf(tokenizer.nextToken()) + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
                return new InetSocketAddress(ip, port);
            }
            catch (Exception e) {
                throw new IOException("SimpleFTP received bad data link information: " + response);
            }
        }
        throw new IOException("SimpleFTP received bad data link information: " + response);
    }

    public boolean mkdir(String cw2) throws IOException {
        String tmp = this.dir;
        String cw = cw2;
        try {
            cw = cw.replace("\\", "/");
            String[] cwdirs = cw.split("[\\\\|/]{1}");
            String[] dirdirs = this.dir.split("[\\\\|/]{1}");
            int length = 0;
            String root = "";
            int i = 0;
            while (i < Math.min(cwdirs.length, dirdirs.length)) {
                if (cwdirs[i].equals(dirdirs[i])) {
                    length += cwdirs[i].length() + 1;
                    root = String.valueOf(root) + cwdirs[i] + "/";
                }
                ++i;
            }
            cw = cw.substring(length);
            String[] dirs = cw.split("[\\\\|/]{1}");
            if (root.length() > 0) {
                this.cwd(root);
            }
            String[] stringArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                if (d == null || d.trim().length() == 0) {
                    this.cwd("/");
                } else {
                    this.sendLine("MKD " + d);
                    String response = this.readLine();
                    if (!response.startsWith("257 ") && !response.startsWith("550 ")) {
                        return false;
                    }
                    this.cwd(d);
                }
                ++n2;
            }
            return true;
        }
        finally {
            this.cwd(tmp);
        }
    }

    public boolean cwdAdd(String cw) throws IOException {
        if (cw.startsWith("/") || cw.startsWith("\\")) {
            cw = cw.substring(1);
        }
        return this.cwd(String.valueOf(this.dir) + cw);
    }

    public String getDir() {
        return this.dir;
    }

    public static void upload(String ip, int port, String user, String password, String destfolder, File ... src) throws IOException {
        SimpleFTP ftp = new SimpleFTP();
        ftp.connect(ip, port, user, password);
        ftp.bin();
        ftp.cwd(destfolder);
        File[] fileArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            ftp.stor(f);
            ++n2;
        }
        ftp.disconnect();
    }

    public static void uploadtoFolderSecure(String ip, int port, String user, String password, String destfolder, File ... src) throws IOException {
        SimpleFTP ftp = new SimpleFTP();
        ftp.connect(ip, port, user, password);
        ftp.bin();
        ftp.cwd(destfolder);
        File[] fileArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            ftp.stor(f);
            File dummy = File.createTempFile("simpleftp_secure", null);
            ftp.download(f.getName(), dummy);
            if (!JDHash.getMD5(dummy).equalsIgnoreCase(JDHash.getMD5(f))) {
                throw new IOException("MD5 check failed for: " + f);
            }
            if (DEBUG) {
                System.out.println("---- MD5 OK: /" + ftp.getDir() + f.getName() + " -----" + JDHash.getMD5(dummy));
            }
            dummy.delete();
            ++n2;
        }
        ftp.disconnect();
    }

    public static void uploadSecure(String ip, int port, String user, String password, String destfolder, File root, File ... list) throws IOException {
        File f;
        SimpleFTP ftp = new SimpleFTP();
        ftp.connect(ip, port, user, password);
        ftp.bin();
        long size = 0L;
        long transfered = 0L;
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            size += f.length();
            ++n2;
        }
        fileArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            block13: {
                f = fileArray[n2];
                if (!f.getAbsolutePath().startsWith(root.getAbsolutePath())) {
                    throw new IOException(f + " is not part of " + root);
                }
                String subfolder = f.isDirectory() ? f.getAbsolutePath().substring(root.getAbsolutePath().length()) : f.getParent().substring(root.getAbsolutePath().length());
                if (!ftp.cwd(SimpleFTP.mergeFolders(destfolder, subfolder))) {
                    ftp.mkdir(SimpleFTP.mergeFolders(destfolder, subfolder));
                    if (!ftp.cwd(SimpleFTP.mergeFolders(destfolder, subfolder))) {
                        throw new IOException("Unexpected error");
                    }
                }
                if (!f.isDirectory()) {
                    File dummy;
                    block12: {
                        dummy = File.createTempFile("simpleftp_secure", null);
                        try {
                            ftp.download(f.getName(), dummy);
                            if (!JDHash.getMD5(dummy).equalsIgnoreCase(JDHash.getMD5(f))) break block12;
                            if (DEBUG) {
                                System.out.println("---- Skip .MD5 ok: " + ftp.getDir() + f.getName() + " -----" + JDHash.getMD5(dummy));
                            }
                            break block13;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    dummy.delete();
                    ftp.stor(f);
                    ftp.download(f.getName(), dummy);
                    if (!JDHash.getMD5(dummy).equalsIgnoreCase(JDHash.getMD5(f))) {
                        throw new IOException("MD5 check failed for: " + f);
                    }
                    if (DEBUG) {
                        System.out.println("---- MD5 OK: /" + ftp.getDir() + f.getName() + " -----" + JDHash.getMD5(dummy));
                    }
                    dummy.delete();
                }
                transfered += f.length();
                if (DEBUG) {
                    System.out.println(String.valueOf(ftp.host) + ": " + transfered * 100L / size + "%");
                }
            }
            ++n2;
        }
        ftp.disconnect();
    }

    /*
     * Unable to fully structure code
     */
    private static String mergeFolders(String ... dirs) {
        res = dirs[0];
        i = 1;
        ** GOTO lbl12
        {
            res = res.substring(0, res.length() - 1);
            do {
                if (res.endsWith("/") || res.endsWith("\\")) continue block0;
                while (dirs[i].startsWith("/") || dirs[i].startsWith("\\")) {
                    dirs[i] = dirs[i].substring(1);
                }
                res = String.valueOf(res) + "/" + dirs[i];
                ++i;
lbl12:
                // 2 sources

            } while (i < dirs.length);
        }
        return res;
    }

    public void download(String filename, File file) throws IOException {
        if (!this.binarymode) {
            System.out.println("Warning: Download in ASCII mode may fail!");
        }
        InetSocketAddress pasv = this.pasv();
        this.sendLine("RETR " + filename);
        try {
            Socket dataSocket = new Socket(pasv.getHostName(), pasv.getPort());
            BufferedInputStream input = new BufferedInputStream(dataSocket.getInputStream());
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            String response = this.readLine();
            if (!response.startsWith("150")) {
                this.shutDownSocket(dataSocket);
                input.close();
                out.close();
                throw new IOException("Unexpected Response: " + response);
            }
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            long counter = 0L;
            while ((bytesRead = input.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    this.socket.setSoTimeout(10000);
                    out.close();
                    this.shutDownSocket(dataSocket);
                    input.close();
                    try {
                        response = this.readLine();
                    }
                    catch (SocketTimeoutException e) {
                        response = "SocketTimeout because of buggy Server";
                    }
                    this.shutDownSocket(dataSocket);
                    input.close();
                    out.close();
                    throw new InterruptedIOException();
                }
                counter += (long)bytesRead;
                if (bytesRead > 0) {
                    out.write(buffer, 0, bytesRead);
                }
                this.broadcaster.fireEvent((JDEvent)new FtpEvent(this, 0, counter));
            }
            this.socket.setSoTimeout(10000);
            out.close();
            this.shutDownSocket(dataSocket);
            input.close();
            try {
                response = this.readLine();
            }
            catch (SocketTimeoutException e) {
                response = "SocketTimeout because of buggy Server";
            }
            if (!response.startsWith("226")) {
                throw new IOException("Download failed: " + response);
            }
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
    }

    private void shutDownSocket(Socket dataSocket) {
        try {
            dataSocket.shutdownOutput();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dataSocket.shutdownInput();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dataSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void download(String ip, int port, String user, String password, String filepath, String name, File file) throws IOException {
        SimpleFTP ftp = new SimpleFTP();
        ftp.connect(ip, port, user, password);
        ftp.bin();
        ftp.cwd(filepath);
        ftp.download(name, file);
    }

    public String[][] list() throws IOException {
        InetSocketAddress pasv = this.pasv();
        this.sendLine("LIST");
        Socket dataSocket = new Socket(pasv.getHostName(), pasv.getPort());
        BufferedReader input = new BufferedReader(new InputStreamReader(dataSocket.getInputStream(), "UTF8"));
        StringBuilder sb = new StringBuilder();
        String response = this.readLine();
        if (!response.startsWith("150")) {
            throw new IOException("Unexpected Response: " + response);
        }
        char[] buffer = new char[4096];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        input.close();
        this.shutDownSocket(dataSocket);
        this.readLine();
        String[][] matches = new Regex(sb.toString(), "(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+\\s+\\S+\\s+\\S+)\\s+([^\r^\n]+)").getMatches();
        return matches;
    }

    public String[] getFileInfo(String path) throws IOException {
        String name = path.substring(path.lastIndexOf("/") + 1);
        path = path.substring(0, path.lastIndexOf("/"));
        this.cwd(path);
        String[][] stringArray = this.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] file = stringArray[n2];
            if (file[6].equals(name)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public void connect(URL url) throws IOException {
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0) {
            port = 21;
        }
        if (url.getUserInfo() != null) {
            String[] auth = url.getUserInfo().split(":");
            this.connect(host, port, auth[0], auth[1]);
        } else {
            this.connect(host, port);
        }
    }
}

