/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.nativeintegration;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jd.gui.swing.jdgui.GUIUtils;

public class ScreenDevices {
    private static ScreenDevices INSTANCE = new ScreenDevices();
    private static DeviceInfo[] SCREENS = new DeviceInfo[0];

    static {
        try {
            ArrayList<DeviceInfo> robint = new ArrayList<DeviceInfo>();
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = graphicsDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice dv = graphicsDeviceArray[n2];
                try {
                    DeviceInfo tmp = INSTANCE.new DeviceInfo();
                    tmp.robot = new Robot(dv);
                    tmp.dv = dv;
                    tmp.height = dv.getDisplayMode().getHeight();
                    tmp.width = dv.getDisplayMode().getWidth();
                    tmp.posx = dv.getDefaultConfiguration().getBounds().x;
                    tmp.maxx = tmp.posx + tmp.width;
                    tmp.posy = dv.getDefaultConfiguration().getBounds().y;
                    tmp.maxy = tmp.posy + tmp.height;
                    robint.add(tmp);
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            SCREENS = robint.toArray(new DeviceInfo[robint.size()]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean gotRobots() {
        return SCREENS.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDevice getGraphicsDeviceforPoint(Point p) {
        DeviceInfo[] deviceInfoArray = SCREENS;
        synchronized (SCREENS) {
            if (SCREENS.length == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            DeviceInfo[] deviceInfoArray2 = SCREENS;
            int n = SCREENS.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceInfo dv = deviceInfoArray2[n2];
                if (p.x >= dv.posx && p.x <= dv.maxx && p.y >= dv.posy && p.y <= dv.maxy) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return dv.dv;
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScreenShot(Rectangle r) throws AWTException {
        DeviceInfo[] deviceInfoArray = SCREENS;
        synchronized (SCREENS) {
            if (SCREENS.length == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new Robot().createScreenCapture(r);
            }
            if (GUIUtils.getConfig().getBooleanProperty("XINERAMAWORKAROUND", false).booleanValue()) {
                DeviceInfo[] deviceInfoArray2 = SCREENS;
                int n = SCREENS.length;
                int n2 = 0;
                while (n2 < n) {
                    DeviceInfo dv = deviceInfoArray2[n2];
                    if (r.x >= dv.posx && r.x <= dv.maxx && r.y >= dv.posy && r.y <= dv.maxy) {
                        r.x -= dv.posx;
                        r.y -= dv.posy;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return dv.robot.createScreenCapture(r);
                    }
                    ++n2;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ScreenDevices.SCREENS[0].robot.createScreenCapture(r);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ScreenDevices.SCREENS[0].robot.createScreenCapture(r);
        }
    }

    class DeviceInfo {
        Robot robot;
        GraphicsDevice dv;
        int width;
        int height;
        int posx;
        int posy;
        int maxx;
        int maxy;

        DeviceInfo() {
        }
    }
}

