/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.appwork.swing.trayicon.ExtTrayIcon;
import org.appwork.swing.trayicon.TrayIconPopup;
import org.appwork.swing.trayicon.TrayMouseListener;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.event.BasicEvent;
import org.appwork.utils.event.BasicEventSender;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTrayIcon
implements MouseListener,
TrayMouseListener {
    public static final int EVENT_TOGGLE_FRAME_VISIBILITY = 0;
    public static final int EVENT_SHOW_POPUP = 1;
    public static final int EVENT_HIDE_POPUP = 2;
    private final JFrame frame;
    private ExtTrayIcon trayIcon;
    private TrayIconPopup trayIconPopup;
    private final int visibleToggleClickCount = 2;
    private final BasicEventSender<AWTrayIcon> eventSender;

    public AWTrayIcon(JFrame frame) throws AWTException {
        this(frame, frame.getIconImages() == null || frame.getIconImages().size() == 0 ? ImageProvider.createIcon(frame.getTitle() != null && frame.getTitle().length() > 0 ? String.valueOf(frame.getTitle().charAt(0)) : "T", 32, 32) : frame.getIconImages().get(0));
    }

    public AWTrayIcon(JFrame frame, Image icon) throws AWTException {
        this.frame = frame;
        this.eventSender = new BasicEventSender();
        SystemTray systemTray = SystemTray.getSystemTray();
        this.trayIcon = new ExtTrayIcon(icon, frame.getTitle());
        this.trayIcon.addMouseListener(this);
        this.trayIcon.addTrayMouseListener(this);
        systemTray.add(this.trayIcon);
    }

    public TrayIconPopup createPopup() {
        return null;
    }

    public void displayToolTip() {
    }

    public void dispose() {
        new EDTRunner(){

            protected void runInEDT() {
                try {
                    if (AWTrayIcon.this.trayIcon != null) {
                        SystemTray.getSystemTray().remove(AWTrayIcon.this.trayIcon);
                        AWTrayIcon.this.trayIcon.removeMouseListener(AWTrayIcon.this);
                        AWTrayIcon.this.trayIcon.removeTrayMouseListener(AWTrayIcon.this);
                        AWTrayIcon.this.trayIcon = null;
                        AWTrayIcon.this.hideToolTip();
                        if (AWTrayIcon.this.trayIconPopup != null) {
                            AWTrayIcon.this.trayIconPopup.dispose();
                            AWTrayIcon.this.trayIconPopup = null;
                            AWTrayIcon.this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)AWTrayIcon.this, 2, AWTrayIcon.this, null));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public BasicEventSender<AWTrayIcon> getEventSender() {
        return this.eventSender;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void hideToolTip() {
    }

    public boolean isFrameVisible() {
        return this.frame.isVisible();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hideToolTip();
    }

    @Override
    public void mouseMoveOverTray(MouseEvent me) {
        if (this.trayIconPopup != null && this.trayIconPopup.isVisible()) {
            return;
        }
        this.displayToolTip();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.hideToolTip();
        if (e.getSource() instanceof TrayIcon) {
            if (!CrossSystem.isMac()) {
                if (e.getClickCount() == 2 && !SwingUtilities.isRightMouseButton(e)) {
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 0, this, null));
                    this.onToggleVisibility();
                } else if (this.trayIconPopup != null && this.trayIconPopup.isShowing()) {
                    this.trayIconPopup.dispose();
                    this.trayIconPopup = null;
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 2, this, null));
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    this.trayIconPopup = this.createPopup();
                    if (this.trayIconPopup == null) {
                        return;
                    }
                    this.trayIconPopup.setPosition(e.getPoint());
                    this.trayIconPopup.setVisible(true);
                    this.trayIconPopup.startAutoHide();
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 1, this, null));
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 2 && !SwingUtilities.isLeftMouseButton(e)) {
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 0, this, null));
                    this.onToggleVisibility();
                } else if (this.trayIconPopup != null && this.trayIconPopup.isShowing()) {
                    this.trayIconPopup.dispose();
                    this.trayIconPopup = null;
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 2, this, null));
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    this.trayIconPopup = this.createPopup();
                    if (this.trayIconPopup == null) {
                        return;
                    }
                    Point pointOnScreen = e.getLocationOnScreen();
                    if (e.getX() > 0) {
                        pointOnScreen.x -= e.getPoint().x;
                    }
                    this.trayIconPopup.setPosition(pointOnScreen);
                    this.trayIconPopup.setVisible(true);
                    this.trayIconPopup.startAutoHide();
                    this.eventSender.fireEvent(new BasicEvent<AWTrayIcon>((Object)this, 1, this, null));
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void onToggleVisibility() {
        this.setFrameVisible(!this.isFrameVisible());
    }

    public void setFrameVisible(final boolean visible) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                JFrame resetAlwaysOnTop;
                if (!visible) {
                    AWTrayIcon.this.frame.setVisible(false);
                    resetAlwaysOnTop = null;
                } else {
                    resetAlwaysOnTop = !AWTrayIcon.this.frame.isAlwaysOnTop() ? AWTrayIcon.this.frame : null;
                    AWTrayIcon.this.frame.setAlwaysOnTop(true);
                    AWTrayIcon.this.frame.setVisible(true);
                    AWTrayIcon.this.frame.toFront();
                }
                if (visible && resetAlwaysOnTop != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            resetAlwaysOnTop.setAlwaysOnTop(false);
                        }
                    });
                }
                return null;
            }
        }.start();
    }

    public void setImage(Image icon) {
        this.trayIcon.setImage(icon);
    }

    public void setToolTip(String tooltip) {
        this.trayIcon.setToolTip(tooltip);
    }
}

