/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.trayicon.AWTrayIcon;
import org.appwork.swing.trayicon.HoverEffect;
import org.appwork.utils.event.BasicEvent;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;

public abstract class TrayIconPopup
extends JWindow {
    private static final long serialVersionUID = -6632773260637754243L;
    private boolean enteredPopup;
    private final transient Thread hideThread;
    private boolean hideThreadrunning = false;
    private final AWTrayIcon owner;

    public TrayIconPopup(AWTrayIcon awTrayIcon) {
        super(awTrayIcon.getFrame());
        this.owner = awTrayIcon;
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 5, wrap 1", "[grow,fill]", "[]"));
        content.setBorder(BorderFactory.createLineBorder(content.getBackground().darker()));
        content = this.init(content);
        if (content != null) {
            this.add(content);
        }
        this.setAlwaysOnTop(true);
        this.pack();
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                TrayIconPopup.this.enteredPopup = true;
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.hideThread = new Thread(){

            public void run() {
                while (TrayIconPopup.this.hideThreadrunning) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!TrayIconPopup.this.enteredPopup || !TrayIconPopup.this.hideThreadrunning) continue;
                    PointerInfo mouse = MouseInfo.getPointerInfo();
                    Point current = TrayIconPopup.this.getLocation();
                    if (mouse.getLocation().x < current.x || mouse.getLocation().x > current.x + TrayIconPopup.this.getSize().width) {
                        TrayIconPopup.this.dispose();
                        break;
                    }
                    if (mouse.getLocation().y >= current.y && mouse.getLocation().y <= current.y + TrayIconPopup.this.getSize().height) continue;
                    TrayIconPopup.this.dispose();
                    break;
                }
            }
        };
        this.hideThreadrunning = true;
        this.hideThread.start();
    }

    protected Component createButton(AbstractAction action) {
        JToggleButton bt = new JToggleButton(action);
        bt.setOpaque(false);
        bt.setContentAreaFilled(false);
        bt.setBorderPainted(false);
        bt.setIcon((Icon)action.getValue("SmallIcon"));
        bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrayIconPopup.this.dispose();
            }
        });
        bt.setFocusPainted(false);
        bt.setHorizontalAlignment(2);
        bt.setIconTextGap(5);
        bt.addMouseListener(new HoverEffect(bt));
        return bt;
    }

    public void dispose() {
        this.hideThreadrunning = false;
        super.dispose();
        this.owner.getEventSender().fireEvent(new BasicEvent<AWTrayIcon>((Object)this.owner, 2, this.owner, null));
    }

    public AWTrayIcon getTrayIcon() {
        return this.owner;
    }

    protected abstract JPanel init(JPanel var1);

    public void setPosition(Point p) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int limitX = (int)screenSize.getWidth() / 2;
        int limitY = (int)screenSize.getHeight() / 2;
        if (!CrossSystem.isMac()) {
            if (p.x <= limitX) {
                if (p.y <= limitY) {
                    this.setLocation(p.x, p.y);
                } else {
                    this.setLocation(p.x, p.y - this.getHeight());
                }
            } else if (p.y <= limitY) {
                this.setLocation(p.x - this.getWidth(), p.y);
            } else {
                this.setLocation(p.x - this.getWidth(), p.y - this.getHeight());
            }
        } else if (p.getX() <= screenSize.getWidth() - (double)this.getWidth()) {
            this.setLocation((int)p.getX(), 22);
        } else {
            this.setLocation(p.x - this.getWidth(), 22);
        }
    }

    public void startAutoHide() {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TrayIconPopup.this.enteredPopup) {
                    new EDTHelper<Object>(){

                        public Object edtRun() {
                            TrayIconPopup.this.dispose();
                            return null;
                        }
                    }.start();
                }
            }
        }.start();
    }
}

