/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    public static void deleteRecursiv(File ... files) throws IOException {
        File file;
        ArrayList<File> ret = Files.getFiles(true, true, files);
        int i = ret.size() - 1;
        while (i >= 0) {
            file = ret.get(i);
            if (!file.exists() || file.isFile()) {
                ret.remove(i);
            }
            if (file.exists() && file.isFile() && !file.delete()) {
                throw new IOException("could not delete " + file);
            }
            --i;
        }
        i = ret.size() - 1;
        while (i >= 0) {
            file = ret.get(i);
            if (file.isDirectory()) {
                ret.remove(i);
            }
            if (file.exists() && file.isDirectory() && !file.delete()) {
                throw new IOException("could not delete " + file);
            }
            --i;
        }
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1).toLowerCase();
    }

    public static ArrayList<File> getFiles(boolean includeDirectories, boolean includeFiles, File ... files) {
        ArrayList<File> ret = new ArrayList<File>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists()) {
                    if (f.isDirectory()) {
                        if (includeDirectories) {
                            ret.add(f);
                        }
                        ret.addAll(Files.getFiles(includeDirectories, includeFiles, f.listFiles()));
                    } else if (includeFiles) {
                        ret.add(f);
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public static String getMimeType(String name) {
        if (name == null) {
            return null;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String ret = fileNameMap.getContentTypeFor(name);
        if (ret == null) {
            ret = "unknown/" + Files.getExtension(name);
        }
        return ret;
    }

    public static File getExistingFile(File file, boolean caseSensitive) {
        File[] list;
        if (file == null) {
            return null;
        }
        if (caseSensitive) {
            if (file.exists()) {
                return file;
            }
            return null;
        }
        String lowerCaseFileName = file.getName().toLowerCase();
        File parent = file.getParentFile();
        if (parent != null && (list = parent.listFiles()) != null) {
            File[] fileArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File ret = fileArray[n2];
                if (ret.getName().equalsIgnoreCase(lowerCaseFileName)) {
                    return ret;
                }
                ++n2;
            }
        }
        return null;
    }

    public static LinkedList<String> getDirectories_NonRecursive(File startDirectory, boolean includeStart) throws IOException {
        LinkedList<String> done = new LinkedList<String>();
        File current = null;
        File[] currents = null;
        ArrayList<File> todo = new ArrayList<File>();
        todo.add(startDirectory);
        while (todo.size() > 0) {
            current = (File)todo.remove(0);
            currents = current.listFiles();
            done.add(current.getCanonicalPath());
            if (currents == null) continue;
            int index = currents.length - 1;
            while (index >= 0) {
                String temp;
                if (currents[index].isDirectory() && !done.contains(temp = currents[index].getCanonicalPath())) {
                    todo.add(currents[index]);
                }
                --index;
            }
        }
        if (!includeStart && done.size() > 0) {
            done.remove(0);
        }
        return done;
    }
}

