/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.ImageProvider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import sun.awt.image.ToolkitImage;

public class ImageProvider {
    private static HashMap<String, BufferedImage> IMAGE_CACHE = new HashMap();
    private static HashMap<String, ImageIcon> IMAGEICON_CACHE = new HashMap();
    private static HashMap<Icon, Icon> DISABLED_ICON_CACHE = new HashMap();
    private static Object LOCK = new Object();
    private static StringBuilder SB = new StringBuilder();

    public static BufferedImage convertToGrayScale(BufferedImage bufferedImage) {
        BufferedImage dest = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage((Image)bufferedImage, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static Image createIcon(String string, int width, int height) {
        int w = width;
        int h = height;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        int size = 1 + width / string.length();
        int ww = 0;
        int hh = 0;
        while (size > 0) {
            g.setFont(new Font("Arial", 1, --size));
            ww = g.getFontMetrics().stringWidth(string);
            hh = g.getFontMetrics().getAscent();
            if (ww < w - 4 && hh < h - 2) break;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w - 1, h - 1);
        g.draw3DRect(0, 0, w - 1, h - 1, true);
        g.setColor(Color.BLACK);
        g.drawString(string, (w - ww) / 2, hh + (h - hh) / 2);
        g.dispose();
        return image;
    }

    public static Image getBufferedImage(String name, boolean createDummy) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (IMAGE_CACHE.containsKey(name)) {
                return IMAGE_CACHE.get(name);
            }
            URL absolutePath = Application.getRessourceURL("images/" + name + ".png");
            try {
                Log.L.info("Init Image: " + absolutePath);
                BufferedImage image = ImageProvider.read(absolutePath);
                IMAGE_CACHE.put(name, image);
                return image;
            }
            catch (IOException e) {
                Log.L.severe("Could not Init Image: " + absolutePath);
                if (createDummy) {
                    Log.exception((Level)Level.WARNING, (Throwable)e);
                    return ImageProvider.createIcon(name.toUpperCase(), 48, 48);
                }
                throw e;
            }
        }
    }

    public static Icon getDisabledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon ret = DISABLED_ICON_CACHE.get(icon);
        if (ret != null) {
            return ret;
        }
        ret = UIManager.getLookAndFeel().getDisabledIcon(null, icon);
        DISABLED_ICON_CACHE.put(icon, ret);
        return ret;
    }

    public static ImageIcon getImageIcon(String name, int x, int y) {
        try {
            return ImageProvider.getImageIcon(name, x, y, true);
        }
        catch (IOException e) {
            Log.exception((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String name, int width, int height, boolean createDummy) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            SB.delete(0, SB.capacity());
            SB.append(name);
            SB.append('_');
            SB.append(width);
            SB.append('_');
            SB.append(height);
            String key = SB.toString();
            if (IMAGEICON_CACHE.containsKey(key)) {
                return IMAGEICON_CACHE.get(key);
            }
            Image image = ImageProvider.getBufferedImage(name, createDummy);
            double faktor = Math.max((double)image.getWidth(null) / (double)width, (double)image.getHeight(null) / (double)height);
            width = (int)((double)image.getWidth(null) / faktor);
            height = (int)((double)image.getHeight(null) / faktor);
            ImageIcon imageicon = new ImageIcon(image.getScaledInstance(width, height, 4));
            IMAGEICON_CACHE.put(key, imageicon);
            return imageicon;
        }
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int width, int height, Object hint, boolean higherQuality) {
        int h;
        int w;
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = width;
            h = height;
        }
        do {
            if (higherQuality && w > width && (w /= 2) < width) {
                w = width;
            }
            if (higherQuality && h > height && (h /= 2) < height) {
                h = height;
            }
            BufferedImage tmp = new BufferedImage(w, h, ret.getType());
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return ret;
    }

    public static BufferedImage merge(Image image, Image b, int xoffset, int yoffset) {
        int width = Math.max(image.getWidth(null), xoffset + b.getWidth(null));
        int height = Math.max(image.getHeight(null), yoffset + b.getHeight(null));
        BufferedImage dest = new BufferedImage(width, height, 3);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.drawImage(b, xoffset, yoffset, null);
        g2.dispose();
        return dest;
    }

    public static BufferedImage read(File input) throws IOException {
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        return ImageProvider.read(input.toURI().toURL());
    }

    private static BufferedImage read(URL absolutePath) throws IOException {
        if (absolutePath == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream stream = ImageIO.createImageInputStream(absolutePath.openStream());
        BufferedImage bi = null;
        try {
            if (stream == null) {
                throw new IIOException("Can't create an ImageInputStream!");
            }
            bi = ImageIO.read(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
        return bi;
    }

    public static Image resizeWorkSpace(Image scaleBufferedImage, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        g.drawImage(scaleBufferedImage, (width - scaleBufferedImage.getWidth(null)) / 2, (height - scaleBufferedImage.getHeight(null)) / 2, null);
        g.dispose();
        return image;
    }

    public static Image scaleBufferedImage(BufferedImage img, int width, int height) {
        if (img == null) {
            return null;
        }
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        return img.getScaledInstance(width, height, 4);
    }

    public static ImageIcon scaleImageIcon(ImageIcon img, int w, int h) {
        BufferedImage dest;
        if (img.getIconHeight() == h && img.getIconWidth() == w) {
            return img;
        }
        if (img.getImage() instanceof ToolkitImage) {
            dest = new BufferedImage(w, h, 3);
            Graphics2D g2 = dest.createGraphics();
            g2.drawImage(img.getImage(), 0, 0, null);
            g2.dispose();
        } else {
            dest = (BufferedImage)img.getImage();
        }
        return new ImageIcon(ImageProvider.scaleBufferedImage(dest, w, h));
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(image);
    }
}

