/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Queue
extends Thread {
    protected boolean debugFlag = false;
    protected QueuePriority[] prios;
    protected HashMap<QueuePriority, ArrayList<QueueAction<?, ? extends Throwable>>> queue = new HashMap();
    protected final Object queueLock = new Object();
    protected ArrayList<QueueAction<?, ? extends Throwable>> queueThreadHistory = new ArrayList(20);
    protected Thread thread = null;
    protected boolean waitFlag = true;
    protected static AtomicInteger QUEUELOOPPREVENTION = new AtomicInteger(0);

    public Queue(String id) {
        super(id);
        QUEUELOOPPREVENTION.incrementAndGet();
        QueuePriority[] queuePriorityArray = this.prios = QueuePriority.values();
        int n = this.prios.length;
        int n2 = 0;
        while (n2 < n) {
            QueuePriority prio = queuePriorityArray[n2];
            this.queue.put(prio, new ArrayList());
            ++n2;
        }
        this.setDaemon(true);
        this.start();
    }

    public <E, T extends Throwable> void add(QueueAction<?, T> action) throws T {
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        if (this.isQueueThread(action)) {
            this.startItem(action, false);
        } else {
            this.internalAdd(action);
        }
    }

    public <E, T extends Throwable> void addAsynch(QueueAction<?, T> action) {
        if (this.isQueueThread(action)) {
            throw new RuntimeException("called addAsynch from the queue itself");
        }
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        this.internalAdd(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, T extends Throwable> E addWait(QueueAction<E, T> item) throws T {
        item.reset();
        item.setCallerThread(this, Thread.currentThread());
        if (this.isQueueThread(item)) {
            this.startItem(item, false);
        } else {
            this.internalAdd(item);
            try {
                while (!item.isFinished()) {
                    QueueAction<E, T> queueAction = item;
                    synchronized (queueAction) {
                        item.wait(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                item.handleException(e);
            }
            if (item.getExeption() != null && !item.callExceptionHandler()) {
                if (item.getExeption() instanceof RuntimeException) {
                    throw (RuntimeException)item.getExeption();
                }
                throw item.getExeption();
            }
            if (item.gotKilled() && !item.gotStarted()) {
                item.handleException(new InterruptedException("Queue got killed!"));
            }
        }
        return item.getResult();
    }

    public void enqueue(QueueAction<?, ?> action) {
        action.reset();
        action.setCallerThread(this, Thread.currentThread());
        this.internalAdd(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueAction<?, ? extends Throwable> getLastHistoryItem() {
        ArrayList<QueueAction<?, ? extends Throwable>> arrayList = this.queueThreadHistory;
        synchronized (arrayList) {
            block4: {
                if (this.queueThreadHistory.size() != 0) break block4;
                return null;
            }
            return this.queueThreadHistory.get(this.queueThreadHistory.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQueueSize(QueuePriority prio) {
        if (prio == null) {
            return -1L;
        }
        Object object = this.queueLock;
        synchronized (object) {
            ArrayList<QueueAction<?, Throwable>> ret;
            block5: {
                ret = this.queue.get((Object)prio);
                if (ret != null) break block5;
                return -1L;
            }
            return ret.size();
        }
    }

    protected void handlePreRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAdd(QueueAction<?, ?> action) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.get((Object)action.getQueuePrio()).add(action);
        }
        object = this;
        synchronized (object) {
            if (this.waitFlag) {
                this.waitFlag = false;
                this.notify();
            }
        }
    }

    public boolean isDebug() {
        return this.debugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() {
        Object object = this.queueLock;
        synchronized (object) {
            QueuePriority[] queuePriorityArray = this.prios;
            int n = this.prios.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                QueuePriority prio = queuePriorityArray[n2];
                if (!this.queue.get((Object)prio).isEmpty()) {
                    return false;
                }
                ++n2;
            }
        }
    }

    public boolean isQueueThread(QueueAction<?, ? extends Throwable> item) {
        if (Thread.currentThread() == this.thread) {
            return true;
        }
        QueueAction<?, Throwable> last = item;
        Thread t = null;
        int loopprevention = 0;
        while (last != null && (t = last.getCallerThread()) != null) {
            if (t == null || !(t instanceof Queue)) break;
            if (t == this.thread) {
                if (this.debugFlag) {
                    Log.L.warning("Multiple queues detected-> external synchronization may be required! " + item);
                }
                return true;
            }
            last = ((Queue)t).getLastHistoryItem();
            if (loopprevention > QUEUELOOPPREVENTION.get()) {
                if (!this.debugFlag) break;
                Log.L.warning("QueueLoopPrevention!");
                break;
            }
            ++loopprevention;
        }
        return false;
    }

    public boolean isWaiting() {
        return this.waitFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            QueuePriority[] queuePriorityArray = this.prios;
            int n = this.prios.length;
            int n2 = 0;
            while (n2 < n) {
                QueuePriority prio = queuePriorityArray[n2];
                for (QueueAction<?, Throwable> item : this.queue.get((Object)prio)) {
                    item.kill();
                    QueueAction<?, Throwable> queueAction = item;
                    synchronized (queueAction) {
                        item.notify();
                    }
                }
                this.queue.get((Object)prio).clear();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.thread != null) {
            return;
        }
        this.thread = this;
        QueueAction<?, ? extends Throwable> item = null;
        while (true) {
            try {
                while (true) {
                    this.handlePreRun();
                    Object object = this;
                    synchronized (object) {
                        while (this.waitFlag) {
                            try {
                                this.wait();
                            }
                            catch (Exception e) {
                                Log.exception((Throwable)e);
                            }
                        }
                    }
                    object = this.queueLock;
                    synchronized (object) {
                        item = null;
                        QueuePriority[] queuePriorityArray = this.prios;
                        int n = this.prios.length;
                        int n2 = 0;
                        while (n2 < n) {
                            QueuePriority prio = queuePriorityArray[n2];
                            if (this.queue.get((Object)prio).size() > 0) {
                                item = this.queue.get((Object)prio).remove(0);
                                break;
                            }
                            ++n2;
                        }
                        if (item == null) {
                            this.waitFlag = true;
                        }
                    }
                    if (item == null || this.waitFlag) continue;
                    try {
                        this.startItem(item, true);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                Log.L.info("Queue rescued!");
                Log.exception((Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setDebug(boolean b) {
        this.debugFlag = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Throwable> void startItem(QueueAction<?, T> item, boolean callExceptionhandler) throws T {
        block35: {
            Object object;
            try {
                try {
                    if (this.thread != item.getCallerThread()) {
                        ArrayList<QueueAction<?, ? extends Throwable>> arrayList = this.queueThreadHistory;
                        synchronized (arrayList) {
                            this.queueThreadHistory.add(item);
                        }
                    }
                    item.start(this);
                }
                catch (Throwable e) {
                    Object object2;
                    if (!callExceptionhandler || !item.callExceptionHandler()) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw e;
                    }
                    item.setFinished(true);
                    if (this.thread != item.getCallerThread()) {
                        object2 = this.queueThreadHistory;
                        synchronized (object2) {
                            if (this.queueThreadHistory.size() != 0) {
                                this.queueThreadHistory.remove(this.queueThreadHistory.size() - 1);
                            }
                        }
                    }
                    object2 = item;
                    synchronized (object2) {
                        item.notify();
                        break block35;
                    }
                }
            }
            catch (Throwable throwable) {
                Object object3;
                item.setFinished(true);
                if (this.thread != item.getCallerThread()) {
                    object3 = this.queueThreadHistory;
                    synchronized (object3) {
                        if (this.queueThreadHistory.size() != 0) {
                            this.queueThreadHistory.remove(this.queueThreadHistory.size() - 1);
                        }
                    }
                }
                object3 = item;
                synchronized (object3) {
                    item.notify();
                }
                throw throwable;
            }
            item.setFinished(true);
            if (this.thread != item.getCallerThread()) {
                object = this.queueThreadHistory;
                synchronized (object) {
                    if (this.queueThreadHistory.size() != 0) {
                        this.queueThreadHistory.remove(this.queueThreadHistory.size() - 1);
                    }
                }
            }
            object = item;
            synchronized (object) {
                item.notify();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueuePriority {
        HIGH,
        LOW,
        NORM;

    }
}

