/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.StringFormatter;

public class TimeFormatter {
    public static final int HIDE_SECONDS = 2;
    public static final int HIDE_MARKER = 4;
    public static final int CLOCK = 8;

    public static String formatMilliSeconds(long totalSeconds, int flags) {
        return TimeFormatter.formatSeconds(totalSeconds / 1000L, flags);
    }

    public static String formatSeconds(long totalSeconds, int flags) {
        StringBuilder string = new StringBuilder();
        long days = totalSeconds / 86400L;
        long hours = (totalSeconds -= days * 24L * 60L * 60L) / 3600L;
        long minutes = (totalSeconds -= hours * 60L * 60L) / 60L;
        long seconds = totalSeconds - minutes * 60L;
        if (!BinaryLogic.containsAll(flags, 8)) {
            if (days != 0L) {
                string.append(days);
                string.append('d');
            }
        } else if (days != 0L) {
            hours += days * 24L;
        }
        if (hours != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 8)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(hours);
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append('h');
            }
        }
        if (minutes != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 8)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(String.valueOf(minutes), 2, "0"));
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append('m');
            }
        }
        if (BinaryLogic.containsNone(flags, 2)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(String.valueOf(seconds), 2, "0"));
            if (BinaryLogic.containsNone(flags, 4)) {
                string.append('s');
            }
        }
        return string.toString();
    }

    public static long formatStringToMilliseconds(String text) {
        String[] found = new Regex(text, "(\\d+)\\w?:(\\d+)").getRow(0);
        if (found == null) {
            return 0L;
        }
        int hours = Integer.parseInt(found[0]);
        int minutes = Integer.parseInt(found[1]);
        if (hours >= 24) {
            hours = 24;
            minutes = 0;
        }
        if (minutes >= 60) {
            ++hours;
            minutes = 0;
        }
        return hours * 60 * 60 * 1000 + minutes * 60 * 1000;
    }

    public static long getMilliSeconds(String dateString, String timeformat, Locale l) {
        if (dateString != null) {
            SimpleDateFormat dateFormat = l != null ? new SimpleDateFormat(timeformat, l) : new SimpleDateFormat(timeformat);
            try {
                return dateFormat.parse(dateString).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    public static long getMilliSeconds(String wait) {
        String[][] matches = new Regex(wait, "([\\d]+) ?[\\.|\\,|\\:] ?([\\d]+)").getMatches();
        if (matches == null || matches.length == 0) {
            matches = new Regex(wait, Pattern.compile("([\\d]+)")).getMatches();
        }
        if (matches == null || matches.length == 0) {
            return -1L;
        }
        double res = 0.0;
        if (matches[0].length == 1) {
            res = Double.parseDouble(matches[0][0]);
        }
        if (matches[0].length == 2) {
            res = Double.parseDouble(String.valueOf(matches[0][0]) + "." + matches[0][1]);
        }
        res = Regex.matches((Object)wait, Pattern.compile("(h|st)", 2)) ? (res *= 3600000.0) : (Regex.matches((Object)wait, Pattern.compile("(m)", 2)) ? (res *= 60000.0) : (res *= 1000.0));
        return Math.round(res);
    }
}

