/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.locale.Translate;
import org.appwork.utils.logging.Log;

public class Loc {
    public static final File A_LOCALIZATION_DIR = Application.getRessource("languages/");
    public static final Storage CFG = JSonStorage.getStorage("Locale");
    private static HashMap<Integer, String> DATA = null;
    private static String DEFAULT_LOCALE_CACHE;
    private static final File DEFAULT_LOCALIZATION;
    private static final String FALLBACK_LOCALE = "en_GB";
    private static String locale;
    public static final String PROPERTY_LOCALE = "PROPERTY_LOCALE2";

    static {
        DEFAULT_LOCALIZATION = new File(A_LOCALIZATION_DIR, String.valueOf(Loc.getDefaultLocale()) + ".loc");
    }

    public static String _(Translate t) {
        return t.s();
    }

    public static String _(Translate t, Object ... parameter) {
        return t.s(parameter);
    }

    private static String getDefaultLocale() {
        String l;
        int n;
        int n2;
        String[] stringArray;
        if (DEFAULT_LOCALE_CACHE != null) {
            return DEFAULT_LOCALE_CACHE;
        }
        String sys = System.getProperty("user.language").toLowerCase();
        String cou = System.getProperty("user.country").toUpperCase();
        String[] locs = Loc.getLocales();
        if (locs.length == 0) {
            DEFAULT_LOCALE_CACHE = FALLBACK_LOCALE;
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(String.valueOf(sys) + "_" + cou)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(sys)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.startsWith(String.valueOf(sys) + "_")) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(FALLBACK_LOCALE)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            DEFAULT_LOCALE_CACHE = locs[0];
        }
        return DEFAULT_LOCALE_CACHE;
    }

    public static String getErrorRegex() {
        return Loc.L("system.error", ".*(error|failed).*");
    }

    public static String getLocale() {
        return locale;
    }

    public static String[] getLocales() {
        String[] files = A_LOCALIZATION_DIR.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".loc");
            }
        });
        if (files == null) {
            return new String[0];
        }
        int i = 0;
        while (i < files.length) {
            files[i] = files[i].replace(".loc", "");
            ++i;
        }
        return files;
    }

    public static String L(String key, String def) {
        String loc;
        if (key == null || (key = key.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        if (DATA == null) {
            Log.L.warning("No parsed localization found! Loading now from saved localization file!");
            try {
                Loc.setLocale(CFG.get(PROPERTY_LOCALE, FALLBACK_LOCALE));
            }
            catch (Exception e) {
                Log.L.severe("Error while loading the stored localization name!");
                Loc.setLocale(FALLBACK_LOCALE);
            }
            if (DATA == null) {
                return def == null ? "Error in Loc! No loaded data!" : def;
            }
        }
        if ((loc = DATA.get(key.toLowerCase().hashCode())) == null) {
            DATA.put(key.toLowerCase().hashCode(), def);
            return def;
        }
        return loc;
    }

    public static String LF(String key, String def, Object ... args) {
        try {
            return String.format(Loc.L(key, def), args);
        }
        catch (Exception e) {
            return "Error: " + key;
        }
    }

    public static void parseLocalization(File file) throws IllegalArgumentException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException();
        }
        if (DATA != null) {
            Log.L.finer("Previous HashMap will be overwritten!");
        }
        DATA = new HashMap();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        FileInputStream fis = null;
        try {
            try {
                String line;
                fis = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fis, "UTF8");
                reader = new BufferedReader(isr);
                while ((line = reader.readLine()) != null) {
                    int split;
                    if (line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                    String key = line.substring(0, split).toLowerCase().trim();
                    String value = line.substring(split + 1).trim();
                    value = value.replace("\\n", "\n").replace("\\r", "\r");
                    DATA.put(key.hashCode(), value);
                }
            }
            catch (Exception e) {
                Log.exception((Throwable)e);
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    isr.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
            try {
                isr.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setLocale(String loc) {
        try {
            if (loc == null) {
                loc = CFG.get(PROPERTY_LOCALE, Loc.getDefaultLocale());
            }
            File file = new File(A_LOCALIZATION_DIR, String.valueOf(loc) + ".loc");
            locale = loc;
            if (file != null && file.exists()) {
                String[] locs = loc.split("_");
                if (locs.length == 1) {
                    Locale.setDefault(new Locale(locs[0]));
                } else {
                    Locale.setDefault(new Locale(locs[0], locs[1]));
                }
                CFG.put(PROPERTY_LOCALE, loc);
                Loc.parseLocalization(file);
            } else {
                Log.L.info("The language " + loc + " isn't available! Parsing default (" + FALLBACK_LOCALE + ".loc) one!");
                locale = Loc.getDefaultLocale();
                String[] locs = locale.split("_");
                Locale.setDefault(new Locale(locs[0], locs[1]));
                Loc.parseLocalization(DEFAULT_LOCALIZATION);
            }
        }
        catch (Exception e) {
            Log.exception((Throwable)e);
        }
    }
}

