/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.locale.Loc;
import org.appwork.utils.locale.Translate;
import org.appwork.utils.parser.SourceParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateUtils {
    public static String checkTranslateFiles(SourceParser sourceParser, Class<?> clazz, boolean write) throws Exception {
        String path = String.valueOf(clazz.getName().replaceAll("\\.", "/")) + ".java";
        final File file = new File(sourceParser.getSource(), path);
        if (!file.exists()) {
            throw new Exception("File " + file + " does not exist");
        }
        sourceParser.setFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !new File(dir, name).equals(file);
            }
        });
        sourceParser.scan();
        String source = IO.readFileToString(file);
        Regex reg = new Regex(source, "(.*?\\{)");
        String pre = reg.getMatch(0);
        String post = new Regex(source, "(//\\s*ENDOFENUMS.*)").getMatch(0);
        source = source.replace(pre, "<pre>");
        if (post == null) {
            throw new Exception("Translate Enum must end with //ENDOFENUMS");
        }
        StringBuilder fin = new StringBuilder();
        fin.append(pre);
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())) {
                HashMap<File, String> occures = sourceParser.findOccurancesOf(f);
                if (occures.size() == 0) {
                    System.out.println("Filtered: " + f);
                } else {
                    String comment;
                    fin.append("\r\n");
                    String line = new Regex(source, String.valueOf(f.getName()) + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\, \\d+\\)[\\,\\;]").getMatch(-1);
                    if (line == null) {
                        line = new Regex(source, String.valueOf(f.getName()) + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\)[\\,\\;]").getMatch(-1);
                    }
                    if (line.contains("CHATPANEL_HISTORY_LASTWEEK")) {
                        System.out.println("fdsf");
                    }
                    if ((comment = new Regex(source, "\\/\\*(.*?)\\*\\/\\s*" + Pattern.quote(line)).getMatch(0)) != null) {
                        if (comment.contains("/*")) {
                            comment = TranslateUtils.handleMultiComment(comment);
                        }
                        if (comment.contains("Kontakt hinzuf\u00fcgen")) {
                            System.out.println("fdsf");
                        }
                        fin.append("/*\r\n");
                        fin.append(comment.trim());
                        fin.append("\r\n*/\r\n");
                        String full = new Regex(source, "(\\/\\*.*?\\*\\/\\s*" + Pattern.quote(line) + ")").getMatch(0);
                        source = source.replace(full, "---\r\n" + line);
                    }
                    fin.append(line);
                }
            }
            ++n2;
        }
        fin.append("");
        fin.append("\r\n");
        fin.append(post);
        System.out.println(fin);
        if (write) {
            file.delete();
            IO.writeStringToFile(file, fin.toString());
        }
        return fin.toString();
    }

    private static int countWildcards(String def) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = def.indexOf("%s", lastIndex)) == -1) continue;
            lastIndex += 2;
            ++count;
        }
        return count;
    }

    public static String createLocFile(String lng, File[] files, Class<?>[] classes) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n####  Translation: " + lng + "\r\n");
        Loc.setLocale(lng);
        int i = 0;
        while (i < classes.length) {
            Translate entry;
            Class<?> c = classes[i];
            File file = new File(files[i], String.valueOf(c.getName().replaceAll("\\.", "/")) + ".java");
            String source = IO.readFileToString(file);
            source = new Regex(source, "public\\s+enum.*?implements\\s+Translate\\s+\\{(.*)").getMatch(0);
            StringBuilder untrans = new StringBuilder();
            StringBuilder equals = new StringBuilder();
            Translate[] values = (Translate[])c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            sb.append("\r\n############################ " + c.getSimpleName() + " Entries: ");
            int max = 0;
            Translate[] translateArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                entry = translateArray[n2];
                max = Math.max(TranslateUtils.getName(entry).length(), max);
                ++n2;
            }
            translateArray = values;
            n = values.length;
            n2 = 0;
            while (n2 < n) {
                String translated;
                entry = translateArray[n2];
                String def = entry.getDefaultTranslation();
                String name = TranslateUtils.getName(entry);
                if (TranslateUtils.countWildcards(def) != entry.getWildCardCount()) {
                    throw new Exception("Wrong wildcard count in defaulttranslation: " + name + "=" + entry.getDefaultTranslation() + " WCC: " + entry.getWildCardCount());
                }
                StringBuilder dest = sb;
                String line = new Regex(source, String.valueOf(name) + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\, \\d+\\)[\\,\\;]").getMatch(-1);
                System.out.println(name);
                if (line == null) {
                    line = new Regex(source, String.valueOf(name) + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\)[\\,\\;]").getMatch(-1);
                }
                if (line == null) {
                    throw new Exception("SYNTAX line. PLease recompile");
                }
                String comment = new Regex(source, "\\/\\*(.*?)\\*\\/\\s*" + Pattern.quote(line)).getMatch(0);
                if (comment != null) {
                    comment = comment.replaceAll("\\s*\\*\\s*", " ");
                    if ((comment = new Regex(comment, "###" + lng + ":([^\r^\n]+)").getMatch(0)) != null) {
                        comment = comment.split("###")[0].trim();
                    }
                    source = source.replace(new Regex(source, "(\\/\\*.*?\\*\\/\\s*" + Pattern.quote(line) + ")").getMatch(0), "---\r\n" + line);
                }
                if ((translated = Loc.L(String.valueOf(c.getSimpleName()) + ":::" + name, comment != null ? comment : entry.getDefaultTranslation()).replace("\r", "\\r").replace("\n", "\\n")).equals(entry.getDefaultTranslation())) {
                    dest = equals;
                }
                if (translated == entry.getDefaultTranslation()) {
                    dest = untrans;
                }
                if (entry.getWildCardCount() > 0) {
                    dest.append("\r\n######");
                    dest.append(name);
                    dest.append("-wildcards: ");
                    dest.append(entry.getWildCardCount());
                }
                dest.append("\r\n" + c.getSimpleName() + ":::");
                dest.append(name);
                dest.append("      ");
                int ii = name.length();
                while (ii < max) {
                    dest.append(" ");
                    ++ii;
                }
                dest.append(" = ");
                dest.append(translated);
                ++n2;
            }
            if (untrans.length() > 0) {
                sb.append("\r\n################" + c.getSimpleName() + " Untranslated: \r\n");
                sb.append((CharSequence)untrans);
            }
            if (equals.length() > 0) {
                sb.append("\r\n################" + c.getSimpleName() + " Equals default: \r\n");
                sb.append((CharSequence)equals);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String getName(Translate entry) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        Field[] fieldArray = entry.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Field f = fieldArray[n2];
            if (f.isEnumConstant() && (value = f.get(null)) == entry) {
                return f.getName();
            }
            ++n2;
        }
        return null;
    }

    private static String handleMultiComment(String comment) {
        comment = new Regex(comment, ".*\\/\\*(.*)").getMatch(0);
        return comment;
    }
}

