/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.appwork.utils.net.DownloadProgress;

public class HTTP {
    public static void download(URL url, File file, DownloadProgress progress) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        file.createNewFile();
        FileOutputStream fos = null;
        FilterOutputStream output = null;
        BufferedInputStream input = null;
        GZIPInputStream gzi = null;
        boolean deleteInterrupted = false;
        HttpURLConnection con = null;
        try {
            try {
                int len;
                fos = new FileOutputStream(file, false);
                output = new BufferedOutputStream(fos);
                con = (HttpURLConnection)url.openConnection();
                con.setInstanceFollowRedirects(true);
                con.setConnectTimeout(15000);
                con.setReadTimeout(30000);
                if (url.openConnection().getHeaderField("Content-Encoding") != null && con.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                    gzi = new GZIPInputStream(con.getInputStream());
                    input = new BufferedInputStream(gzi);
                } else {
                    input = new BufferedInputStream(con.getInputStream());
                }
                if (progress != null) {
                    progress.setTotal(con.getContentLength());
                }
                byte[] b = new byte[Short.MAX_VALUE];
                while ((len = input.read(b)) != -1) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    ((BufferedOutputStream)output).write(b, 0, len);
                    if (progress == null) continue;
                    progress.increaseLoaded(len);
                }
            }
            catch (InterruptedException e) {
                deleteInterrupted = true;
                try {
                    input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    gzi.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    output.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    con.disconnect();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (deleteInterrupted) {
                    file.delete();
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
            try {
                gzi.close();
            }
            catch (Exception exception) {}
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                con.disconnect();
            }
            catch (Throwable throwable) {}
            if (deleteInterrupted) {
                file.delete();
            }
        }
    }
}

