/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.meteredconnection;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredOutputStream
extends OutputStream
implements SpeedMeterInterface {
    private OutputStream out;
    private SpeedMeterInterface speedmeter = null;
    private long transfered = 0L;
    private long transfered2 = 0L;
    private long time = 0L;
    private long speed = 0L;
    private int offset;
    private int checkStep = 1024;
    public static final int LOWStep = 1024;
    private int rest;
    private int todo;
    private long lastTime;
    private long lastTrans;
    private long timeForCheckStep = 0L;
    private int timeCheck = 0;

    public MeteredOutputStream(OutputStream out) {
        this.out = out;
    }

    public MeteredOutputStream(OutputStream out, SpeedMeterInterface speedmeter) {
        this.out = out;
        this.speedmeter = speedmeter;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transfered;
    }

    public int getCheckStepSize() {
        return this.checkStep;
    }

    public void setCheckStepSize(int step) {
        this.checkStep = Math.min(1024, this.checkStep);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.offset = off;
        this.rest = len;
        while (this.rest != 0) {
            this.todo = this.rest;
            if (this.todo > this.checkStep) {
                this.todo = this.checkStep;
            }
            this.timeForCheckStep = System.currentTimeMillis();
            this.out.write(b, this.offset, this.todo);
            this.timeCheck = (int)(System.currentTimeMillis() - this.timeForCheckStep);
            if (this.timeCheck > 1000) {
                this.checkStep = Math.max(1024, this.todo / this.timeCheck * 500);
            } else if (this.timeCheck == 0) {
                this.checkStep += 1024;
            }
            this.transfered += (long)this.todo;
            this.rest -= this.todo;
            this.offset += this.todo;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public synchronized long getSpeedMeter() {
        if (this.time == 0L) {
            this.time = System.currentTimeMillis();
            this.transfered2 = this.transfered;
            return 0L;
        }
        if (System.currentTimeMillis() - this.time < 1000L) {
            if (this.speedmeter != null) {
                return this.speedmeter.getSpeedMeter();
            }
            return this.speed;
        }
        this.lastTime = System.currentTimeMillis() - this.time;
        this.time = System.currentTimeMillis();
        this.lastTrans = this.transfered - this.transfered2;
        this.transfered2 = this.transfered;
        if (this.speedmeter != null) {
            this.speedmeter.putSpeedMeter(this.lastTrans, this.lastTime);
            return this.speedmeter.getSpeedMeter();
        }
        this.speed = this.lastTrans / this.lastTime * 1000L;
        return this.speed;
    }

    public void putSpeedMeter(long bytes, long time) {
    }

    public synchronized void resetSpeedMeter() {
        if (this.speedmeter != null) {
            this.speedmeter.resetSpeedMeter();
        }
        this.speed = 0L;
        this.transfered2 = this.transfered;
        this.time = System.currentTimeMillis();
    }
}

