/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.mime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.mime.MimeDefault;

public class MimeLinux
extends MimeDefault {
    public String getMimeDescription(String mimeType) {
        if (super.getMimeDescriptionCache(mimeType) != null) {
            return super.getMimeDescriptionCache(mimeType);
        }
        File file = new File("/usr/share/mime/" + mimeType + ".xml");
        if (!file.exists()) {
            return "Unknown";
        }
        String mime = "Unkown";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = in.readLine()) != null) {
                if (!line.contains("<comment>")) continue;
                Matcher m = Pattern.compile("<comment>(.*?)</comment>").matcher(line.trim());
                m.find();
                mime = m.group(1);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Log.exception((Throwable)e);
        }
        catch (IOException e) {
            Log.exception((Throwable)e);
        }
        super.saveMimeDescriptionCache(mimeType, mime);
        return mime;
    }
}

